/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.mixedMode.mono;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.mixedMode.XMixedModeHighLevelDebugProcessExtension;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.MixedModeRiderLLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.RiderCppDebugProcessStarter;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoNativeDebugProcess;
import com.jetbrains.rider.debugger.IMixedModeDebugAwareRunConfiguration;
import com.jetbrains.rider.debugger.mixed.mode.DotnetMonoMixedModeExtension;
import com.jetbrains.rider.debugger.mixed.mode.MixedModeDebugProcessStarter;
import com.jetbrains.rider.debugger.util.DebuggerWorkerProcessHandlerUtilKt;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfiguration;
import com.jetbrains.rider.run.configurations.remote.MonoAttachConfiguration;
import com.jetbrains.rider.run.configurations.unity.UnityAttachRunConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoDebugProcessStarter;", "Lcom/jetbrains/rider/debugger/mixed/mode/MixedModeDebugProcessStarter;", "<init>", "()V", "startNativeDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "runProfile", "Lcom/jetbrains/rider/debugger/IMixedModeDebugAwareRunConfiguration;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "sessionId", "", "getManagedDebugProcessExtension", "Lcom/intellij/xdebugger/mixedMode/XMixedModeHighLevelDebugProcessExtension;", "isApplicable", "", "intellij.rider.plugins.cpp"})
public final class MixedModeMonoDebugProcessStarter
implements MixedModeDebugProcessStarter {
    @NotNull
    public XDebugProcess startNativeDebugProcess(@NotNull IMixedModeDebugAwareRunConfiguration runProfile, @NotNull ProcessHandler processHandler, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, long sessionId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        if (!this.isApplicable(runProfile)) {
            throw new IllegalStateException("Mixed mode is not supported for this configuration".toString());
        }
        IMixedModeDebugAwareRunConfiguration iMixedModeDebugAwareRunConfiguration = runProfile;
        if (iMixedModeDebugAwareRunConfiguration instanceof MonoAttachConfiguration) {
            n = ((MonoAttachConfiguration)runProfile).getProcessInfo().getPid();
        } else if (iMixedModeDebugAwareRunConfiguration instanceof UnityAttachRunConfiguration) {
            Integer n2 = ((UnityAttachRunConfiguration)runProfile).getUnityEditorPid();
            if (n2 != null) {
                n = n2;
            } else {
                Integer n3 = DebuggerWorkerProcessHandlerUtilKt.tryGetTargetProcessId((ProcessHandler)processHandler);
                Integer n4 = n3 != null ? Integer.valueOf(n3) : null;
                if (n4 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                n = ((Number)n4).intValue();
            }
        } else {
            Integer n5 = DebuggerWorkerProcessHandlerUtilKt.tryGetTargetProcessId((ProcessHandler)processHandler);
            if (n5 != null) {
                n = n5;
            } else {
                throw new IllegalStateException("Not Supported".toString());
            }
        }
        int pid = n;
        MixedModeMonoNativeDebugProcess process = new MixedModeMonoNativeDebugProcess((DebuggerDriverConfiguration)new MixedModeRiderLLDBDriverConfiguration(pid), pid, session, consoleBuilder, sessionId);
        RiderCppDebugProcessStarter.Companion.startProcess(process);
        process.loadScripts();
        return (XDebugProcess)process;
    }

    @NotNull
    public XMixedModeHighLevelDebugProcessExtension getManagedDebugProcessExtension(@NotNull IMixedModeDebugAwareRunConfiguration runProfile) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        if (!this.isApplicable(runProfile)) {
            throw new IllegalStateException("Mixed mode is not supported for this configuration".toString());
        }
        return (XMixedModeHighLevelDebugProcessExtension)new DotnetMonoMixedModeExtension();
    }

    private final boolean isApplicable(IMixedModeDebugAwareRunConfiguration runProfile) {
        IMixedModeDebugAwareRunConfiguration iMixedModeDebugAwareRunConfiguration = runProfile;
        return iMixedModeDebugAwareRunConfiguration instanceof MonoAttachConfiguration || iMixedModeDebugAwareRunConfiguration instanceof UnityAttachRunConfiguration || iMixedModeDebugAwareRunConfiguration instanceof DotNetProjectConfiguration;
    }
}

