/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.mixedMode.mono;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedMonoLLDBDriver;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "monoDebugThreads", "", "", "getMonoDebugThreads", "()Ljava/util/Set;", "stopHereMayBreakDebugger", "", "driver", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;", "stopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nMixedModeMonoCorrectStateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixedModeMonoCorrectStateChecker.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoCorrectStateCheckerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,24:1\n1#2:25\n13#3:26\n15#4:27\n*S KotlinDebug\n*F\n+ 1 MixedModeMonoCorrectStateChecker.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoCorrectStateCheckerKt\n*L\n7#1:26\n7#1:27\n*E\n"})
public final class MixedModeMonoCorrectStateCheckerKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<String> monoDebugThreads;

    @NotNull
    public static final Set<String> getMonoDebugThreads() {
        return monoDebugThreads;
    }

    public static final boolean stopHereMayBreakDebugger(@NotNull MonoMixedMonoLLDBDriver driver, @NotNull DebuggerDriver.StopPlace stopPlace) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)driver), (String)"driver");
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        if (monoDebugThreads.contains(stopPlace.thread.getName())) {
            logger.info("We are stopped in mono debugger dedicated threads. It's better to continue execution asap");
            return true;
        }
        String command = "jb_stop_here_may_break_mixed_debug " + stopPlace.thread.getTid();
        String it = string = driver.executeInterpreterCommand(command);
        boolean bl = false;
        logger.info("Command " + command + " returned " + it);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"also(...)");
        char[] cArray = new char[]{'\n'};
        boolean stopMayLeadToDebuggerBreak = Boolean.parseBoolean((String)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null).get(0));
        return stopMayLeadToDebuggerBreak;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MixedModeMonoCorrectStateCheckerKt.logger = logger;
        monoDebugThreads = SetsKt.setOf((Object)"Debugger agent");
    }
}

