/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.editorNotifiers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.EDT;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.cpp.RiderCppBundle;
import com.jetbrains.rider.cpp.debugger.CppDebugSessionData;
import com.jetbrains.rider.cpp.debugger.modulesView.ProcessUtilsFuncsKt;
import com.jetbrains.rider.ui.RiderEditorNotifier;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/cpp/debugger/editorNotifiers/UseMacDebugSymbolsPromoter;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "tryPromoteUseMacDebugSymbols", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "showMacDebugSymbolsPromotionNotification", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getNotifier", "Lcom/jetbrains/rider/ui/RiderEditorNotifier;", "shouldPromoteDebugSymbols", "", "isDsymExists", "module", "Lcom/jetbrains/cidr/execution/debugger/backend/LLModule;", "doesSymbolFileExist", "dsymPath", "Ljava/nio/file/Path;", "isModuleInsideAppBundle", "modulePath", "", "moduleFileName", "getAppBundlePath", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppMacSymbolsNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppMacSymbolsNotifier.kt\ncom/jetbrains/rider/cpp/debugger/editorNotifiers/UseMacDebugSymbolsPromoter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,157:1\n1#2:158\n25#3:159\n*S KotlinDebug\n*F\n+ 1 RiderCppMacSymbolsNotifier.kt\ncom/jetbrains/rider/cpp/debugger/editorNotifiers/UseMacDebugSymbolsPromoter\n*L\n26#1:159\n*E\n"})
public final class UseMacDebugSymbolsPromoter {
    @NotNull
    public static final UseMacDebugSymbolsPromoter INSTANCE;
    @NotNull
    private static final Logger logger;

    private UseMacDebugSymbolsPromoter() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    public final void tryPromoteUseMacDebugSymbols(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        if (!this.shouldPromoteDebugSymbols()) {
            return;
        }
        LifetimeDefinition lifetime = CppDebugSessionData.Companion.getSessionLifetime(process).createNested();
        Ref.BooleanRef oneOfModulesHasSymbolFile = new Ref.BooleanRef();
        ProcessUtilsFuncsKt.getModules(process).view((Lifetime)lifetime, (arg_0, arg_1, arg_2) -> UseMacDebugSymbolsPromoter.tryPromoteUseMacDebugSymbols$lambda$0(oneOfModulesHasSymbolFile, arg_0, arg_1, arg_2));
        XDebugSession xDebugSession = process.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession session = xDebugSession;
        session.addSessionListener(new XDebugSessionListener(oneOfModulesHasSymbolFile, lifetime, process, session){
            final /* synthetic */ Ref.BooleanRef $oneOfModulesHasSymbolFile;
            final /* synthetic */ LifetimeDefinition $lifetime;
            final /* synthetic */ CidrDebugProcess $process;
            final /* synthetic */ XDebugSession $session;
            {
                this.$oneOfModulesHasSymbolFile = $oneOfModulesHasSymbolFile;
                this.$lifetime = $lifetime;
                this.$process = $process;
                this.$session = $session;
            }

            public void sessionPaused() {
                UseMacDebugSymbolsPromoter.INSTANCE.getLogger().trace("Session paused");
                if (!this.$oneOfModulesHasSymbolFile.element) {
                    return;
                }
                if (!UseMacDebugSymbolsPromoter.access$shouldPromoteDebugSymbols(UseMacDebugSymbolsPromoter.INSTANCE)) {
                    return;
                }
                Lifetime lifetime = (Lifetime)this.$lifetime;
                Project project = this.$process.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
                UseMacDebugSymbolsPromoter.INSTANCE.showMacDebugSymbolsPromotionNotification(lifetime, project, this.$session);
            }
        });
    }

    public final void showMacDebugSymbolsPromotionNotification(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull XDebugSession session) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession((Project)project).getAppSession());
            XSourcePosition xSourcePosition = session.getCurrentPosition();
            if (xSourcePosition == null) {
                return;
            }
            XSourcePosition pos = xSourcePosition;
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)textControlHost.getEditors()), arg_0 -> UseMacDebugSymbolsPromoter.showMacDebugSymbolsPromotionNotification$lambda$1(project, arg_0));
            for (Object e : sequence) {
                Editor editor = (Editor)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)editor.getVirtualFile(), (Object)pos.getFile())) continue;
                v1 = e;
                break block3;
            }
            v1 = null;
        }
        Editor editor = v1;
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TextEditor textEditor = TextEditorProvider.Companion.getInstance().getTextEditor(editor2);
        this.getNotifier(lifetime, project).showNotification(textEditor);
    }

    private final RiderEditorNotifier getNotifier(Lifetime lifetime, Project project) {
        RiderEditorNotifier riderEditorNotifier;
        RiderEditorNotifier $this$getNotifier_u24lambda_u244 = riderEditorNotifier = new RiderEditorNotifier(project, lifetime);
        boolean bl = false;
        $this$getNotifier_u24lambda_u244.setPanelText(RiderCppBundle.Companion.message("cpp.debugger.promote.dsym.loading.message", new Object[0]));
        $this$getNotifier_u24lambda_u244.setKeyName("PromoteDSymLoad");
        String string = CidrDebuggerBundle.message((String)"debug.settings.macOS.load.dsym.near.binaries", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        RiderEditorNotifier.defineSettingsAction$default((RiderEditorNotifier)$this$getNotifier_u24lambda_u244, null, (String)"Debugger.C.SymbolServers", (String)string, (boolean)true, null, (int)17, null);
        RiderEditorNotifier.defineDontShowAgainAction$default((RiderEditorNotifier)$this$getNotifier_u24lambda_u244, null, UseMacDebugSymbolsPromoter::getNotifier$lambda$4$lambda$3, (int)1, null);
        RiderEditorNotifier.defineHideAction$default((RiderEditorNotifier)$this$getNotifier_u24lambda_u244, null, null, (int)3, null);
        return riderEditorNotifier;
    }

    private final boolean shouldPromoteDebugSymbols() {
        boolean bl;
        CidrDebuggerSettings cidrDebuggerSettings = CidrDebuggerSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebuggerSettings, (String)"getInstance(...)");
        CidrDebuggerSettings settings = cidrDebuggerSettings;
        if (!SystemInfo.isMac) {
            logger.trace("Don't promote 'loadDSymNearBinaries' on non-macOS");
            bl = false;
        } else if (settings.getMacOSSymbolSettings().getLoadDSymNearBinaries()) {
            logger.trace("Setting 'loadDSymNearBinaries' already enabled");
            bl = false;
        } else if (!settings.getMacOSSymbolSettings().getPromoteLoadDSymNearBinaries()) {
            logger.trace("Setting 'promoteLoadDSymNearBinaries' disabled");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean isDsymExists(LLModule module) {
        logger.trace("Checking if symbol file exists for module " + module.getName());
        Path modulePath = Path.of(module.getPath(), new String[0]);
        Intrinsics.checkNotNull((Object)modulePath);
        String moduleFileNameWithoutExt = PathsKt.getNameWithoutExtension((Path)modulePath);
        String dsymFileName = moduleFileNameWithoutExt + ".dSYM";
        Path dsymPath = modulePath.resolveSibling(dsymFileName);
        Intrinsics.checkNotNull((Object)dsymPath);
        if (this.doesSymbolFileExist(dsymPath)) {
            logger.trace("Symbol file for module " + module.getName() + " found at " + dsymPath);
            return true;
        }
        if (this.isModuleInsideAppBundle(module.getPath(), moduleFileNameWithoutExt)) {
            Path appBundlePath = this.getAppBundlePath(modulePath);
            Path dsymNearAppBundlePath = appBundlePath.resolveSibling(dsymFileName);
            Intrinsics.checkNotNull((Object)dsymNearAppBundlePath);
            if (this.doesSymbolFileExist(dsymNearAppBundlePath)) {
                logger.trace("Symbol file for module " + module.getName() + " found at " + dsymPath);
                return true;
            }
        }
        return false;
    }

    private final boolean doesSymbolFileExist(Path dsymPath) {
        return dsymPath.toFile().exists();
    }

    private final boolean isModuleInsideAppBundle(String modulePath, String moduleFileName) {
        return StringsKt.contains$default((CharSequence)modulePath, (CharSequence)(moduleFileName + ".app/Contents/MacOS/" + moduleFileName), (boolean)false, (int)2, null);
    }

    private final Path getAppBundlePath(Path modulePath) {
        Path path = modulePath.getParent().getParent().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        return path;
    }

    private static final Unit tryPromoteUseMacDebugSymbols$lambda$0(Ref.BooleanRef $oneOfModulesHasSymbolFile, Lifetime lifetime, int n, Pair rdModule) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)rdModule, (String)"rdModule");
        if (!EDT.isCurrentThreadEdt()) {
            logger.error("Not in EDT");
        }
        LLModule module = (LLModule)rdModule.getFirst();
        logger.trace("Module " + module.getName() + " loading");
        boolean isSymbolFileExistsForModule = INSTANCE.isDsymExists(module);
        if (isSymbolFileExistsForModule) {
            $oneOfModulesHasSymbolFile.element = true;
        }
        return Unit.INSTANCE;
    }

    private static final boolean showMacDebugSymbolsPromotionNotification$lambda$1(Project $project, Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return Intrinsics.areEqual((Object)editor.getProject(), (Object)$project);
    }

    private static final Unit getNotifier$lambda$4$lambda$3(DataContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CidrDebuggerSettings.getInstance().getMacOSSymbolSettings().setPromoteLoadDSymNearBinaries(false);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$shouldPromoteDebugSymbols(UseMacDebugSymbolsPromoter $this) {
        return $this.shouldPromoteDebugSymbols();
    }

    static {
        UseMacDebugSymbolsPromoter $this$thisLogger$iv = INSTANCE = new UseMacDebugSymbolsPromoter();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UseMacDebugSymbolsPromoter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UseMacDebugSymbolsPromoter.logger = logger;
    }
}

