/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.NioPathUtil;
import com.jetbrains.cidr.execution.debugger.NativeSelfProfilerPathProvider;
import com.jetbrains.cidr.execution.debugger.NativeSelfProfilerPaths;
import com.jetbrains.rider.RiderEnvironment;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderNativeSelfProfilerPathProvider;", "Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilerPathProvider;", "<init>", "()V", "getProfilerPaths", "Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilerPaths;", "getAdditionalProbingPaths", "", "Ljava/nio/file/Path;", "intellij.rider.plugins.cpp"})
public final class RiderNativeSelfProfilerPathProvider
extends NativeSelfProfilerPathProvider {
    @NotNull
    public NativeSelfProfilerPaths getProfilerPaths() {
        Path profiler = RiderEnvironment.INSTANCE.getBundledBinDir().toPath().resolve("JetBrains.ReSharperCpp.NativeSelfProfiler.exe");
        Intrinsics.checkNotNull((Object)profiler);
        return new NativeSelfProfilerPaths(profiler, this.getAdditionalProbingPaths());
    }

    private final List<Path> getAdditionalProbingPaths() {
        Path dotCommon;
        if (PluginManagerCore.isRunningFromSources() || AppMode.isDevServer()) {
            return CollectionsKt.emptyList();
        }
        String string = PathManager.getPreInstalledPluginsPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPreInstalledPluginsPath(...)");
        Path path = NioPathUtil.toNioPathOrNull((String)string);
        Path path2 = path != null && (path = path.resolve("dotCommon")) != null ? path.resolve("DotFiles") : (dotCommon = null);
        if (dotCommon == null) {
            return CollectionsKt.emptyList();
        }
        Path backendLocation = RiderEnvironment.INSTANCE.getBundledBinDir().toPath();
        Object[] objectArray = new Path[]{backendLocation, dotCommon};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

