/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisContext;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileLocationUtilsKt;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileProvider;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider;", "Lcom/jetbrains/cidr/execution/debugger/formatters/natvis/NatvisFileProvider;", "<init>", "()V", "getNatvisPaths", "", "", "context", "Lcom/jetbrains/cidr/execution/debugger/formatters/natvis/NatvisContext;", "getVisualStudioRootDirectory", "Ljava/nio/file/Path;", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppNatvisFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppNatvisFileProvider.kt\ncom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1557#2:94\n1628#2,3:95\n1557#2:98\n1628#2,3:99\n*S KotlinDebug\n*F\n+ 1 RiderCppNatvisFileProvider.kt\ncom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider\n*L\n46#1:94\n46#1:95,3\n49#1:98\n49#1:99,3\n*E\n"})
public final class RiderCppNatvisFileProvider
implements NatvisFileProvider {
    @NotNull
    public List<String> getNatvisPaths(@NotNull NatvisContext context) {
        Path it;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Looking for visual studio debugger package natvis files");
        Path vsRootDir = this.getVisualStudioRootDirectory(SolutionHostExtensionsKt.getSolution((Project)context.getProject()));
        if (vsRootDir == null) {
            CidrDebuggerLog.LOG.warn("NatvisFileProvider: Visual studio root directory was not found: check the path to the selected msbuild");
            return CollectionsKt.emptyList();
        }
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Detected visual studio root directory: '" + vsRootDir + "'");
        Path vsVisualizersDir = NatvisFileLocationUtilsKt.getVisualStudioSystemVisualizersDir((Path)vsRootDir);
        if (vsVisualizersDir == null) {
            CidrDebuggerLog.LOG.warn("NatvisFileProvider: Folder with visual studio natvis files was not found");
            return CollectionsKt.emptyList();
        }
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Detected folder with packaged natvis: '" + vsVisualizersDir + "'");
        List foundNatvisFiles = CollectionsKt.toMutableList((Collection)NatvisFileProvider.Companion.listNatvisFilesInDirectory(vsVisualizersDir));
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Found " + foundNatvisFiles.size() + " natvis files");
        Path userVisualizersDir = NatvisFileLocationUtilsKt.getVisualStudioUserVisualizersDir((Path)vsRootDir);
        CidrDebuggerLog.LOG.debug("NatvisFileProvider: Folder with user natvis: '" + userVisualizersDir + "'");
        if (userVisualizersDir != null) {
            foundNatvisFiles.addAll(NatvisFileProvider.Companion.listNatvisFilesInDirectory(userVisualizersDir));
            CidrDebuggerLog.LOG.debug("NatvisFileProvider: Found " + foundNatvisFiles.size() + " natvis files");
        }
        if (!((Collection)foundNatvisFiles).isEmpty()) {
            Iterable iterable = foundNatvisFiles;
            object = CidrDebuggerLog.LOG;
            $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PathsKt.getName((Path)it));
            }
            object.debug("NatvisFileProvider: Found natvis files: '" + (List)destination$iv$iv + "'");
        }
        $this$map$iv = foundNatvisFiles;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Path)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Object)it.toAbsolutePath()).toString());
        }
        return (List)destination$iv$iv;
    }

    private final Path getVisualStudioRootDirectory(Solution solution) {
        String string = (String)solution.getActiveMsBuildPath().getValue();
        if (string == null) {
            return null;
        }
        String msBuildStr = string;
        Path path = Paths.get(msBuildStr, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path msBuildPath = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(msBuildPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        String string2 = PathsKt.getName((Path)msBuildPath).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string2, (Object)"msbuild.exe")) {
            Path msBuildBinPath;
            String string3;
            Object object = msBuildPath.getParent();
            if (object != null && (object = PathsKt.getName((Path)object)) != null) {
                String string4 = ((String)object).toLowerCase(Locale.ROOT);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            } else {
                string3 = null;
            }
            if (Intrinsics.areEqual(string3, (Object)"bin")) {
                v7 = msBuildPath.getParent();
            } else {
                String string5;
                Object object2 = msBuildPath.getParent();
                if (object2 != null && (object2 = object2.getParent()) != null && (object2 = PathsKt.getName((Path)object2)) != null) {
                    String string6 = ((String)object2).toLowerCase(Locale.ROOT);
                    string5 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                } else {
                    string5 = null;
                }
                if (Intrinsics.areEqual(string5, (Object)"bin")) {
                    Path path2 = msBuildPath.getParent();
                    v7 = path2 != null ? path2.getParent() : null;
                } else {
                    v7 = msBuildBinPath = null;
                }
            }
            if (msBuildBinPath != null) {
                Path vsRoot;
                Path path3 = msBuildBinPath.getParent();
                Path path4 = path3 != null && (path3 = path3.getParent()) != null ? path3.getParent() : (vsRoot = null);
                if (vsRoot != null) {
                    Object[] objectArray = new String[]{"Preview", "Community", "Professional", "Enterprise", "Build Tools"};
                    Object[] vsTypes = objectArray;
                    if (!ArraysKt.contains((Object[])vsTypes, (Object)PathsKt.getName((Path)vsRoot))) {
                        CidrDebuggerLog.LOG.warn("NatvisFileProvider: '" + vsRoot + "' is detected as suspicious visual studio root directory");
                    }
                    return vsRoot;
                }
            }
        }
        CidrDebuggerLog.LOG.warn("NatvisFileProvider: '" + msBuildPath + "' is not a msbuild bundled with visual studio. Couldn't find vs debugger package with bundled natvis files");
        return null;
    }
}

