/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class UnescapeFilterReader
extends FilterReader {
    public UnescapeFilterReader(Reader r) {
        super(r);
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c == 13) {
            this.mark(1);
            c = this.in.read();
            if (c != 10) {
                this.reset();
            }
            return 10;
        }
        if (c == 12) {
            return 10;
        }
        if (c == 0) {
            return 4093;
        }
        if (c >= 55296 && c <= 57343) {
            return 65533;
        }
        if (c != 92) {
            return c;
        }
        this.in.mark(6);
        int val = 0;
        for (int i = 0; i < 6; ++i) {
            int esc = this.in.read();
            if (esc > 47 && esc < 58) {
                val = (val << 4) + (esc - 48);
                continue;
            }
            if (esc > 64 && esc < 71) {
                val = (val << 4) + (esc - 55);
                continue;
            }
            if (esc > 96 && esc < 103) {
                val = (val << 4) + (esc - 87);
                continue;
            }
            if (esc == 10 || esc == 9 || esc == 32) {
                if ((val <= 96 || val >= 123) && (val <= 64 || val >= 91)) continue;
                return val;
            }
            if (val > 96 && val < 123 || val > 64 && val < 91) {
                this.in.reset();
                ++i;
                for (int j = 0; j < i; ++j) {
                    this.in.read();
                }
                return val;
            }
            this.in.reset();
            return c;
        }
        if (!(val > 96 && val < 123 || val > 64 && val < 91)) {
            this.in.reset();
            return c;
        }
        this.mark(1);
        c = this.in.read();
        if (c != 10 && c != 9 && c != 32) {
            this.in.reset();
        }
        return val;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        boolean ignoreEscape = false;
        char[] chars = new char[len + 8];
        this.in.mark(len + 8);
        int l = super.read(chars, 0, len + 8);
        if (l <= 0) {
            return l;
        }
        int j = 0;
        for (i = 0; i < l && j < len; ++i) {
            if (chars[i] == '\r') {
                chars[j++] = 10;
                if (i + 1 < l && chars[i + 1] == '\n') {
                    ++i;
                }
            } else if (chars[i] == '\f') {
                chars[j++] = 10;
            } else if (chars[i] == '\u0000') {
                chars[j++] = 65533;
            } else if (chars[i] >= '\ud800' && chars[i] <= '\udfff') {
                chars[j++] = 65533;
            }
            if (chars[i] == '\\') {
                char cki;
                int k;
                int val = 0;
                boolean escaped = false;
                ignoreEscape = false;
                for (k = 1; k < 7 && k + i < l; ++k) {
                    cki = chars[k + i];
                    if (cki > '/' && cki < ':') {
                        val = (val << 4) + (cki - 48);
                        continue;
                    }
                    if (cki > '@' && cki < 'G') {
                        val = (val << 4) + (cki - 55);
                        continue;
                    }
                    if (cki > '`' && cki < 'g') {
                        val = (val << 4) + (cki - 87);
                        continue;
                    }
                    if (cki == '\n' || cki == '\t' || cki == ' ') {
                        if (val > 96 && val < 123 || val > 64 && val < 91) {
                            chars[j++] = (char)val;
                            escaped = true;
                            i += k;
                            break;
                        }
                        escaped = true;
                        ignoreEscape = true;
                        break;
                    }
                    if (val == 0 && (cki > '`' && cki < '{' || cki > '@' && cki < '[')) {
                        ++i;
                        ignoreEscape = true;
                        break;
                    }
                    if (val > 96 && val < 123 || val > 64 && val < 91) {
                        chars[j++] = (char)val;
                        escaped = true;
                        i += k - 1;
                        break;
                    }
                    ignoreEscape = true;
                    break;
                }
                if (!ignoreEscape) {
                    if (k == 7 && !escaped) {
                        if (val > 96 && val < 123 || val > 64 && val < 91) {
                            chars[j++] = (char)val;
                            escaped = true;
                            if ((i += k - 1) + 1 >= l || (cki = chars[i + 1]) != '\n' && cki != '\t' && cki != ' ') continue;
                            ++i;
                            continue;
                        }
                        ignoreEscape = true;
                        chars[j++] = chars[i];
                        continue;
                    }
                    if (escaped) continue;
                    if (j != 0) {
                        this.in.reset();
                        this.in.skip(i);
                        break;
                    }
                    chars[j++] = chars[i];
                    continue;
                }
                chars[j++] = chars[i];
                continue;
            }
            chars[j++] = chars[i];
        }
        System.arraycopy(chars, 0, cbuf, off, j);
        if (i < l) {
            this.in.reset();
            this.in.skip(i);
        }
        return j;
    }
}

