/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.Platform;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.PathUtilRt;
import com.intellij.util.text.StringKt;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshEnvironment;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfiguration;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0000\u001a,\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u001e\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\"\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"createRemoteDirectory", "", "Lcom/intellij/ssh/ConnectionBuilder;", "targetPlatform", "Lcom/intellij/execution/Platform;", "configuration", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfiguration;", "remoteRootPath", "prefix", "createRemoteTemporaryDirectory", "directory", "tryMktemp", "preparedDirectory", "createTargetDirIfNotExists", "", "targetPath", "sftpChannel", "Lcom/intellij/ssh/channels/SftpChannel;", "killAndReportError", "", "Ljava/lang/Process;", "info", "reportError", "errorCode", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nSshTargetUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshTargetUtil.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n1#2:108\n15#3:109\n*S KotlinDebug\n*F\n+ 1 SshTargetUtil.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetUtilKt\n*L\n107#1:109\n*E\n"})
public final class SshTargetUtilKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String createRemoteDirectory(@NotNull ConnectionBuilder $this$createRemoteDirectory, @NotNull Platform targetPlatform, @NotNull SshTargetEnvironmentConfiguration configuration, @Nullable String remoteRootPath, @Nullable String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$createRemoteDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        if (remoteRootPath != null) {
            Closeable closeable = (Closeable)ConnectionBuilder.openFailSafeSftpChannel$default((ConnectionBuilder)$this$createRemoteDirectory, (int)0, null, (int)3, null);
            Throwable throwable = null;
            try {
                SftpChannel sftpChannel = (SftpChannel)closeable;
                boolean bl = false;
                RemoteFileObject file = sftpChannel.file(remoteRootPath);
                if (!file.exists()) {
                    SshTargetUtilKt.createTargetDirIfNotExists(remoteRootPath, sftpChannel);
                } else if (!file.isDir()) {
                    Object[] objectArray = new Object[]{remoteRootPath};
                    String string2 = RemoteSdkBundle.message("error.message.remote.file.0.exists.and.isn.t.a.directory", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    String string3 = string2;
                    throw new IllegalStateException(string3.toString());
                }
                char[] cArray = new char[]{targetPlatform.fileSeparator};
                String string4 = StringsKt.trimEnd((String)remoteRootPath, (char[])cArray);
                string = string4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string = SshTargetUtilKt.createRemoteTemporaryDirectory($this$createRemoteDirectory, targetPlatform, configuration.getProjectRootOnTarget(), prefix);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String createRemoteTemporaryDirectory(@NotNull ConnectionBuilder $this$createRemoteTemporaryDirectory, @NotNull Platform targetPlatform, @Nullable String directory, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$createRemoteTemporaryDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        switch (WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
            case 1: {
                if (directory == null) ** GOTO lbl-1000
                it = var6_4 = directory;
                $i$a$-takeIf-SshTargetUtilKt$createRemoteTemporaryDirectory$preparedDirectory$1 = false;
                v0 = var5_9 = ((CharSequence)it).length() > 0 != false ? var6_4 : null;
                if (var5_9 == null) ** GOTO lbl-1000
                var7_5 = var5_9;
                it = var7_5;
                $i$a$-also-SshTargetUtilKt$createRemoteTemporaryDirectory$preparedDirectory$2 = false;
                if (!StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) {
                    $i$a$-require-SshTargetUtilKt$createRemoteTemporaryDirectory$preparedDirectory$2$1 = false;
                    var11_16 = new Object[]{it};
                    v1 = RemoteSdkBundle.message("error.message.relative.paths.aren.t.supported.tried.0", var11_16);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(...)");
                    $i$a$-require-SshTargetUtilKt$createRemoteTemporaryDirectory$preparedDirectory$2$1 = v1;
                    throw new IllegalArgumentException($i$a$-require-SshTargetUtilKt$createRemoteTemporaryDirectory$preparedDirectory$2$1.toString());
                }
                it = new char[1];
                it[0] = 47;
                if ((var7_5 = StringsKt.trimEnd((String)var7_5, (char[])it)) != null) {
                    dir = it = var7_5;
                    $i$a$-also-SshTargetUtilKt$createRemoteTemporaryDirectory$preparedDirectory$3 = false;
                    process = ExecBuilder.execute$default((ExecBuilder)$this$createRemoteTemporaryDirectory.execBuilder("mkdir -p " + CommandLineUtil.posixQuote((String)dir)), (int)10, (boolean)false, (int)2, null);
                    $i$a$-let-SshTargetUtilKt$createRemoteTemporaryDirectory$preparedDirectory$3$1 = false;
                    if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                    }
                    v2 = it;
                } else lbl-1000:
                // 3 sources

                {
                    v2 = null;
                }
                preparedDirectory = v2;
                v3 = $this$createRemoteTemporaryDirectory;
                v4 = preparedDirectory;
                v5 = StringKt.nullize$default((String)prefix, (boolean)false, (int)1, null);
                if (v5 != null) {
                    it = v5;
                    var14_21 = v4;
                    var13_22 = v3;
                    $i$a$-let-SshTargetUtilKt$createRemoteTemporaryDirectory$1 = false;
                    var15_23 = it + "-";
                    v3 = var13_22;
                    v4 = var14_21;
                    v6 = var15_23;
                    v5 = v6;
                    if (v6 != null) break;
                }
                v5 = "";
                break;
            }
            case 2: {
                var4_20 = "creation of temporary directory on remote Windows over SSH is not implemented";
                throw new NotImplementedError("An operation is not implemented: " + var4_20);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return SshTargetUtilKt.tryMktemp(v3, v4, (String)v5);
    }

    public static /* synthetic */ String createRemoteTemporaryDirectory$default(ConnectionBuilder connectionBuilder, Platform platform, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return SshTargetUtilKt.createRemoteTemporaryDirectory(connectionBuilder, platform, string, string2);
    }

    private static final String tryMktemp(ConnectionBuilder $this$tryMktemp, String preparedDirectory, String prefix) {
        Integer errorCode;
        Object object;
        block6: {
            block5: {
                object = preparedDirectory;
                if (object == null) break block5;
                String it = object;
                boolean bl2 = false;
                String string = it + "/";
                object = string;
                if (string != null) break block6;
            }
            object = "${TMPDIR:-/tmp}/";
        }
        char[] cArray = new char[]{' '};
        String string = StringUtil.escapeChars((String)((String)object + prefix + "XXXXXXXXXX"), (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeChars(...)");
        String path = string;
        String command = "mktemp -d " + path;
        SshExecProcess process = ExecBuilder.execute$default((ExecBuilder)$this$tryMktemp.execBuilder(command), (int)10, (boolean)false, (int)2, null);
        boolean bl = false;
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream bl2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(bl2, charset);
        int n = 8192;
        String result = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        Reader it = reader = process;
        boolean bl3 = false;
        Reader reader2 = it.waitFor(10L, TimeUnit.SECONDS) ? reader : null;
        Integer n2 = errorCode = reader2 != null ? Integer.valueOf(reader2.exitValue()) : null;
        if (n2 == null || n2 != 0) {
            if (errorCode == null) {
                SshTargetUtilKt.killAndReportError((Process)process, command);
                throw new KotlinNothingValueException();
            }
            SshTargetUtilKt.reportError((Process)process, command, errorCode);
            throw new KotlinNothingValueException();
        }
        return ((Object)StringsKt.trim((CharSequence)result)).toString();
    }

    @ApiStatus.Internal
    public static final void createTargetDirIfNotExists(@NotNull String targetPath, @NotNull SftpChannel sftpChannel) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)sftpChannel, (String)"sftpChannel");
        String dirToCreate = targetPath;
        LinkedList<String> dirsToCreate = new LinkedList<String>();
        while (((CharSequence)dirToCreate).length() > 0) {
            dirsToCreate.push(dirToCreate);
            dirToCreate = PathUtilRt.getParentPath((String)dirToCreate);
        }
        while (!dirsToCreate.isEmpty()) {
            Object e = dirsToCreate.pop();
            Intrinsics.checkNotNullExpressionValue(e, (String)"pop(...)");
            RemoteFileObject file = sftpChannel.file((String)e);
            if (file.exists()) continue;
            file.mkdir();
        }
    }

    private static final Void killAndReportError(Process $this$killAndReportError, String info) {
        $this$killAndReportError.destroyForcibly();
        $this$killAndReportError.waitFor(1L, TimeUnit.SECONDS);
        InputStream inputStream = $this$killAndReportError.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        InputStreamReader s = new InputStreamReader(inputStream2, charset);
        boolean bl = false;
        String availableStderr = SequencesKt.joinToString$default((Sequence)SequencesKt.generateSequence(() -> SshTargetUtilKt.killAndReportError$lambda$12$lambda$11(s)), (CharSequence)"", null, null, (int)0, null, SshTargetUtilKt::killAndReportError$lambda$13, (int)30, null);
        LOG.warn("Process `" + info + "` timed out. Available stderr:\n" + availableStderr);
        throw new IllegalStateException(("Process `" + info + "` timed out").toString());
    }

    private static final Void reportError(Process $this$reportError, String info, int errorCode) {
        InputStream inputStream = $this$reportError.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        String stderr = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        String errorMessage = "Process `" + info + "` exited with code " + errorCode + ".\n" + (String)(!StringsKt.isBlank((CharSequence)stderr) ? "Available stderr:\n" + stderr : "");
        LOG.warn(errorMessage);
        throw new IllegalStateException(errorMessage.toString());
    }

    private static final Integer killAndReportError$lambda$12$lambda$11(InputStreamReader $s) {
        InputStreamReader inputStreamReader;
        InputStreamReader it = inputStreamReader = $s;
        boolean bl = false;
        InputStreamReader inputStreamReader2 = it.ready() ? inputStreamReader : null;
        return inputStreamReader2 != null ? Integer.valueOf(inputStreamReader2.read()) : null;
    }

    private static final CharSequence killAndReportError$lambda$13(int it) {
        return String.valueOf((char)it);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshEnvironment.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.UNIX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

