/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl.cassandra;

import com.intellij.database.remote.jdbc.RemoteCassConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.RemoteConnectionImpl;
import com.intellij.database.remote.jdbc.impl.cassandra.CassParseUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteCassConnectionImpl
extends RemoteConnectionImpl
implements RemoteCassConnection {
    private final boolean myIsIngDriver;

    public RemoteCassConnectionImpl(Connection delegate, @NotNull JdbcHelperImpl helper, boolean isIngDriver) {
        if (helper == null) {
            RemoteCassConnectionImpl.$$$reportNull$$$0(0);
        }
        super(delegate, helper);
        this.myIsIngDriver = isIngDriver;
    }

    @Override
    @Nullable
    public Map<String, String> getAggregateInitConditions(String keyspace) {
        try {
            if (!CassParseUtils.isDoubleQuoted(keyspace)) {
                keyspace = CassParseUtils.doubleQuote(keyspace);
            }
            Method getSession = ((Connection)this.myDelegate).getClass().getDeclaredMethod("getSession", new Class[0]);
            getSession.setAccessible(true);
            Object session = getSession.invoke(this.myDelegate, new Object[0]);
            return session == null ? null : (this.myIsIngDriver ? this.getInitConditionsIngDriver(session, keyspace) : this.getInitConditions(session, keyspace));
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("Cannot retrieve aggregate conditions", e);
            return null;
        }
    }

    @NotNull
    private Map<String, String> getInitConditions(@NotNull Object session, String keyspace) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        if (session == null) {
            RemoteCassConnectionImpl.$$$reportNull$$$0(1);
        }
        Method getCluster = session.getClass().getMethod("getCluster", new Class[0]);
        getCluster.setAccessible(true);
        Object cluster = getCluster.invoke(session, new Object[0]);
        Object metadata = cluster.getClass().getMethod("getMetadata", new Class[0]).invoke(cluster, new Object[0]);
        Object keyspaceMetadata = metadata.getClass().getMethod("getKeyspace", String.class).invoke(metadata, keyspace);
        Collection aggregates = (Collection)keyspaceMetadata.getClass().getMethod("getAggregates", new Class[0]).invoke(keyspaceMetadata, new Object[0]);
        Class<?> AggregateMetadata = this.myHelper.classForName("com.datastax.driver.core.AggregateMetadata");
        Method getInitCond = AggregateMetadata.getMethod("getInitCond", new Class[0]);
        Method getSignature = AggregateMetadata.getMethod("getSignature", new Class[0]);
        LinkedHashMap<String, String> initConditions = new LinkedHashMap<String, String>();
        for (Object aggregate : aggregates) {
            Object initCond = getInitCond.invoke(aggregate, new Object[0]);
            String signature = (String)getSignature.invoke(aggregate, new Object[0]);
            if (initCond == null) {
                initConditions.put(signature, "null");
                continue;
            }
            if (initCond instanceof String) {
                initConditions.put(signature, CassParseUtils.quote((String)initCond));
                continue;
            }
            initConditions.put(signature, initCond.toString());
        }
        LinkedHashMap<String, String> linkedHashMap = initConditions;
        if (linkedHashMap == null) {
            RemoteCassConnectionImpl.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    @Nullable
    private Map<String, String> getInitConditionsIngDriver(@NotNull Object session, String keyspace) {
        if (session == null) {
            RemoteCassConnectionImpl.$$$reportNull$$$0(3);
        }
        return (Map)ReflectionHelper.tryInvokeStaticMethod(this.myHelper.getJdbcClassLoader(), "com.intellij.database.remote.jdbc.CassShim", "getInitConditions", new Class[]{Object.class, String.class}, new Object[]{session, keyspace});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/cassandra/RemoteCassConnectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/cassandra/RemoteCassConnectionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitConditions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInitConditions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInitConditionsIngDriver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

