/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.MssqlExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.MssqlIntermediateFacade;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.SQLExceptionWithProperties;
import com.intellij.database.remote.jdbc.helpers.AzureJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.MsJdbcHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MsBaseJdbcHelper
extends JdbcHelperImpl {
    public static final String MSSQL = "MSSQL";
    public static final String LOCALDB = "MSSQL.LOCALDB";
    public static final String AZURE = "AZURE";
    public static final String SYNAPSE = "SYNAPSE";
    public static final String SYNAPSE_MASTER = "SYNAPSE_MASTER";
    public static final int DATE_TIME_OFFSET = -155;
    private static final Set<String> MS_UNLIMITED_TYPES = JdbcNativeUtil.addAll(new HashSet(), "integer", "clob", "blob", "int");

    public MsBaseJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection) {
        if (dbmsName == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(1);
        }
        return new MssqlIntermediateFacade(ds, MssqlExceptionRecognizer.INSTANCE, this);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if (typeName != null && jdbcType == -155) {
            return UnparsedValueKind.ZONED_TIMESTAMP;
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(@Nullable String typeName, int type) {
        if (type == 92) {
            return LOCAL_TIME_GETTER;
        }
        return null;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (MS_UNLIMITED_TYPES.contains(t)) {
            e.length = -1;
        }
    }

    @Override
    public boolean isTimestamp(int type) {
        return type == -151 || super.isTimestamp(type);
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_[]#";
    }

    @Override
    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(3);
        }
        if (value == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(4);
        }
        statement.setObject(idx, value.longValue());
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE, JdbcSettings.SslMode.VERIFY_FULL};
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(6);
        }
        if (sslMode == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(7);
        }
        if (MsBaseJdbcHelper.isJtds(driver)) {
            MsBaseJdbcHelper.setIfEmpty(properties, "SSL", sslMode == JdbcSettings.SslMode.REQUIRE ? "require" : "authenticate");
        } else if (MsBaseJdbcHelper.isMs(driver)) {
            properties.setProperty("encrypt", "true");
            if (sslMode == JdbcSettings.SslMode.REQUIRE) {
                MsBaseJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "true");
            }
        } else if (MsBaseJdbcHelper.isJetBrains(driver)) {
            MsBaseJdbcHelper.setIfEmpty(properties, "Encrypt", "true");
            if (sslMode == JdbcSettings.SslMode.REQUIRE) {
                MsBaseJdbcHelper.setIfEmpty(properties, "TrustServerCertificate", "true");
            }
        }
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        if (!JdbcNativeUtil.detectString(product, AZURE) && !JdbcNativeUtil.detectString(product, "microsoft|sqlserver")) {
            return null;
        }
        String ver = delegate == null ? MsBaseJdbcHelper.concat(product, productVer) : JdbcNativeUtil.getString(delegate, "select @@version");
        JdbcNativeUtil.logInfo("@@version: " + ver);
        return JdbcNativeUtil.detectString(ver, AZURE) ? MsBaseJdbcHelper.detectAzure(delegate, productVer, ver) : MsBaseJdbcHelper.detectLocalDb(delegate, productVer, ver);
    }

    @NotNull
    private static MsJdbcHelper detectLocalDb(@Nullable Connection delegate, @Nullable String productVer, String ver) throws Exception {
        String svc;
        try {
            svc = delegate == null ? ver : JdbcNativeUtil.getString(delegate, "select @@servicename");
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("Failed to check for localdb", e);
            svc = null;
        }
        JdbcNativeUtil.logInfo("@@servicename: " + svc);
        MsJdbcHelper msJdbcHelper = svc != null && svc.startsWith("LOCALDB#") ? MsJdbcHelper.create(LOCALDB, delegate, productVer) : MsJdbcHelper.create(MSSQL, delegate, productVer);
        if (msJdbcHelper == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(8);
        }
        return msJdbcHelper;
    }

    @NotNull
    private static AzureJdbcHelper detectAzure(@Nullable Connection delegate, @Nullable String productVer, String ver) {
        block6: {
            AzureJdbcHelper azureJdbcHelper;
            if (JdbcNativeUtil.detectString(ver, "warehouse")) {
                AzureJdbcHelper azureJdbcHelper2 = AzureJdbcHelper.createSynapse(delegate, productVer, SYNAPSE);
                if (azureJdbcHelper2 == null) {
                    MsBaseJdbcHelper.$$$reportNull$$$0(9);
                }
                return azureJdbcHelper2;
            }
            try {
                String reallySynapse;
                String string = reallySynapse = delegate == null ? null : JdbcNativeUtil.getString(delegate, "select top 1 database_id from sys.database_service_objectives where EDITION = 'DataWarehouse'");
                if (reallySynapse == null) break block6;
                azureJdbcHelper = AzureJdbcHelper.createSynapse(delegate, productVer, SYNAPSE_MASTER);
            }
            catch (Exception e) {
                JdbcNativeUtil.logWarn("Failed to check for synapse", e);
            }
            if (azureJdbcHelper == null) {
                MsBaseJdbcHelper.$$$reportNull$$$0(10);
            }
            return azureJdbcHelper;
        }
        AzureJdbcHelper azureJdbcHelper = AzureJdbcHelper.create(delegate, productVer);
        if (azureJdbcHelper == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(11);
        }
        return azureJdbcHelper;
    }

    @Nullable
    private static String concat(@Nullable String product, @Nullable String productVer) {
        return product == null ? productVer : (productVer == null ? product : product + " " + productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(12);
        }
        return MsBaseJdbcHelper.isJetBrains(driver) || MsBaseJdbcHelper.isMs(driver) || MsBaseJdbcHelper.isJtds(driver) && url != null && StringUtilRt.startsWithIgnoreCase((String)url, (String)"jdbc:jtds:sqlserver:");
    }

    @Override
    protected void enableIntegratedSecurity(@NotNull Driver driver, @NotNull Properties properties) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(13);
        }
        if (properties == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(14);
        }
        if (MsBaseJdbcHelper.isMs(driver)) {
            MsBaseJdbcHelper.setIfEmpty(properties, "integratedSecurity", "true");
        } else if (MsBaseJdbcHelper.isJetBrains(driver)) {
            MsBaseJdbcHelper.setIfEmpty(properties, "Integrated Security", "true");
        }
    }

    @Override
    @NotNull
    public JdbcHelper.Case getCaseMode(boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        if (sensitive && asIs) {
            JdbcHelper.Case case_ = JdbcHelper.Case.MIXED;
            if (case_ == null) {
                MsBaseJdbcHelper.$$$reportNull$$$0(15);
            }
            return case_;
        }
        JdbcHelper.Case case_ = super.getCaseMode(sensitive, forceLower, forceUpper, asIs);
        if (case_ == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(16);
        }
        return case_;
    }

    private static boolean isMs(@NotNull Driver driver) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(17);
        }
        return MsBaseJdbcHelper.classNameContains(driver, "com.microsoft.sqlserver");
    }

    private static boolean isJtds(@NotNull Driver driver) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(18);
        }
        return MsBaseJdbcHelper.classNameContains(driver, "net.sourceforge.jtds");
    }

    private static boolean isJetBrains(@NotNull Driver driver) {
        if (driver == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(19);
        }
        return MsBaseJdbcHelper.classNameContains(driver, "com.jetbrains.jdbc.sqlserver");
    }

    @Override
    @Nullable
    protected Map<String, Serializable> getAdditionalProperties(@NotNull SQLException ex) {
        Object sqlServerErrorObject;
        if (ex == null) {
            MsBaseJdbcHelper.$$$reportNull$$$0(20);
        }
        if ((sqlServerErrorObject = ReflectionHelper.tryInvokeMethod(ex, "getSQLServerError", null, null)) == null) {
            return null;
        }
        Object lineNumberObject = ReflectionHelper.tryInvokeMethod(sqlServerErrorObject, "getLineNumber", null, null);
        if (!(lineNumberObject instanceof Long)) {
            return null;
        }
        Long lineNumber = (Long)lineNumberObject;
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        SQLExceptionWithProperties.LINE_NUMBER.put(properties, lineNumber.intValue());
        return properties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MsBaseJdbcHelper";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MsBaseJdbcHelper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectLocalDb";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAzure";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "enableIntegratedSecurity";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isJtds";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isJetBrains";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

