/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.frontend.ideaInterop.themes;

import com.intellij.ide.ui.TargetUIType;
import com.intellij.ide.ui.ThemeListProvider;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoKt;
import com.intellij.ide.ui.laf.UiThemeProviderListManager;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.NewUI;
import com.jetbrains.rider.frontend.RiderSharedFrontendBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/frontend/ideaInterop/themes/RiderThemesListProviderImpl;", "Lcom/intellij/ide/ui/ThemeListProvider;", "<init>", "()V", "darcula", "", "highContrast", "newUiTopThemes", "", "classicTopThemes", "lafComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/ui/laf/UIThemeLookAndFeelInfo;", "getShownThemes", "Lcom/intellij/openapi/editor/colors/Groups;", "intellij.rider.frontend"})
public final class RiderThemesListProviderImpl
implements ThemeListProvider {
    @NotNull
    private final String darcula;
    @NotNull
    private final String highContrast;
    @NotNull
    private final List<String> newUiTopThemes;
    @NotNull
    private final List<String> classicTopThemes;
    @NotNull
    private final Comparator<UIThemeLookAndFeelInfo> lafComparator;

    public RiderThemesListProviderImpl() {
        this.darcula = "Darcula";
        this.highContrast = "High Contrast";
        Object[] objectArray = new String[]{"Dark", "Light", "Light with Light Header", this.highContrast};
        this.newUiTopThemes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"Rider Dark", "Rider Light", this.darcula, "IntelliJ Light", this.highContrast};
        this.classicTopThemes = CollectionsKt.listOf((Object[])objectArray);
        this.lafComparator = (arg_0, arg_1) -> RiderThemesListProviderImpl.lafComparator$lambda$0(this, arg_0, arg_1);
    }

    @NotNull
    public Groups<UIThemeLookAndFeelInfo> getShownThemes() {
        UiThemeProviderListManager themeProviderListManager = UiThemeProviderListManager.Companion.getInstance();
        List groupInfos = new ArrayList();
        List customThemes = new ArrayList();
        List topThemes = new ArrayList();
        List darkThemes = new ArrayList();
        List lightThemes = new ArrayList();
        Sequence newUiThemes = themeProviderListManager.getThemeListForTargetUI(TargetUIType.NEW);
        Sequence classicUiThemes = themeProviderListManager.getThemeListForTargetUI(TargetUIType.CLASSIC);
        Sequence unspecifiedThemes = themeProviderListManager.getThemeListForTargetUI(TargetUIType.UNSPECIFIED);
        Sequence themes = SequencesKt.emptySequence();
        if (NewUI.isEnabled()) {
            themes = SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)newUiThemes, (Sequence)unspecifiedThemes), (Sequence)SequencesKt.filter((Sequence)classicUiThemes, arg_0 -> RiderThemesListProviderImpl.getShownThemes$lambda$1(this, arg_0)));
            if (Registry.Companion.is("rider.show.all.themes")) {
                themes = SequencesKt.plus((Sequence)themes, (Sequence)SequencesKt.filter((Sequence)classicUiThemes, arg_0 -> RiderThemesListProviderImpl.getShownThemes$lambda$2(this, arg_0)));
            }
        } else {
            themes = SequencesKt.plus((Sequence)classicUiThemes, (Sequence)unspecifiedThemes);
            if (Registry.Companion.is("rider.show.all.themes")) {
                themes = SequencesKt.plus((Sequence)themes, (Sequence)newUiThemes);
            }
        }
        CollectionsKt.addAll((Collection)customThemes, (Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)themes, RiderThemesListProviderImpl::getShownThemes$lambda$3), this.lafComparator));
        boolean bl = NewUI.isEnabled() ? CollectionsKt.addAll((Collection)topThemes, (Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)themes, arg_0 -> RiderThemesListProviderImpl.getShownThemes$lambda$4(this, customThemes, arg_0)), this.lafComparator)) : CollectionsKt.addAll((Collection)topThemes, (Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)themes, arg_0 -> RiderThemesListProviderImpl.getShownThemes$lambda$5(this, customThemes, arg_0)), this.lafComparator));
        CollectionsKt.addAll((Collection)darkThemes, (Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)themes, arg_0 -> RiderThemesListProviderImpl.getShownThemes$lambda$6(customThemes, topThemes, arg_0)), this.lafComparator));
        CollectionsKt.addAll((Collection)lightThemes, (Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)themes, arg_0 -> RiderThemesListProviderImpl.getShownThemes$lambda$7(customThemes, topThemes, arg_0)), this.lafComparator));
        if (!((Collection)topThemes).isEmpty()) {
            groupInfos.add(new Groups.GroupInfo(topThemes, null, 2, null));
        }
        if (!((Collection)darkThemes).isEmpty()) {
            groupInfos.add(new Groups.GroupInfo(darkThemes, RiderSharedFrontendBundle.INSTANCE.message("combobox.list.dark.section.title", new Object[0])));
        }
        if (!((Collection)lightThemes).isEmpty()) {
            groupInfos.add(new Groups.GroupInfo(lightThemes, RiderSharedFrontendBundle.INSTANCE.message("combobox.list.light.section.title", new Object[0])));
        }
        if (!((Collection)customThemes).isEmpty()) {
            groupInfos.add(new Groups.GroupInfo(customThemes, RiderSharedFrontendBundle.INSTANCE.message("combobox.list.custom.section.title", new Object[0])));
        }
        return new Groups(groupInfos);
    }

    private static final int lafComparator$lambda$0(RiderThemesListProviderImpl this$0, UIThemeLookAndFeelInfo l1, UIThemeLookAndFeelInfo l2) {
        int ix2;
        int ix1 = this$0.newUiTopThemes.indexOf(l1.getName());
        if (ix1 == -1) {
            ix1 = this$0.classicTopThemes.indexOf(l1.getName());
        }
        if ((ix2 = this$0.newUiTopThemes.indexOf(l2.getName())) == -1) {
            ix2 = this$0.classicTopThemes.indexOf(l2.getName());
        }
        return ix1 != -1 && ix2 != -1 ? ix1 - ix2 : (ix1 != -1 ? -1 : (ix2 != -1 ? 1 : StringsKt.compareTo((String)l1.getName(), (String)l2.getName(), (boolean)true)));
    }

    private static final boolean getShownThemes$lambda$1(RiderThemesListProviderImpl this$0, UIThemeLookAndFeelInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)this$0.darcula);
    }

    private static final boolean getShownThemes$lambda$2(RiderThemesListProviderImpl this$0, UIThemeLookAndFeelInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getName(), (Object)this$0.darcula);
    }

    private static final boolean getShownThemes$lambda$3(UIThemeLookAndFeelInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UIThemeLookAndFeelInfoKt.isThemeFromPlugin((UIThemeLookAndFeelInfo)it);
    }

    private static final boolean getShownThemes$lambda$4(RiderThemesListProviderImpl this$0, List $customThemes, UIThemeLookAndFeelInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.newUiTopThemes.contains(it.getName()) && !$customThemes.contains(it);
    }

    private static final boolean getShownThemes$lambda$5(RiderThemesListProviderImpl this$0, List $customThemes, UIThemeLookAndFeelInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.classicTopThemes.contains(it.getName()) && !$customThemes.contains(it);
    }

    private static final boolean getShownThemes$lambda$6(List $customThemes, List $topThemes, UIThemeLookAndFeelInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$customThemes.contains(it) && !$topThemes.contains(it) && it.isDark();
    }

    private static final boolean getShownThemes$lambda$7(List $customThemes, List $topThemes, UIThemeLookAndFeelInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$customThemes.contains(it) && !$topThemes.contains(it) && !it.isDark();
    }
}

