/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.model.godot.frontendBackend.GodotFrontendBackendModel;
import com.jetbrains.rider.plugins.godot.GodotProjectDiscoverer;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfigurationType;
import com.jetbrains.rider.plugins.godot.run.configurations.gdscript.GdScriptConfigurationType;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationType;
import com.jetbrains.rider.run.configurations.exe.ExeConfiguration;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationType;
import com.jetbrains.rider.run.configurations.remote.DotNetRemoteConfiguration;
import com.jetbrains.rider.run.configurations.remote.MonoRemoteConfigType;
import com.jetbrains.rider.runtime.DotNetRuntimeType;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntimeType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/GodotRunConfigurationGenerator;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "Companion", "ProtocolListener", "intellij.rider.plugins.godot"})
public final class GodotRunConfigurationGenerator
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ATTACH_CONFIGURATION_NAME = "Attach to Player";
    @NotNull
    public static final String PLAYER_CONFIGURATION_NAME = "Player";
    @NotNull
    public static final String PLAYER_GDSCRIPT_CONFIGURATION_NAME = "Player GDScript";
    @NotNull
    public static final String EDITOR_CONFIGURATION_NAME = "Editor";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/GodotRunConfigurationGenerator$Companion;", "", "<init>", "()V", "ATTACH_CONFIGURATION_NAME", "", "PLAYER_CONFIGURATION_NAME", "PLAYER_GDSCRIPT_CONFIGURATION_NAME", "EDITOR_CONFIGURATION_NAME", "intellij.rider.plugins.godot"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J0\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/plugins/godot/run/GodotRunConfigurationGenerator$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/godot/frontendBackend/GodotFrontendBackendModel;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "selectConfigurationIfNeeded", "runManager", "Lcom/intellij/execution/RunManager;", "createOrUpdateCoreRunConfiguration", "configurationName", "", "programParameters", "godotPath", "project", "Lcom/intellij/openapi/project/Project;", "createOrUpdateRunConfiguration", "createOrUpdateGdScriptRunConfiguration", "createOrUpdateNativeExecutableRunConfiguration", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotRunConfigurationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/godot/run/GodotRunConfigurationGenerator$ProtocolListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n774#2:225\n865#2,2:226\n1863#2,2:228\n774#2:230\n865#2,2:231\n1863#2,2:233\n774#2:235\n865#2,2:236\n774#2:238\n865#2,2:239\n1863#2,2:241\n774#2:243\n865#2,2:244\n1863#2,2:246\n774#2:248\n865#2,2:249\n1755#2,3:251\n*S KotlinDebug\n*F\n+ 1 GodotRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/godot/run/GodotRunConfigurationGenerator$ProtocolListener\n*L\n129#1:225\n129#1:226,2\n131#1:228,2\n155#1:230\n155#1:231,2\n157#1:233,2\n178#1:235\n178#1:236,2\n185#1:238\n185#1:239,2\n187#1:241,2\n205#1:243\n205#1:244,2\n207#1:246,2\n59#1:248\n59#1:249,2\n67#1:251,3\n*E\n"})
    public static final class ProtocolListener
    implements SolutionExtListener<GodotFrontendBackendModel> {
        @NotNull
        private final Logger logger;

        public ProtocolListener() {
            Logger logger = Logger.getInstance(GodotRunConfigurationGenerator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.logger = logger;
        }

        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull GodotFrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            Project project = session.getProject();
            BoolPropertyExKt.whenTrue((IViewable)((IViewable)SolutionHostExtensionsKt.getSolution((Project)project).isLoaded()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$6(project, lifetime, this, arg_0));
        }

        private final void selectConfigurationIfNeeded(RunManager runManager) {
            if (runManager.getSelectedConfiguration() == null) {
                RunnerAndConfigurationSettings runConfiguration = runManager.findConfigurationByName(GodotRunConfigurationGenerator.PLAYER_CONFIGURATION_NAME);
                if (runConfiguration != null) {
                    runManager.setSelectedConfiguration(runConfiguration);
                } else {
                    RunnerAndConfigurationSettings runConfiguration2 = runManager.findConfigurationByName(GodotRunConfigurationGenerator.PLAYER_GDSCRIPT_CONFIGURATION_NAME);
                    if (runConfiguration2 != null) {
                        runManager.setSelectedConfiguration(runConfiguration2);
                    }
                }
            }
        }

        private final void createOrUpdateCoreRunConfiguration(String configurationName, String programParameters, RunManager runManager, String godotPath, Project project) {
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = runManager.getAllSettings();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() instanceof DotNetExeConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)configurationName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List configs = (List)destination$iv$iv;
            if (CollectionsKt.any((Iterable)configs)) {
                Iterable $this$forEach$iv = configs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl = false;
                    RunConfiguration runConfiguration = it.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
                    ((DotNetExeConfiguration)runConfiguration).getParameters().setExePath(godotPath);
                    RunConfiguration runConfiguration2 = it.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration2, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
                    ((DotNetExeConfiguration)runConfiguration2).getParameters().setWorkingDirectory(SolutionHostExtensionsKt.getSolutionDirectory((Project)project).getAbsolutePath());
                }
            } else {
                DotNetExeConfigurationType configurationType = (DotNetExeConfigurationType)ConfigurationTypeUtil.findConfigurationType(DotNetExeConfigurationType.class);
                RunnerAndConfigurationSettings runConfiguration = runManager.createConfiguration(configurationName, (ConfigurationFactory)configurationType.getFactory());
                RunConfiguration runConfiguration3 = runConfiguration.getConfiguration();
                Intrinsics.checkNotNull((Object)runConfiguration3, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
                DotNetExeConfiguration config = (DotNetExeConfiguration)runConfiguration3;
                config.getParameters().setExePath(godotPath);
                config.getParameters().setProgramParameters(programParameters);
                config.getParameters().setWorkingDirectory(SolutionHostExtensionsKt.getSolutionDirectory((Project)project).getAbsolutePath());
                config.getParameters().setRuntimeType((DotNetRuntimeType)DotNetCoreRuntimeType.INSTANCE);
                runConfiguration.storeInLocalWorkspace();
                runManager.addConfiguration(runConfiguration);
            }
        }

        private final void createOrUpdateRunConfiguration(String configurationName, String programParameters, RunManager runManager, String godotPath, Project project) {
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = runManager.getAllSettings();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() instanceof GodotDebugRunConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)configurationName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List configs = (List)destination$iv$iv;
            if (CollectionsKt.any((Iterable)configs)) {
                Iterable $this$forEach$iv = configs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl = false;
                    RunConfiguration runConfiguration = it.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration");
                    ((GodotDebugRunConfiguration)runConfiguration).getParameters().setExePath(godotPath);
                    RunConfiguration runConfiguration2 = it.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration2, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration");
                    ((GodotDebugRunConfiguration)runConfiguration2).getParameters().setWorkingDirectory(SolutionHostExtensionsKt.getSolutionDirectory((Project)project).getAbsolutePath());
                }
            } else {
                GodotDebugRunConfigurationType configurationType = (GodotDebugRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(GodotDebugRunConfigurationType.class);
                RunnerAndConfigurationSettings runConfiguration = runManager.createConfiguration(configurationName, (ConfigurationFactory)configurationType.getFactory());
                RunConfiguration runConfiguration3 = runConfiguration.getConfiguration();
                Intrinsics.checkNotNull((Object)runConfiguration3, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration");
                GodotDebugRunConfiguration config = (GodotDebugRunConfiguration)runConfiguration3;
                config.getParameters().setExePath(godotPath);
                config.getParameters().setProgramParameters(programParameters);
                config.getParameters().setWorkingDirectory(SolutionHostExtensionsKt.getSolutionDirectory((Project)project).getAbsolutePath());
                runConfiguration.storeInLocalWorkspace();
                runManager.addConfiguration(runConfiguration);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void createOrUpdateGdScriptRunConfiguration(String configurationName, RunManager runManager) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = runManager.getAllSettings();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() instanceof ExeConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)configurationName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            for (RunnerAndConfigurationSettings value : toRemove) {
                runManager.removeConfiguration(value);
            }
            Iterable $this$filter$iv2 = runManager.getAllSettings();
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() instanceof GdScriptConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)configurationName))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List configs = (List)destination$iv$iv2;
            if (CollectionsKt.any((Iterable)configs)) {
                Iterable $this$forEach$iv = configs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl = false;
                }
            } else {
                GdScriptConfigurationType configurationType = (GdScriptConfigurationType)ConfigurationTypeUtil.findConfigurationType(GdScriptConfigurationType.class);
                RunnerAndConfigurationSettings runConfiguration = runManager.createConfiguration(configurationName, (ConfigurationFactory)configurationType.getFactory());
                runConfiguration.storeInLocalWorkspace();
                runManager.addConfiguration(runConfiguration);
            }
        }

        private final void createOrUpdateNativeExecutableRunConfiguration(String configurationName, String programParameters, RunManager runManager, String godotPath, Project project) {
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = runManager.getAllSettings();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() instanceof ExeConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)configurationName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List configs = (List)destination$iv$iv;
            if (CollectionsKt.any((Iterable)configs)) {
                Iterable $this$forEach$iv = configs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl = false;
                    RunConfiguration runConfiguration = it.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.exe.ExeConfiguration");
                    ((ExeConfiguration)runConfiguration).getParameters().setExePath(godotPath);
                    RunConfiguration runConfiguration2 = it.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration2, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.exe.ExeConfiguration");
                    ((ExeConfiguration)runConfiguration2).getParameters().setWorkingDirectory(SolutionHostExtensionsKt.getSolutionDirectory((Project)project).getAbsolutePath());
                }
            } else {
                ExeConfigurationType configurationType = (ExeConfigurationType)ConfigurationTypeUtil.findConfigurationType(ExeConfigurationType.class);
                RunnerAndConfigurationSettings runConfiguration = runManager.createConfiguration(configurationName, (ConfigurationFactory)configurationType.getFactory());
                RunConfiguration runConfiguration3 = runConfiguration.getConfiguration();
                Intrinsics.checkNotNull((Object)runConfiguration3, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.exe.ExeConfiguration");
                ExeConfiguration config = (ExeConfiguration)runConfiguration3;
                config.getParameters().setExePath(godotPath);
                config.getParameters().setProgramParameters(programParameters);
                config.getParameters().setWorkingDirectory(SolutionHostExtensionsKt.getSolutionDirectory((Project)project).getAbsolutePath());
                config.setBeforeRunTasks(CollectionsKt.emptyList());
                runConfiguration.storeInLocalWorkspace();
                runManager.addConfiguration(runConfiguration);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit extensionCreated$lambda$6$lambda$5$lambda$2(RunManager $runManager, GodotDescriptor $descriptor, GodotProjectDiscoverer $godotDiscoverer, String corePath) {
            if (corePath != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = $runManager.getAllSettings();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getType() instanceof MonoRemoteConfigType && Intrinsics.areEqual((Object)it.getName(), (Object)GodotRunConfigurationGenerator.ATTACH_CONFIGURATION_NAME))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List toRemove = (List)destination$iv$iv;
                for (RunnerAndConfigurationSettings value : toRemove) {
                    $runManager.removeConfiguration(value);
                }
            } else if (!$descriptor.isPureGdScriptProject()) {
                boolean bl;
                block9: {
                    Iterable $this$any$iv = $runManager.getAllSettings();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                            boolean bl2 = false;
                            if (!(it.getType() instanceof MonoRemoteConfigType && Intrinsics.areEqual((Object)it.getName(), (Object)GodotRunConfigurationGenerator.ATTACH_CONFIGURATION_NAME))) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    MonoRemoteConfigType configurationType = (MonoRemoteConfigType)ConfigurationTypeUtil.findConfigurationType(MonoRemoteConfigType.class);
                    RunnerAndConfigurationSettings runConfiguration = $runManager.createConfiguration(GodotRunConfigurationGenerator.ATTACH_CONFIGURATION_NAME, (ConfigurationFactory)configurationType.getFactory());
                    RunConfiguration runConfiguration2 = runConfiguration.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration2, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.remote.DotNetRemoteConfiguration");
                    DotNetRemoteConfiguration remoteConfig = (DotNetRemoteConfiguration)runConfiguration2;
                    remoteConfig.setPort($godotDiscoverer.getPort());
                    runConfiguration.storeInLocalWorkspace();
                    $runManager.addConfiguration(runConfiguration);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$6$lambda$5$lambda$3(GodotDescriptor $descriptor, ProtocolListener this$0, RunManager $runManager, Comparable $relPath, Project $project, String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if ($descriptor.isPureGdScriptProject()) {
                this$0.createOrUpdateGdScriptRunConfiguration(GodotRunConfigurationGenerator.PLAYER_GDSCRIPT_CONFIGURATION_NAME, $runManager);
                this$0.createOrUpdateNativeExecutableRunConfiguration(GodotRunConfigurationGenerator.EDITOR_CONFIGURATION_NAME, "--path \"" + $relPath + "\" --editor", $runManager, path, $project);
                this$0.selectConfigurationIfNeeded($runManager);
                return Unit.INSTANCE;
            }
            this$0.createOrUpdateGdScriptRunConfiguration(GodotRunConfigurationGenerator.PLAYER_GDSCRIPT_CONFIGURATION_NAME, $runManager);
            this$0.createOrUpdateRunConfiguration(GodotRunConfigurationGenerator.PLAYER_CONFIGURATION_NAME, "--path \"" + $relPath + "\"", $runManager, path, $project);
            this$0.createOrUpdateRunConfiguration(GodotRunConfigurationGenerator.EDITOR_CONFIGURATION_NAME, "--path \"" + $relPath + "\" --editor", $runManager, path, $project);
            this$0.selectConfigurationIfNeeded($runManager);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$6$lambda$5$lambda$4(GodotDescriptor $descriptor, ProtocolListener this$0, RunManager $runManager, Comparable $relPath, Project $project, String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if ($descriptor.isPureGdScriptProject()) {
                this$0.createOrUpdateGdScriptRunConfiguration(GodotRunConfigurationGenerator.PLAYER_GDSCRIPT_CONFIGURATION_NAME, $runManager);
                this$0.createOrUpdateNativeExecutableRunConfiguration(GodotRunConfigurationGenerator.EDITOR_CONFIGURATION_NAME, "--path \"" + $relPath + "\" --editor", $runManager, path, $project);
                this$0.selectConfigurationIfNeeded($runManager);
                return Unit.INSTANCE;
            }
            this$0.createOrUpdateGdScriptRunConfiguration(GodotRunConfigurationGenerator.PLAYER_GDSCRIPT_CONFIGURATION_NAME, $runManager);
            this$0.createOrUpdateCoreRunConfiguration(GodotRunConfigurationGenerator.PLAYER_CONFIGURATION_NAME, "--path \"" + $relPath + "\"", $runManager, path, $project);
            this$0.createOrUpdateCoreRunConfiguration(GodotRunConfigurationGenerator.EDITOR_CONFIGURATION_NAME, "--path \"" + $relPath + "\" --editor", $runManager, path, $project);
            this$0.selectConfigurationIfNeeded($runManager);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$6$lambda$5(ProtocolListener this$0, Project $project, GodotProjectDiscoverer $godotDiscoverer, Lifetime lt, GodotDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this$0.logger.info("descriptor = " + descriptor);
            Path path = Paths.get(descriptor.getMainProjectBasePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = SolutionHostExtensionsKt.getSolutionDirectory((Project)$project).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            Path tempRelPath = PathsKt.relativeToOrSelf((Path)path, (Path)path2);
            Comparable relPath = ((CharSequence)((Object)tempRelPath).toString()).length() == 0 ? (Comparable)((Object)"./") : (Comparable)tempRelPath;
            RunManager runManager = RunManager.Companion.getInstance($project);
            GodotProjectDiscoverer.Companion.getInstance($project).getGodot4Path().advise(lt, arg_0 -> ProtocolListener.extensionCreated$lambda$6$lambda$5$lambda$2(runManager, descriptor, $godotDiscoverer, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)GodotProjectDiscoverer.Companion.getInstance($project).getGodot3Path()), (Lifetime)lt, arg_0 -> ProtocolListener.extensionCreated$lambda$6$lambda$5$lambda$3(descriptor, this$0, runManager, relPath, $project, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)GodotProjectDiscoverer.Companion.getInstance($project).getGodot4Path()), (Lifetime)lt, arg_0 -> ProtocolListener.extensionCreated$lambda$6$lambda$5$lambda$4(descriptor, this$0, runManager, relPath, $project, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$6(Project $project, Lifetime $lifetime, ProtocolListener this$0, Lifetime it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            GodotProjectDiscoverer godotDiscoverer = GodotProjectDiscoverer.Companion.getInstance($project);
            InterfacesKt.viewNotNull((IViewable)((IViewable)godotDiscoverer.getGodotDescriptor()), (Lifetime)$lifetime, (arg_0, arg_1) -> ProtocolListener.extensionCreated$lambda$6$lambda$5(this$0, $project, godotDiscoverer, arg_0, arg_1));
            return Unit.INSTANCE;
        }
    }
}

