/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.projectView;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.godot.GodotPluginBundle;
import com.jetbrains.rider.plugins.godot.GodotProjectLifetimeService;
import com.jetbrains.rider.projectView.VfsBackendRequester;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000  2\u00020\u0001:\u0004 !\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\n2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\bH\u0003J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker;", "Lcom/jetbrains/rider/projectView/VfsBackendRequester;", "<init>", "()V", "lock", "Ljava/lang/Object;", "projects", "", "Lcom/intellij/openapi/project/Project;", "register", "", "project", "actionsPerProject", "", "Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$UidActionList;", "onEvent", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "getOrCreate", "isValidEvent", "", "event", "isUndoRedoInProgress", "isUidFile", "isApplicableForProject", "getUidFile", "Ljava/nio/file/Path;", "path", "", "getUidFileName", "fileName", "Companion", "UidActionList", "UidAction", "UidGroupId", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotUidTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotUidTracker.kt\ncom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,257:1\n1#2:258\n774#3:259\n865#3,2:260\n13#4:262\n15#5:263\n*S KotlinDebug\n*F\n+ 1 GodotUidTracker.kt\ncom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker\n*L\n76#1:259\n76#1:260,2\n63#1:262\n63#1:263\n*E\n"})
public final class GodotUidTracker
implements VfsBackendRequester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private Set<Project> projects = new LinkedHashSet();
    @NotNull
    private final Map<Project, UidActionList> actionsPerProject = new LinkedHashMap();
    @NotNull
    private static final Logger logger;

    public final void register(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Lifetime lifetime = GodotProjectLifetimeService.Companion.getLifetime(project);
        lifetime.bracketIfAlive(() -> GodotUidTracker.register$lambda$1(this, project), () -> GodotUidTracker.register$lambda$3(this, project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void onEvent(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Iterable $i$a$-synchronized-GodotUidTracker$onEvent$validProjects$232;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Object object = this.lock;
        synchronized (object) {
            List list;
            boolean $i$a$-synchronized-GodotUidTracker$onEvent$validProjects$232 = false;
            List it = list = (List)new ArrayList();
            boolean bl3 = false;
            it.addAll((Collection)this.projects);
            $i$a$-synchronized-GodotUidTracker$onEvent$validProjects$232 = list;
        }
        Iterable $this$filter$iv = $i$a$-synchronized-GodotUidTracker$onEvent$validProjects$232;
        boolean bl = false;
        $i$a$-synchronized-GodotUidTracker$onEvent$validProjects$232 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.isUndoRedoInProgress(it) && !it.isDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validProjects = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        for (VFileEvent vFileEvent : events) {
            if (!this.isValidEvent(vFileEvent)) continue;
            for (Project project : validProjects) {
                if (!this.isApplicableForProject(vFileEvent, project)) continue;
                UidActionList actions = this.getOrCreate(project);
                if (this.isUidFile(vFileEvent)) {
                    Path path = Paths.get(vFileEvent.getPath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    actions.addInitialSetOfChangedUidFiles(path);
                    continue;
                }
                try {
                    Path uidFile;
                    VFileEvent bl3 = vFileEvent;
                    if (bl3 instanceof VFileDeleteEvent) {
                        if (this.getUidFile(((VFileDeleteEvent)vFileEvent).getPath()) == null) continue;
                        actions.add(uidFile, project, (Function0<Unit>)((Function0)() -> GodotUidTracker.onEvent$lambda$7(uidFile, this)));
                        continue;
                    }
                    if (bl3 instanceof VFileMoveEvent) {
                        if (this.getUidFile(((VFileMoveEvent)vFileEvent).getOldPath()) == null) continue;
                        actions.add(uidFile, project, (Function0<Unit>)((Function0)() -> GodotUidTracker.onEvent$lambda$8(uidFile, this, vFileEvent)));
                        continue;
                    }
                    if (!(bl3 instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename() || this.getUidFile(((VFilePropertyChangeEvent)vFileEvent).getOldPath()) == null) continue;
                    actions.add(uidFile, project, (Function0<Unit>)((Function0)() -> GodotUidTracker.onEvent$lambda$9(this, vFileEvent, uidFile)));
                }
                catch (Throwable t) {
                    logger.error(t);
                }
            }
        }
    }

    private final UidActionList getOrCreate(Project project) {
        UidActionList actions = this.actionsPerProject.get(project);
        if (actions == null) {
            actions = new UidActionList(project);
            CollectionExKt.addUnique(this.actionsPerProject, (Lifetime)GodotProjectLifetimeService.Companion.getLifetime(project), (Object)project, (Object)actions);
        }
        return actions;
    }

    private final boolean isValidEvent(VFileEvent event) {
        if (event.isFromRefresh()) {
            return false;
        }
        if (!(event.getFileSystem() instanceof LocalFileSystem)) {
            return false;
        }
        return CommandProcessor.getInstance().getCurrentCommand() != null;
    }

    private final boolean isUndoRedoInProgress(Project project) {
        return UndoManager.getInstance((Project)project).isUndoOrRedoInProgress();
    }

    private final boolean isUidFile(VFileEvent event) {
        Object object = event.getFile();
        if (object == null || (object = object.getExtension()) == null) {
            object = PathUtil.getFileExtension((String)event.getPath());
        }
        Object extension = object;
        return StringsKt.equals((String)"uid", (String)extension, (boolean)true);
    }

    @RequiresEdt
    private final boolean isApplicableForProject(VFileEvent event, Project project) {
        VirtualFile virtualFile = event.getFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return VfsUtilCore.isUnder((VirtualFile)file, (Set)BaseProjectDirectories.Companion.getBaseDirectories(project));
    }

    private final Path getUidFile(String path) {
        if (path == null) {
            return null;
        }
        Path file = Paths.get(path, new String[0]);
        Intrinsics.checkNotNull((Object)file);
        String uidFileName = this.getUidFileName(PathsKt.getName((Path)file));
        return file.getParent().resolve(uidFileName);
    }

    private final String getUidFileName(String fileName) {
        return fileName + ".uid";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean register$lambda$1(GodotUidTracker this$0, Project $project) {
        boolean bl;
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this$0.projects.add($project);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit register$lambda$3(GodotUidTracker this$0, Project $project) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.projects.remove($project);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$7(Path $uidFile, GodotUidTracker this$0) {
        VirtualFile fileToDelete = VfsUtil.findFile((Path)$uidFile, (boolean)true);
        if (fileToDelete != null) {
            VirtualFileUtil.readBytes((VirtualFile)fileToDelete);
            fileToDelete.delete((Object)this$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$8(Path $uidFile, GodotUidTracker this$0, VFileEvent $event) {
        block0: {
            VirtualFile virtualFile = VfsUtil.findFile((Path)$uidFile, (boolean)true);
            if (virtualFile == null) break block0;
            virtualFile.move((Object)this$0, ((VFileMoveEvent)$event).getNewParent());
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$9(GodotUidTracker this$0, VFileEvent $event, Path $uidFile) {
        block1: {
            VirtualFile conflictingUid;
            Object object = ((VFilePropertyChangeEvent)$event).getNewValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String target = this$0.getUidFileName((String)object);
            VirtualFile origin = VfsUtil.findFile((Path)$uidFile, (boolean)true);
            VirtualFile virtualFile = origin;
            VirtualFile virtualFile2 = virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.findChild(target) : (conflictingUid = null);
            if (conflictingUid != null) {
                logger.warn("Removing conflicting uid " + conflictingUid);
                conflictingUid.delete((Object)this$0);
            }
            VirtualFile virtualFile3 = origin;
            if (virtualFile3 == null) break block1;
            virtualFile3.rename((Object)this$0, target);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GodotUidTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GodotUidTracker.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotUidTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotUidTracker.kt\ncom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,257:1\n40#2,3:258\n*S KotlinDebug\n*F\n+ 1 GodotUidTracker.kt\ncom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$Companion\n*L\n62#1:258,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GodotUidTracker getInstance() {
            boolean $i$f$service = false;
            Class<GodotUidTracker> serviceClass$iv = GodotUidTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GodotUidTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$UidAction;", "", "uidFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "getUidFile", "()Ljava/nio/file/Path;", "getProject", "()Lcom/intellij/openapi/project/Project;", "execute", "intellij.rider.plugins.godot"})
    private static final class UidAction {
        @NotNull
        private final Path uidFile;
        @NotNull
        private final Project project;
        @NotNull
        private final Function0<Unit> action;

        public UidAction(@NotNull Path uidFile, @NotNull Project project, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)uidFile, (String)"uidFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.uidFile = uidFile;
            this.project = project;
            this.action = action;
        }

        @NotNull
        public final Path getUidFile() {
            return this.uidFile;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final void execute() {
            try {
                this.action.invoke();
            }
            catch (Throwable ex) {
                logger.error(ex);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0003J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\nJ$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016J\u0006\u0010\u0017\u001a\u00020\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$UidActionList;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "clear", "", "changedUidFiles", "Ljava/util/HashSet;", "Ljava/nio/file/Path;", "Lkotlin/collections/HashSet;", "actions", "", "Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$UidAction;", "nextGroupIdIndex", "", "addInitialSetOfChangedUidFiles", "path", "add", "uidFile", "action", "Lkotlin/Function0;", "execute", "getCommandName", "", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotUidTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotUidTracker.kt\ncom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$UidActionList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1863#2,2:258\n*S KotlinDebug\n*F\n+ 1 GodotUidTracker.kt\ncom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$UidActionList\n*L\n217#1:258,2\n*E\n"})
    private static final class UidActionList {
        @NotNull
        private final HashSet<Path> changedUidFiles;
        @NotNull
        private final List<UidAction> actions;
        private int nextGroupIdIndex;

        public UidActionList(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            MessageBusConnection connection = project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)GodotProjectLifetimeService.Companion.getLifetime(project), null, (int)1, null));
            Topic topic = CommandListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)new CommandListener(){

                public void beforeCommandFinished(CommandEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.execute();
                    this.clear();
                    super.beforeCommandFinished(event);
                }
            });
            this.changedUidFiles = new HashSet();
            this.actions = new ArrayList();
        }

        @RequiresEdt
        private final void clear() {
            this.changedUidFiles.clear();
            this.actions.clear();
        }

        public final void addInitialSetOfChangedUidFiles(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.changedUidFiles.add(path);
        }

        public final void add(@NotNull Path uidFile, @NotNull Project project, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)uidFile, (String)"uidFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (this.changedUidFiles.contains(uidFile)) {
                return;
            }
            this.actions.add(new UidAction(uidFile, project, action));
        }

        public final void execute() {
            if (this.actions.isEmpty()) {
                return;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Ref.ObjectRef groupId = new Ref.ObjectRef();
            groupId.element = commandProcessor.getCurrentCommandGroupId();
            if (groupId.element == null) {
                int n = this.nextGroupIdIndex;
                this.nextGroupIdIndex = n + 1;
                groupId.element = new UidGroupId(n);
                commandProcessor.setCurrentCommandGroupId(groupId.element);
            }
            commandProcessor.allowMergeGlobalCommands(() -> UidActionList.execute$lambda$3(this, commandProcessor, groupId));
        }

        @Nls
        @NotNull
        public final String getCommandName() {
            String string;
            if (((Collection)this.actions).size() == 1) {
                Object[] objectArray = new Object[]{PathsKt.getName((Path)((UidAction)CollectionsKt.single(this.actions)).getUidFile())};
                string = GodotPluginBundle.Companion.message("process.one.uid.file", objectArray);
            } else {
                Object[] objectArray = new Object[]{((Collection)this.actions).size()};
                string = GodotPluginBundle.Companion.message("process.several.uid.files", objectArray);
            }
            return string;
        }

        private static final void execute$lambda$3$lambda$2$lambda$1$lambda$0(UidActionList this$0, UidAction $it) {
            if (!this$0.changedUidFiles.contains($it.getUidFile())) {
                $it.execute();
            }
        }

        private static final void execute$lambda$3$lambda$2$lambda$1(UidActionList this$0, UidAction $it) {
            ApplicationKt.getApplication().runWriteAction(() -> UidActionList.execute$lambda$3$lambda$2$lambda$1$lambda$0(this$0, $it));
        }

        private static final void execute$lambda$3(UidActionList this$0, CommandProcessor $commandProcessor, Ref.ObjectRef $groupId) {
            Iterable $this$forEach$iv = this$0.actions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UidAction it = (UidAction)element$iv;
                boolean bl = false;
                $commandProcessor.executeCommand(it.getProject(), () -> UidActionList.execute$lambda$3$lambda$2$lambda$1(this$0, it), this$0.getCommandName(), $groupId.element);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/godot/projectView/GodotUidTracker$UidGroupId;", "", "index", "", "<init>", "(I)V", "getIndex", "()I", "toString", "", "intellij.rider.plugins.godot"})
    private static final class UidGroupId {
        private final int index;

        public UidGroupId(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public String toString() {
            return "UidGroupId" + this.index;
        }
    }
}

