/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.lang.service;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspCommunicationChannel;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.model.godot.frontendBackend.LanguageServerConnectionMode;
import com.jetbrains.rider.plugins.godot.GodotIcons;
import com.jetbrains.rider.plugins.godot.GodotProjectDiscoverer;
import com.jetbrains.rider.plugins.godot.GodotProjectLifetimeService;
import com.jetbrains.rider.plugins.godot.Util;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspProjectService;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspServerSupportProvider;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspServerWidgetItem;
import com.jetbrains.rider.plugins.godot.settings.GodotPluginOptionsPage;
import com.jetbrains.rider.util.NetUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.eclipse.lsp4j.CompletionItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "<init>", "()V", "createLspServerWidgetItem", "Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "serverStarter", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "allReady", "", "discoverer", "Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "scheduleStartIfNeeded", "GodotLspServerDescriptor", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n25#2:148\n*S KotlinDebug\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider\n*L\n91#1:148\n*E\n"})
public final class GodotLspServerSupportProvider
implements LspServerSupportProvider {
    @NotNull
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        return new GodotLspServerWidgetItem(lspServer, currentFile, GodotIcons.Icons.Companion.getGodotLogo(), GodotPluginOptionsPage.class);
    }

    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serverStarter, (String)"serverStarter");
        if (Util.Companion.isGdFile(file)) {
            GodotProjectDiscoverer discoverer = GodotProjectDiscoverer.Companion.getInstance(project);
            GodotLspProjectService lspService = GodotLspProjectService.Companion.getInstance(project);
            if (lspService.isScheduled().compareAndSet(false, true)) {
                Lifetime pluginLifetime = GodotProjectLifetimeService.Companion.getLifetime(project);
                LifetimeCoroutineUtilKt.async$default((Lifetime)pluginLifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(discoverer, pluginLifetime, project, this, null){
                    int label;
                    final /* synthetic */ GodotProjectDiscoverer $discoverer;
                    final /* synthetic */ Lifetime $pluginLifetime;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GodotLspServerSupportProvider this$0;
                    {
                        this.$discoverer = $discoverer;
                        this.$pluginLifetime = $pluginLifetime;
                        this.$project = $project;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                SourceExKt.adviseNotNull((ISource)((ISource)this.$discoverer.getLspConnectionMode()), (Lifetime)this.$pluginLifetime, arg_0 -> fileOpened.1.invokeSuspend$lambda$0(this.$project, this.this$0, arg_0));
                                SourceExKt.adviseNotNull((ISource)((ISource)this.$discoverer.getUseDynamicPort()), (Lifetime)this.$pluginLifetime, arg_0 -> fileOpened.1.invokeSuspend$lambda$1(this.this$0, this.$project, arg_0));
                                SourceExKt.adviseNotNull((ISource)((ISource)this.$discoverer.getGodotDescriptor()), (Lifetime)this.$pluginLifetime, arg_0 -> fileOpened.1.invokeSuspend$lambda$2(this.this$0, this.$project, arg_0));
                                SourceExKt.adviseNotNull((ISource)((ISource)this.$discoverer.getGodotPath()), (Lifetime)this.$pluginLifetime, arg_0 -> fileOpened.1.invokeSuspend$lambda$3(this.this$0, this.$project, arg_0));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(Project $project, GodotLspServerSupportProvider this$0, LanguageServerConnectionMode lspConnectionMode) {
                        if (lspConnectionMode == LanguageServerConnectionMode.Never) {
                            LspServerManager.Companion.getInstance($project).stopServers(GodotLspServerSupportProvider.class);
                        } else {
                            GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this$0, $project);
                        }
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$1(GodotLspServerSupportProvider this$0, Project $project, boolean it) {
                        GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this$0, $project);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$2(GodotLspServerSupportProvider this$0, Project $project, GodotDescriptor it) {
                        GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this$0, $project);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$3(GodotLspServerSupportProvider this$0, Project $project, String it) {
                        GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this$0, $project);
                        return Unit.INSTANCE;
                    }
                }), (int)2, null);
            }
            if (this.allReady(discoverer)) {
                GodotLspServerSupportProvider $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(GodotLspServerSupportProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("ensureServerStarted");
                serverStarter.ensureServerStarted((LspServerDescriptor)new GodotLspServerDescriptor(project));
            }
        }
    }

    private final boolean allReady(GodotProjectDiscoverer discoverer) {
        return discoverer.getLspConnectionMode().getValue() != LanguageServerConnectionMode.Never && discoverer.getGodotPath().getValue() != null && discoverer.getRemoteHostPort().getValue() != null && discoverer.getGodotDescriptor().getValue() != null;
    }

    private final void scheduleStartIfNeeded(Project project) {
        GodotLspProjectService godotLspProjectService = GodotLspProjectService.Companion.getInstance(project);
        GodotProjectDiscoverer discoverer = GodotProjectDiscoverer.Companion.getInstance(project);
        if (!this.allReady(discoverer)) {
            return;
        }
        godotLspProjectService.queueRestart();
    }

    public static final /* synthetic */ void access$scheduleStartIfNeeded(GodotLspServerSupportProvider $this, Project project) {
        $this.scheduleStartIfNeeded(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider$GodotLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "discoverer", "Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "getDiscoverer", "()Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "lspConnectionMode", "Lcom/jetbrains/rider/model/godot/frontendBackend/LanguageServerConnectionMode;", "getLspConnectionMode", "()Lcom/jetbrains/rider/model/godot/frontendBackend/LanguageServerConnectionMode;", "lspConnectionMode$delegate", "Lkotlin/Lazy;", "remoteHostPort", "", "getRemoteHostPort", "()Ljava/lang/Integer;", "remoteHostPort$delegate", "useDynamicPort", "", "getUseDynamicPort", "()Z", "useDynamicPort$delegate", "isSupportedFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "lspCommunicationChannel", "Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "getLspCommunicationChannel", "()Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "lspCompletionSupport", "Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "getLspCompletionSupport", "()Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider$GodotLspServerDescriptor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n25#2:148\n25#2:149\n*S KotlinDebug\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider$GodotLspServerDescriptor\n*L\n127#1:148\n134#1:149\n*E\n"})
    private static final class GodotLspServerDescriptor
    extends ProjectWideLspServerDescriptor {
        @NotNull
        private final GodotProjectDiscoverer discoverer;
        @NotNull
        private final Lazy lspConnectionMode$delegate;
        @NotNull
        private final Lazy remoteHostPort$delegate;
        @NotNull
        private final Lazy useDynamicPort$delegate;

        public GodotLspServerDescriptor(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, "Godot");
            this.discoverer = GodotProjectDiscoverer.Companion.getInstance(project);
            this.lspConnectionMode$delegate = LazyKt.lazy(() -> GodotLspServerDescriptor.lspConnectionMode_delegate$lambda$0(this));
            this.remoteHostPort$delegate = LazyKt.lazy(() -> GodotLspServerDescriptor.remoteHostPort_delegate$lambda$1(this));
            this.useDynamicPort$delegate = LazyKt.lazy(() -> GodotLspServerDescriptor.useDynamicPort_delegate$lambda$2(this));
        }

        @NotNull
        public final GodotProjectDiscoverer getDiscoverer() {
            return this.discoverer;
        }

        @Nullable
        public final LanguageServerConnectionMode getLspConnectionMode() {
            Lazy lazy = this.lspConnectionMode$delegate;
            return (LanguageServerConnectionMode)((Object)lazy.getValue());
        }

        @Nullable
        public final Integer getRemoteHostPort() {
            Lazy lazy = this.remoteHostPort$delegate;
            return (Integer)lazy.getValue();
        }

        public final boolean getUseDynamicPort() {
            Lazy lazy = this.useDynamicPort$delegate;
            return (Boolean)lazy.getValue();
        }

        public boolean isSupportedFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return Util.Companion.isGdFile(file);
        }

        @NotNull
        public GeneralCommandLine createCommandLine() {
            GodotDescriptor godotDescriptor = (GodotDescriptor)this.discoverer.getGodotDescriptor().getValue();
            String basePath = godotDescriptor != null ? godotDescriptor.getMainProjectBasePath() : null;
            String godotPath = (String)this.discoverer.getGodotPath().getValue();
            String headlessArg = this.discoverer.getGodot4Path().getValue() != null ? "--headless" : "--no-window";
            String[] stringArray = new String[]{godotPath, "--path", String.valueOf(basePath), "--editor", headlessArg, "--lsp-port", String.valueOf(this.getRemoteHostPort())};
            GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
            GodotLspServerDescriptor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GodotLspServerDescriptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("createCommandLine commandLine=" + commandLine);
            return commandLine;
        }

        @NotNull
        public LspCommunicationChannel getLspCommunicationChannel() {
            GodotLspServerDescriptor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GodotLspServerDescriptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("lspCommunicationChannel port=" + this.getRemoteHostPort() + ", mode=" + this.getLspConnectionMode());
            Integer n = this.getRemoteHostPort();
            Intrinsics.checkNotNull((Object)n);
            return (LspCommunicationChannel)new LspCommunicationChannel.Socket(n.intValue(), this.getLspConnectionMode() == LanguageServerConnectionMode.StartEditorHeadless);
        }

        @NotNull
        public LspCompletionSupport getLspCompletionSupport() {
            return new LspCompletionSupport(){

                public LookupElement createLookupElement(CompletionParameters parameters, CompletionItem item) {
                    Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    LookupElement lookupElement = super.createLookupElement(parameters, item);
                    if (lookupElement == null) {
                        return null;
                    }
                    LookupElement item1 = lookupElement;
                    return PrioritizedLookupElement.withPriority((LookupElement)item1, (double)1.0);
                }
            };
        }

        private static final LanguageServerConnectionMode lspConnectionMode_delegate$lambda$0(GodotLspServerDescriptor this$0) {
            return (LanguageServerConnectionMode)((Object)this$0.discoverer.getLspConnectionMode().getValue());
        }

        private static final Integer remoteHostPort_delegate$lambda$1(GodotLspServerDescriptor this$0) {
            return this$0.getUseDynamicPort() ? Integer.valueOf(NetUtils.INSTANCE.findFreePort(500050, SetsKt.emptySet())) : (Integer)this$0.discoverer.getRemoteHostPort().getValue();
        }

        private static final boolean useDynamicPort_delegate$lambda$2(GodotLspServerDescriptor this$0) {
            Object object = this$0.discoverer.getUseDynamicPort().getValue();
            Intrinsics.checkNotNull((Object)object);
            return (Boolean)object != false && this$0.discoverer.getLspConnectionMode().getValue() == LanguageServerConnectionMode.StartEditorHeadless;
        }
    }
}

