/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.lang.service;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspServerSupportProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLspProjectService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setScheduled", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "queueRestart", "", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "mergingUpdateQueueAction", "Lcom/intellij/util/ui/update/Update;", "restartServer", "Companion", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspProjectService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n25#2:148\n*S KotlinDebug\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspProjectService\n*L\n52#1:148\n*E\n"})
public final class GodotLspProjectService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private AtomicBoolean isScheduled;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;
    @NotNull
    private final Update mergingUpdateQueueAction;

    public GodotLspProjectService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isScheduled = new AtomicBoolean(false);
        this.mergingUpdateQueue = new MergingUpdateQueue("GodotLspServerSupportProviderMergingUpdateQueue", 1000, true, null, null, null, false, 112, null).setRestartTimerOnAdd(true);
        this.mergingUpdateQueueAction = new Update(this){
            final /* synthetic */ GodotLspProjectService this$0;
            {
                this.this$0 = $receiver;
                super((Object)"restartServerIfNeeded", false, 0, 6, null);
            }

            public void run() {
                this.this$0.restartServer();
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AtomicBoolean isScheduled() {
        return this.isScheduled;
    }

    public final void setScheduled(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.isScheduled = atomicBoolean;
    }

    public final void queueRestart() {
        this.mergingUpdateQueue.queue(this.mergingUpdateQueueAction);
    }

    public final void restartServer() {
        GodotLspProjectService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GodotLspProjectService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("stopAndRestartIfNeeded");
        LspServerManager.Companion.getInstance(this.project).stopAndRestartIfNeeded(GodotLspServerSupportProvider.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLspProjectService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLspProjectService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspProjectService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,147:1\n31#2,2:148\n*S KotlinDebug\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspProjectService$Companion\n*L\n37#1:148,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GodotLspProjectService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GodotLspProjectService> serviceClass$iv = GodotLspProjectService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GodotLspProjectService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

