/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.model.godot.frontendBackend.GodotFrontendBackendModel;
import com.jetbrains.rider.model.godot.frontendBackend.LanguageServerConnectionMode;
import com.jetbrains.rider.plugins.godot.GodotProjectLifetimeService;
import com.jetbrains.rider.plugins.godot.MetadataCoreFileWatcher;
import com.jetbrains.rider.plugins.godot.MetadataMonoFileWatcher;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfigurationType;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationType;
import java.io.File;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0007\u0018\u0000 #2\u00020\u0001:\u0002#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0019\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\nR\u0019\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u0014\u0010 \u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "godotDescriptor", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/rider/model/godot/frontendBackend/GodotDescriptor;", "getGodotDescriptor", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "lspConnectionMode", "Lcom/jetbrains/rider/model/godot/frontendBackend/LanguageServerConnectionMode;", "getLspConnectionMode", "remoteHostPort", "", "getRemoteHostPort", "useDynamicPort", "", "getUseDynamicPort", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "godot3Path", "", "getGodot3Path", "godot4Path", "getGodot4Path", "godotPath", "getGodotPath", "getGodotPathFromCorePlayerRunConfiguration", "getGodotPathFromPlayerRunConfiguration", "port", "getPort", "()I", "Companion", "ProtocolListener", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotProjectDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n295#2,2:110\n295#2,2:112\n*S KotlinDebug\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer\n*L\n66#1:110,2\n79#1:112,2\n*E\n"})
public final class GodotProjectDiscoverer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IProperty<GodotDescriptor> godotDescriptor;
    @NotNull
    private final IProperty<LanguageServerConnectionMode> lspConnectionMode;
    @NotNull
    private final IProperty<Integer> remoteHostPort;
    @NotNull
    private final IProperty<Boolean> useDynamicPort;
    @NotNull
    private final Logger logger;
    @NotNull
    private final IProperty<String> godot3Path;
    @NotNull
    private final IProperty<String> godot4Path;
    @NotNull
    private final IProperty<String> godotPath;
    private final int port;

    public GodotProjectDiscoverer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.godotDescriptor = (IProperty)new Property(null);
        this.lspConnectionMode = (IProperty)new Property(null);
        this.remoteHostPort = (IProperty)new Property(null);
        this.useDynamicPort = (IProperty)new Property(null);
        Logger logger = Logger.getInstance(GodotProjectDiscoverer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.godot3Path = (IProperty)new Property(null);
        this.godot4Path = (IProperty)new Property(null);
        this.godotPath = (IProperty)new Property(null);
        Lifetime lifetime = GodotProjectLifetimeService.Companion.getLifetime(project);
        SourceExKt.adviseNotNull((ISource)((ISource)this.godot3Path), (Lifetime)lifetime, arg_0 -> GodotProjectDiscoverer._init_$lambda$0(this, arg_0));
        SourceExKt.adviseNotNull((ISource)((ISource)this.godot4Path), (Lifetime)lifetime, arg_0 -> GodotProjectDiscoverer._init_$lambda$1(this, arg_0));
        SourceExKt.adviseNotNull((ISource)((ISource)this.godotDescriptor), (Lifetime)lifetime, arg_0 -> GodotProjectDiscoverer._init_$lambda$2(this, lifetime, project, arg_0));
        this.port = 23685;
    }

    @NotNull
    public final IProperty<GodotDescriptor> getGodotDescriptor() {
        return this.godotDescriptor;
    }

    @NotNull
    public final IProperty<LanguageServerConnectionMode> getLspConnectionMode() {
        return this.lspConnectionMode;
    }

    @NotNull
    public final IProperty<Integer> getRemoteHostPort() {
        return this.remoteHostPort;
    }

    @NotNull
    public final IProperty<Boolean> getUseDynamicPort() {
        return this.useDynamicPort;
    }

    @NotNull
    public final IProperty<String> getGodot3Path() {
        return this.godot3Path;
    }

    @NotNull
    public final IProperty<String> getGodot4Path() {
        return this.godot4Path;
    }

    @NotNull
    public final IProperty<String> getGodotPath() {
        return this.godotPath;
    }

    private final String getGodotPathFromCorePlayerRunConfiguration(Project project) {
        Object v0;
        block3: {
            RunManager runManager = RunManager.Companion.getInstance(project);
            Iterable $this$firstOrNull$iv = runManager.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(it.getType() instanceof DotNetExeConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)"Player"))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        RunnerAndConfigurationSettings playerSettings = v0;
        if (playerSettings != null) {
            RunConfiguration runConfiguration = playerSettings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
            DotNetExeConfiguration config = (DotNetExeConfiguration)runConfiguration;
            String path = config.getParameters().getExePath();
            if (((CharSequence)path).length() > 0 && new File(path).exists()) {
                return path;
            }
        }
        return null;
    }

    private final String getGodotPathFromPlayerRunConfiguration(Project project) {
        Object v0;
        block3: {
            RunManager runManager = RunManager.Companion.getInstance(project);
            Iterable $this$firstOrNull$iv = runManager.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(it.getType() instanceof GodotDebugRunConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)"Player"))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        RunnerAndConfigurationSettings playerSettings = v0;
        if (playerSettings != null) {
            RunConfiguration runConfiguration = playerSettings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration");
            GodotDebugRunConfiguration config = (GodotDebugRunConfiguration)runConfiguration;
            String path = config.getParameters().getExePath();
            if (((CharSequence)path).length() > 0 && new File(path).exists()) {
                return path;
            }
        }
        return null;
    }

    public final int getPort() {
        return this.port;
    }

    private static final Unit _init_$lambda$0(GodotProjectDiscoverer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.godotPath.set((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GodotProjectDiscoverer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.godotPath.set((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(GodotProjectDiscoverer this$0, Lifetime $lifetime, Project $project, GodotDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.info("Godot godotDescriptor: " + it);
        File basePath = new File(it.getMainProjectBasePath());
        LifetimeCoroutineUtilKt.launch$default((Lifetime)$lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(basePath, this$0, $project, null){
            int label;
            final /* synthetic */ File $basePath;
            final /* synthetic */ GodotProjectDiscoverer this$0;
            final /* synthetic */ Project $project;
            {
                this.$basePath = $basePath;
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        String g3path;
                        ResultKt.throwOnFailure((Object)object);
                        String string2 = MetadataMonoFileWatcher.Util.INSTANCE.getFromMonoMetadataPath(this.$basePath);
                        if (string2 == null && (string2 = MetadataMonoFileWatcher.Util.INSTANCE.getGodotPath(this.$basePath)) == null) {
                            string2 = g3path = GodotProjectDiscoverer.access$getGodotPathFromPlayerRunConfiguration(this.this$0, this.$project);
                        }
                        if ((string = MetadataCoreFileWatcher.Util.INSTANCE.getGodotPath(this.$basePath)) == null) {
                            string = GodotProjectDiscoverer.access$getGodotPathFromCorePlayerRunConfiguration(this.this$0, this.$project);
                        }
                        String g4path = string;
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, g3path, g4path, null){
                            int label;
                            final /* synthetic */ GodotProjectDiscoverer this$0;
                            final /* synthetic */ String $g3path;
                            final /* synthetic */ String $g4path;
                            {
                                this.this$0 = $receiver;
                                this.$g3path = $g3path;
                                this.$g4path = $g4path;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.this$0.getGodot3Path().set((Object)this.$g3path);
                                        this.this$0.getGodot4Path().set((Object)this.$g4path);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getGodotPathFromPlayerRunConfiguration(GodotProjectDiscoverer $this, Project project) {
        return $this.getGodotPathFromPlayerRunConfiguration(project);
    }

    public static final /* synthetic */ String access$getGodotPathFromCorePlayerRunConfiguration(GodotProjectDiscoverer $this, Project project) {
        return $this.getGodotPathFromCorePlayerRunConfiguration(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotProjectDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,109:1\n17#2,2:110\n*S KotlinDebug\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion\n*L\n93#1:110,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GodotProjectDiscoverer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getService$iv = (ComponentManager)project;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(GodotProjectDiscoverer.class);
            if (object == null) {
                throw new IllegalStateException("Service " + GodotProjectDiscoverer.class + " not found in container " + $this$getService$iv);
            }
            return (GodotProjectDiscoverer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/godot/frontendBackend/GodotFrontendBackendModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.godot"})
    public static final class ProtocolListener
    implements SolutionExtListener<GodotFrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull GodotFrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            SourceExKt.adviseNotNull((ISource)((ISource)model.getGodotDescriptor()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$0(session, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getLspConnectionMode()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$1(session, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getRemoteHostPort()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$2(session, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getUseDynamicPort()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$3(session, arg_0));
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, GodotDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.getInstance($session.getProject()).getGodotDescriptor().set((Object)it);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(ClientProjectSession $session, LanguageServerConnectionMode it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            Companion.getInstance($session.getProject()).getLspConnectionMode().set((Object)it);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$2(ClientProjectSession $session, int it) {
            Companion.getInstance($session.getProject()).getRemoteHostPort().set((Object)it);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$3(ClientProjectSession $session, boolean it) {
            Companion.getInstance($session.getProject()).getUseDynamicPort().set((Object)it);
            return Unit.INSTANCE;
        }
    }
}

