/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.repository;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.changeReminder.UtilKt;
import com.jetbrains.changeReminder.repository.Commit;
import git4idea.GitCommit;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitHistoryTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000bH\u0002J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R>\u0010\b\u001a2\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000b0\tj\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000b`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;", "", "traverser", "Lgit4idea/history/GitHistoryTraverser;", "<init>", "(Lgit4idea/history/GitHistoryTraverser;)V", "getTraverser", "()Lgit4idea/history/GitHistoryTraverser;", "filesHistoryCache", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vcs/FilePath;", "", "", "Lgit4idea/history/TraverseCommitId;", "Lkotlin/collections/HashMap;", "getCommitsData", "Lcom/jetbrains/changeReminder/repository/Commit;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "getFilesHistory", "indexedRoot", "Lgit4idea/history/GitHistoryTraverser$IndexedRoot;", "clear", "", "Companion", "intellij.vcs.changeReminder"})
@SourceDebugExtension(value={"SMAP\nFilesHistoryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilesHistoryProvider.kt\ncom/jetbrains/changeReminder/repository/FilesHistoryProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1611#2,9:62\n1863#2:71\n1864#2:73\n1620#2:74\n774#2:75\n865#2,2:76\n1279#2,2:78\n1293#2,4:80\n1#3:72\n*S KotlinDebug\n*F\n+ 1 FilesHistoryProvider.kt\ncom/jetbrains/changeReminder/repository/FilesHistoryProvider\n*L\n22#1:62,9\n22#1:71\n22#1:73\n22#1:74\n49#1:75\n49#1:76,2\n50#1:78,2\n50#1:80,4\n22#1:72\n*E\n"})
public final class FilesHistoryProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitHistoryTraverser traverser;
    @NotNull
    private final HashMap<FilePath, Collection<Integer>> filesHistoryCache;
    private static final int MAX_COMMITS_WITH_FILES = 1000;
    private static final int MAX_HISTORY_COMMIT_SIZE = 15;

    public FilesHistoryProvider(@NotNull GitHistoryTraverser traverser) {
        Intrinsics.checkNotNullParameter((Object)traverser, (String)"traverser");
        this.traverser = traverser;
        this.filesHistoryCache = new HashMap();
    }

    @NotNull
    public final GitHistoryTraverser getTraverser() {
        return this.traverser;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Commit> getCommitsData(VirtualFile root, Collection<? extends FilePath> files) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Collection<Integer> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FilePath it = (FilePath)element$iv$iv;
            boolean bl2 = false;
            if (this.filesHistoryCache.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List commitsWithFiles = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        Set commitsData = new LinkedHashSet();
        GitCommitRequirements requirements = new GitCommitRequirements(false, (GitCommitRequirements.DiffRenames)GitCommitRequirements.DiffRenames.NoRenames.INSTANCE, GitCommitRequirements.DiffInMergeCommits.NO_DIFF, 1, null);
        Ref.IntRef commitsWithFilesCount = new Ref.IntRef();
        this.traverser.traverse(root, (GitHistoryTraverser.StartNode)GitHistoryTraverser.StartNode.Head.INSTANCE, GitHistoryTraverser.TraverseType.BFS, (arg_0, arg_1) -> FilesHistoryProvider.getCommitsData$lambda$2(commitsWithFiles, requirements, commitsWithFilesCount, commitsData, arg_0, arg_1));
        return commitsData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Commit> getFilesHistory(@NotNull GitHistoryTraverser.IndexedRoot indexedRoot, @NotNull Collection<? extends FilePath> files) {
        void $this$associateWith$iv;
        FilePath it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)indexedRoot, (String)"indexedRoot");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        UtilKt.retainAll((Map)this.filesHistoryCache, files);
        Iterable iterable = files;
        HashMap<FilePath, Collection<Integer>> hashMap = this.filesHistoryCache;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FilePath)element$iv$iv;
            boolean bl = false;
            if (!(!((Map)this.filesHistoryCache).containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void file;
            it = (FilePath)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)file);
            Collection collection = indexedRoot.filterCommits((GitHistoryTraverser.IndexedRoot.TraverseCommitsFilter)new GitHistoryTraverser.IndexedRoot.TraverseCommitsFilter.File((FilePath)file));
            map.put(t, collection);
        }
        hashMap.putAll(result$iv);
        return this.getCommitsData(indexedRoot.getRoot(), files);
    }

    public final void clear() {
        this.filesHistoryCache.clear();
    }

    private static final Unit getCommitsData$lambda$2$lambda$1(Set $commitsData, int $commitId, GitCommit commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Set set = commit.getAffectedPaths();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAffectedPaths(...)");
        Set affectedPaths = set;
        int n = affectedPaths.size();
        boolean bl = 1 <= n ? n < 16 : false;
        if (bl) {
            long l = commit.getCommitTime();
            String string = commit.getAuthor().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            $commitsData.add(new Commit($commitId, l, string, affectedPaths));
        }
        return Unit.INSTANCE;
    }

    private static final boolean getCommitsData$lambda$2(List $commitsWithFiles, GitCommitRequirements $requirements, Ref.IntRef $commitsWithFilesCount, Set $commitsData, GitHistoryTraverser.Traverse $this$traverse, GitHistoryTraverser.TraverseCommitInfo traverseCommitInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$traverse, (String)"$this$traverse");
        Intrinsics.checkNotNullParameter((Object)traverseCommitInfo, (String)"<destruct>");
        int commitId = traverseCommitInfo.component1();
        if ($commitsWithFiles.contains(commitId)) {
            $this$traverse.loadFullDetailsLater(commitId, $requirements, arg_0 -> FilesHistoryProvider.getCommitsData$lambda$2$lambda$1($commitsData, commitId, arg_0));
            int n = $commitsWithFilesCount.element;
            $commitsWithFilesCount.element = n + 1;
        }
        return $commitsWithFilesCount.element != 1000;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider$Companion;", "", "<init>", "()V", "MAX_COMMITS_WITH_FILES", "", "MAX_HISTORY_COMMIT_SIZE", "intellij.vcs.changeReminder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

