/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.changes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.jetbrains.changeReminder.ChangeReminderBundle;
import com.jetbrains.changeReminder.predict.PredictionData;
import com.jetbrains.changeReminder.predict.PredictionService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\b\u001a\u00020\t*\u00020\n2\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0002J(\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/changeReminder/changes/ChangeReminderBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/jetbrains/changeReminder/predict/PredictionData;", "predictionData", "predictionService", "Lcom/jetbrains/changeReminder/predict/PredictionService;", "<init>", "(Lcom/jetbrains/changeReminder/predict/PredictionData;Lcom/jetbrains/changeReminder/predict/PredictionService;)V", "appendCustomState", "", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "state", "", "Lorg/jetbrains/annotations/Nls;", "render", "renderer", "selected", "", "expanded", "hasFocus", "getTextPresentation", "intellij.vcs.changeReminder"})
public final class ChangeReminderBrowserNode
extends ChangesBrowserNode<PredictionData> {
    @NotNull
    private final PredictionData predictionData;
    @NotNull
    private final PredictionService predictionService;

    public ChangeReminderBrowserNode(@NotNull PredictionData predictionData, @NotNull PredictionService predictionService) {
        Intrinsics.checkNotNullParameter((Object)predictionData, (String)"predictionData");
        Intrinsics.checkNotNullParameter((Object)predictionService, (String)"predictionService");
        super((Object)predictionData);
        this.predictionData = predictionData;
        this.predictionService = predictionService;
    }

    private final void appendCustomState(ChangesBrowserNodeRenderer $this$appendCustomState, String state) {
        String string = this.getCountText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCountText(...)");
        $this$appendCustomState.append((((CharSequence)string).length() == 0 ? FontUtil.spaceAndThinSpace() : ", ") + state, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        renderer.append(ChangeReminderBundle.message("changes.browser.node.title", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.setIcon(AllIcons.Nodes.Related);
        this.appendCount((ColoredTreeCellRenderer)renderer);
        Project project = this.predictionService.getProject();
        if (this.predictionService.isReadyToDisplay()) {
            if (this.predictionService.getInProgress()) {
                String string = ChangeReminderBundle.message("changes.browser.node.attribute.prediction.is.calculating", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.appendCustomState(renderer, string);
            }
        } else {
            String string = ChangeReminderBundle.message("changes.browser.node.attribute.git.log.is.loading", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.appendCustomState(renderer, string);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        LocalChangeList localChangeList = changeListManager2.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        LocalChangeList defaultChangeList = localChangeList;
        int predictionSize = this.predictionData.getPredictionToDisplay().size();
        Object[] objectArray = new Object[]{predictionSize, defaultChangeList.getChanges().size(), defaultChangeList.getName()};
        renderer.setToolTipText(ChangeReminderBundle.message("changes.browser.node.prediction.tooltip.text", objectArray));
    }

    @NotNull
    public String getTextPresentation() {
        String string = ChangeReminderBundle.message("changes.browser.node.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

