/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.actions;

import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.dmarcotte.handlebars.psi.HbPsiFile;
import com.dmarcotte.handlebars.psi.HbPsiUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class HbEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            HbEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            HbEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            HbEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            HbEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            HbEnterHandler.$$$reportNull$$$0(4);
        }
        if (file instanceof HbPsiFile && HbEnterHandler.isBetweenHbTags(editor, file, (Integer)caretOffset.get())) {
            originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            return EnterHandlerDelegate.Result.Default;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBetweenHbTags(Editor editor, PsiFile file, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '}') {
            return false;
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement openerElement = file.findElementAt(iterator.getStart());
        HbOpenBlockMustache openTag = HbPsiUtil.findParentOpenTagElement(openerElement);
        if (openTag == null) {
            return false;
        }
        iterator.advance();
        if (iterator.atEnd()) {
            return false;
        }
        PsiElement closerElement = file.findElementAt(iterator.getStart());
        HbCloseBlockMustache closeTag = HbPsiUtil.findParentCloseTagElement(closerElement);
        return closeTag != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/dmarcotte/handlebars/editor/actions/HbEnterHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

