/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/debugger/ScriptDebuggerUrls;", "", "<init>", "()V", "newLocalFileUrl", "Lcom/intellij/util/Url;", "path", "", "toFilePath", "url", "toUriPath", "decodeAndConvertToSystemIndependent", "toUri", "absoluteOrRelativePath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "parse", "asLocalIfNoScheme", "", "toLocalFileUrl", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public final class ScriptDebuggerUrls {
    @NotNull
    public static final ScriptDebuggerUrls INSTANCE = new ScriptDebuggerUrls();

    private ScriptDebuggerUrls() {
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String uriPath = INSTANCE.toUriPath(path);
        return Urls.newUrl((String)"file", (String)"", (String)uriPath);
    }

    @Nullable
    public final String toFilePath(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url.getScheme() != null && !Intrinsics.areEqual((Object)url.getScheme(), (Object)"file")) {
            return null;
        }
        String string2 = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String path = string2;
        if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            String string3 = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            path = string3;
        }
        return path;
    }

    private final String toUriPath(String path) {
        Object result2 = this.decodeAndConvertToSystemIndependent(path);
        if (((String)result2).length() >= 2 && ((String)result2).charAt(1) == ':') {
            result2 = "/" + (String)result2;
        }
        return result2;
    }

    private final String decodeAndConvertToSystemIndependent(String path) {
        String string2 = FileUtilRt.toSystemIndependentName((String)URLUtil.unescapePercentSequences((String)path));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        return string2;
    }

    private final Url toUri(String absoluteOrRelativePath) {
        Object result2 = this.decodeAndConvertToSystemIndependent(absoluteOrRelativePath);
        if (((String)result2).length() >= 2 && ((String)result2).charAt(1) == ':') {
            result2 = "/" + (String)result2;
        }
        return ((CharSequence)result2).length() > 0 && ((String)result2).charAt(0) == '/' ? ScriptDebuggerUrls.newLocalFileUrl((String)result2) : Urls.newUnparsable((String)result2);
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return ScriptDebuggerUrls.newLocalFileUrl(string2);
    }

    @JvmStatic
    @Nullable
    public static final Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return asLocalIfNoScheme && !URLUtil.containsScheme((String)url) ? INSTANCE.toUri(url) : (StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null) ? INSTANCE.toLocalFileUrl(url) : Urls.parse((String)url, (boolean)false));
    }

    @NotNull
    public final Url toLocalFileUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string2 = VfsUtilCore.toIdeaUrl((String)url, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toIdeaUrl(...)");
        String string3 = string2;
        int n = 7;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String canonicalPath = FileUtil.toCanonicalPath((String)string4, (char)'/');
        Intrinsics.checkNotNull((Object)canonicalPath);
        return ScriptDebuggerUrls.newLocalFileUrl(canonicalPath);
    }
}

