/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.toolwindow;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/clones/toolwindow/DuplicateNavigator;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "highlightManager", "Lcom/intellij/codeInsight/highlighting/HighlightManager;", "previousHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "previousEditor", "Lcom/intellij/openapi/editor/Editor;", "highlightAndNavigate", "", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "removeHighlighting", "dispose", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicatesList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicatesList.kt\ncom/jetbrains/clones/toolwindow/DuplicateNavigator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1863#2,2:214\n*S KotlinDebug\n*F\n+ 1 DuplicatesList.kt\ncom/jetbrains/clones/toolwindow/DuplicateNavigator\n*L\n205#1:214,2\n*E\n"})
final class DuplicateNavigator
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final HighlightManager highlightManager;
    @NotNull
    private List<RangeHighlighter> previousHighlighters;
    @Nullable
    private Editor previousEditor;

    public DuplicateNavigator(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)highlightManager, (String)"getInstance(...)");
        this.highlightManager = highlightManager;
        this.previousHighlighters = new ArrayList();
    }

    public final void highlightAndNavigate(@Nullable RangeMarker range) {
        if (range == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> DuplicateNavigator.highlightAndNavigate$action(range, this), ModalityState.nonModal());
    }

    private final void removeHighlighting() {
        Editor editor = this.previousEditor;
        if (editor != null) {
            Iterable $this$forEach$iv = this.previousHighlighters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter highlighter = (RangeHighlighter)element$iv;
                boolean bl = false;
                this.highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
        }
        this.previousHighlighters.clear();
    }

    public void dispose() {
        this.removeHighlighting();
    }

    private static final void highlightAndNavigate$action(RangeMarker $range, DuplicateNavigator this$0) {
        VirtualFile file = FileDocumentManager.getInstance().getFile($range.getDocument());
        if ($range.isValid()) {
            VirtualFile virtualFile = file;
            boolean bl = virtualFile != null ? virtualFile.isValid() : false;
            if (bl) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(this$0.project, file, $range.getStartOffset());
                Editor editor = FileEditorManager.getInstance((Project)this$0.project).openTextEditor(descriptor, false);
                if (editor != null) {
                    this$0.removeHighlighting();
                    this$0.previousEditor = editor;
                    this$0.highlightManager.addRangeHighlight(editor, $range.getStartOffset(), $range.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, false, (Collection)this$0.previousHighlighters);
                }
            }
        }
    }
}

