/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.Stack;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.completion.WebSymbolCodeCompletionItem;
import com.intellij.webSymbols.query.WebSymbolsCodeCompletionQueryParams;
import com.intellij.webSymbols.query.WebSymbolsListSymbolsQueryParams;
import com.intellij.webSymbols.query.WebSymbolsNameMatchQueryParams;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B3\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J,\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J,\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020*2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J\u0006\u0010+\u001a\u00020,J\u0013\u0010-\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010/H\u0086\u0002J\b\u00100\u001a\u000201H\u0016J\u001a\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001b0<H\u0002R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\n\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R*\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001b0\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001b\u00102\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b3\u00104R!\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u00106\u001a\u0004\b8\u00109\u00a8\u0006="}, d2={"Lcom/intellij/webSymbols/utils/WebSymbolsIsolatedMappingScope;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "mappings", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "framework", "", "Lcom/intellij/webSymbols/FrameworkId;", "location", "<init>", "(Ljava/util/Map;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getMappings", "()Ljava/util/Map;", "getFramework", "()Ljava/lang/String;", "getLocation", "()Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiElement;", "acceptSymbol", "", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "subScopeBuilder", "Lkotlin/Function2;", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "", "getSubScopeBuilder", "()Lkotlin/jvm/functions/Function2;", "getCodeCompletions", "Lcom/intellij/webSymbols/completion/WebSymbolCodeCompletionItem;", "qualifiedName", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "params", "Lcom/intellij/webSymbols/query/WebSymbolsCodeCompletionQueryParams;", "scope", "Lcom/intellij/util/containers/Stack;", "getMatchingSymbols", "Lcom/intellij/webSymbols/query/WebSymbolsNameMatchQueryParams;", "getSymbols", "qualifiedKind", "Lcom/intellij/webSymbols/query/WebSymbolsListSymbolsQueryParams;", "getModificationCount", "", "equals", "other", "", "hashCode", "", "subQuery", "getSubQuery", "()Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "subQuery$delegate", "Lkotlin/Lazy;", "additionalScope", "getAdditionalScope", "()Ljava/util/List;", "additionalScope$delegate", "getCachedSubQueryExecutorAndScope", "Lkotlin/Pair;", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsIsolatedMappingScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsIsolatedMappingScope.kt\ncom/intellij/webSymbols/utils/WebSymbolsIsolatedMappingScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,103:1\n774#2:104\n865#2:105\n866#2:107\n774#2:108\n865#2,2:109\n1557#2:111\n1628#2,3:112\n774#2:115\n865#2,2:116\n1557#2:119\n1628#2,3:120\n1#3:106\n52#4:118\n*S KotlinDebug\n*F\n+ 1 WebSymbolsIsolatedMappingScope.kt\ncom/intellij/webSymbols/utils/WebSymbolsIsolatedMappingScope\n*L\n39#1:104\n39#1:105\n39#1:107\n51#1:108\n51#1:109,2\n52#1:111\n52#1:112,3\n64#1:115\n64#1:116,2\n65#1:119\n65#1:120,3\n65#1:118\n*E\n"})
public abstract class WebSymbolsIsolatedMappingScope<T extends PsiElement>
implements WebSymbolsScope {
    @NotNull
    private final Map<WebSymbolQualifiedKind, WebSymbolQualifiedKind> mappings;
    @Nullable
    private final String framework;
    @NotNull
    private final T location;
    @NotNull
    private final Lazy subQuery$delegate;
    @NotNull
    private final Lazy additionalScope$delegate;

    public WebSymbolsIsolatedMappingScope(@NotNull Map<WebSymbolQualifiedKind, WebSymbolQualifiedKind> mappings, @Nullable String framework, @NotNull T location) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter(location, (String)"location");
        this.mappings = mappings;
        this.framework = framework;
        this.location = location;
        this.subQuery$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> WebSymbolsIsolatedMappingScope.subQuery_delegate$lambda$10(this));
        this.additionalScope$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> WebSymbolsIsolatedMappingScope.additionalScope_delegate$lambda$11(this));
    }

    @NotNull
    protected final Map<WebSymbolQualifiedKind, WebSymbolQualifiedKind> getMappings() {
        return this.mappings;
    }

    @Nullable
    protected final String getFramework() {
        return this.framework;
    }

    @NotNull
    protected final T getLocation() {
        return this.location;
    }

    protected abstract boolean acceptSymbol(@NotNull WebSymbol var1);

    @NotNull
    protected abstract Function2<WebSymbolsQueryExecutor, T, List<WebSymbolsScope>> getSubScopeBuilder();

    @Override
    @NotNull
    public List<WebSymbolCodeCompletionItem> getCodeCompletions(@NotNull WebSymbolQualifiedName qualifiedName, @NotNull WebSymbolsCodeCompletionQueryParams params, @NotNull Stack<WebSymbolsScope> scope) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        if (!params.getQueryExecutor().allowResolve() || this.framework != null && !Intrinsics.areEqual((Object)params.getFramework(), (Object)this.framework)) {
            return CollectionsKt.emptyList();
        }
        WebSymbolQualifiedKind webSymbolQualifiedKind = this.mappings.get(qualifiedName.getQualifiedKind());
        if (webSymbolQualifiedKind == null) {
            return CollectionsKt.emptyList();
        }
        WebSymbolQualifiedKind sourceKind = webSymbolQualifiedKind;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = CollectionsKt.emptyList();
        RecursionManager.runInNewContext(() -> WebSymbolsIsolatedMappingScope.getCodeCompletions$lambda$2(result2, this, sourceKind, qualifiedName, params));
        return (List)result2.element;
    }

    @Override
    @NotNull
    public List<WebSymbol> getMatchingSymbols(@NotNull WebSymbolQualifiedName qualifiedName, @NotNull WebSymbolsNameMatchQueryParams params, @NotNull Stack<WebSymbolsScope> scope) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        if (!params.getQueryExecutor().allowResolve() || this.framework != null && !Intrinsics.areEqual((Object)params.getFramework(), (Object)this.framework)) {
            return CollectionsKt.emptyList();
        }
        WebSymbolQualifiedKind webSymbolQualifiedKind = this.mappings.get(qualifiedName.getQualifiedKind());
        if (webSymbolQualifiedKind == null) {
            return CollectionsKt.emptyList();
        }
        WebSymbolQualifiedKind sourceKind = webSymbolQualifiedKind;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = CollectionsKt.emptyList();
        RecursionManager.runInNewContext(() -> WebSymbolsIsolatedMappingScope.getMatchingSymbols$lambda$5(result2, this, sourceKind, qualifiedName, params));
        return (List)result2.element;
    }

    @Override
    @NotNull
    public List<WebSymbolsScope> getSymbols(@NotNull WebSymbolQualifiedKind qualifiedKind, @NotNull WebSymbolsListSymbolsQueryParams params, @NotNull Stack<WebSymbolsScope> scope) {
        Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        if (!params.getQueryExecutor().allowResolve() || this.framework != null && !Intrinsics.areEqual((Object)params.getFramework(), (Object)this.framework)) {
            return CollectionsKt.emptyList();
        }
        WebSymbolQualifiedKind webSymbolQualifiedKind = this.mappings.get(qualifiedKind);
        if (webSymbolQualifiedKind == null) {
            return CollectionsKt.emptyList();
        }
        WebSymbolQualifiedKind sourceKind = webSymbolQualifiedKind;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = CollectionsKt.emptyList();
        RecursionManager.runInNewContext(() -> WebSymbolsIsolatedMappingScope.getSymbols$lambda$9(result2, this, sourceKind, params, qualifiedKind));
        return (List)result2.element;
    }

    public final long getModificationCount() {
        return PsiModificationTracker.getInstance((Project)this.location.getProject()).getModificationCount();
    }

    public final boolean equals(@Nullable Object other) {
        return other == this || other != null && other instanceof WebSymbolsIsolatedMappingScope && Intrinsics.areEqual(other.getClass(), this.getClass()) && Intrinsics.areEqual((Object)((WebSymbolsIsolatedMappingScope)other).framework, (Object)this.framework) && Intrinsics.areEqual(((WebSymbolsIsolatedMappingScope)other).location, this.location);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.framework, this.location};
        return Objects.hash(objectArray);
    }

    private final WebSymbolsQueryExecutor getSubQuery() {
        Lazy lazy = this.subQuery$delegate;
        return (WebSymbolsQueryExecutor)lazy.getValue();
    }

    private final List<WebSymbolsScope> getAdditionalScope() {
        Lazy lazy = this.additionalScope$delegate;
        return (List)lazy.getValue();
    }

    private final Pair<WebSymbolsQueryExecutor, List<WebSymbolsScope>> getCachedSubQueryExecutorAndScope() {
        T location = this.location;
        Function2<WebSymbolsQueryExecutor, T, List<WebSymbolsScope>> builder2 = this.getSubScopeBuilder();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)location.getProject());
        Key key2 = manager.getKeyForClass(builder2.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"getKeyForClass(...)");
        Key cachedValueKey = key2;
        Object object = manager.getCachedValue((UserDataHolder)location, cachedValueKey, () -> WebSymbolsIsolatedMappingScope.getCachedSubQueryExecutorAndScope$lambda$12(location, builder2), false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Pair)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getCodeCompletions$lambda$2(Ref.ObjectRef $result, WebSymbolsIsolatedMappingScope this$0, WebSymbolQualifiedKind $sourceKind, WebSymbolQualifiedName $qualifiedName, WebSymbolsCodeCompletionQueryParams $params) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this$0.getSubQuery().runCodeCompletionQuery($sourceKind, $qualifiedName.getName(), $params.getPosition(), $params.getVirtualSymbols(), this$0.getAdditionalScope());
        Ref.ObjectRef objectRef = $result;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            WebSymbolCodeCompletionItem it = (WebSymbolCodeCompletionItem)element$iv$iv;
            boolean bl2 = false;
            if (it.getSymbol() != null) {
                WebSymbol it2;
                boolean bl3 = false;
                bl = !this$0.acceptSymbol(it2);
            } else {
                bl = false;
            }
            if (!(!bl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        objectRef.element = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMatchingSymbols$lambda$5(Ref.ObjectRef $result, WebSymbolsIsolatedMappingScope this$0, WebSymbolQualifiedKind $sourceKind, WebSymbolQualifiedName $qualifiedName, WebSymbolsNameMatchQueryParams $params) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        WebSymbol it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = this$0.getSubQuery().runNameMatchQuery($sourceKind.withName($qualifiedName.getName()), $params.getVirtualSymbols(), $params.getAbstractSymbols(), $params.getStrictScope(), this$0.getAdditionalScope());
        Ref.ObjectRef objectRef = $result;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WebSymbol)element$iv$iv;
            boolean bl = false;
            if (!this$0.acceptSymbol(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WebSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WebSymbolUtils.withMatchedKind(it, $qualifiedName.getQualifiedKind()));
        }
        objectRef.element = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getSymbols$lambda$9(Ref.ObjectRef $result, WebSymbolsIsolatedMappingScope this$0, WebSymbolQualifiedKind $sourceKind, WebSymbolsListSymbolsQueryParams $params, WebSymbolQualifiedKind $qualifiedKind) {
        List list2;
        Object it;
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        Iterable iterable = this$0.getSubQuery().runListSymbolsQuery($sourceKind, $params.getExpandPatterns(), $params.getVirtualSymbols(), $params.getAbstractSymbols(), $params.getStrictScope(), this$0.getAdditionalScope());
        Ref.ObjectRef objectRef = $result;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WebSymbol)element$iv$iv;
            boolean bl = false;
            if (!this$0.acceptSymbol((WebSymbol)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Ref.ObjectRef objectRef2 = objectRef;
        $this$filter$iv = (List)destination$iv$iv;
        boolean condition$iv = $params.getExpandPatterns();
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$mapTo$iv$iv;
            void $this$getSymbols_u24lambda_u249_u24lambda_u248;
            destination$iv$iv = $this$applyIf$iv;
            objectRef = objectRef2;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)$this$getSymbols_u24lambda_u249_u24lambda_u248;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                WebSymbol webSymbol = (WebSymbol)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(WebSymbolUtils.withMatchedKind((WebSymbol)it2, $qualifiedKind));
            }
            list2 = (List)destination$iv$iv2;
            objectRef2 = objectRef;
        } else {
            list2 = $this$applyIf$iv;
        }
        objectRef2.element = list2;
    }

    private static final WebSymbolsQueryExecutor subQuery_delegate$lambda$10(WebSymbolsIsolatedMappingScope this$0) {
        return (WebSymbolsQueryExecutor)this$0.getCachedSubQueryExecutorAndScope().getFirst();
    }

    private static final List additionalScope_delegate$lambda$11(WebSymbolsIsolatedMappingScope this$0) {
        return (List)this$0.getCachedSubQueryExecutorAndScope().getSecond();
    }

    private static final CachedValueProvider.Result getCachedSubQueryExecutorAndScope$lambda$12(PsiElement $location, Function2 $builder) {
        WebSymbolsQueryExecutor executor = WebSymbolsQueryExecutorFactory.Companion.create$default(WebSymbolsQueryExecutorFactory.Companion, $location, false, 2, null);
        List scope = (List)$builder.invoke((Object)executor, (Object)$location);
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)new Pair((Object)executor, (Object)CollectionsKt.toList((Iterable)scope)), (Object[])objectArray);
    }
}

