/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.reflect;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrarImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomExtenderEP
implements PluginAware {
    @ApiStatus.Internal
    public static final ExtensionPointName<DomExtenderEP> EP_NAME = new ExtensionPointName("com.intellij.dom.extender");
    private static final Logger LOG = Logger.getInstance(DomExtenderEP.class);
    private PluginDescriptor pluginDescriptor;
    @RequiredElement
    @Attribute(value="domClass")
    public String domClassName;
    @RequiredElement
    @Attribute(value="extenderClass")
    public String extenderClassName;
    private volatile Class<?> myDomClass;
    private volatile DomExtender<?> myExtender;

    private DomExtenderEP() {
    }

    public DomExtenderEP(@NotNull String domClassName, @NotNull PluginDescriptor pluginDescriptor) {
        if (domClassName == null) {
            DomExtenderEP.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            DomExtenderEP.$$$reportNull$$$0(1);
        }
        this.domClassName = domClassName;
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public DomExtensionsRegistrarImpl extend(@NotNull Project project2, @NotNull DomInvocationHandler handler2, @Nullable DomExtensionsRegistrarImpl registrar) {
        if (project2 == null) {
            DomExtenderEP.$$$reportNull$$$0(2);
        }
        if (handler2 == null) {
            DomExtenderEP.$$$reportNull$$$0(3);
        }
        if (this.myDomClass == null) {
            try {
                this.myDomClass = Class.forName(this.domClassName, true, this.pluginDescriptor.getPluginClassLoader());
            }
            catch (Throwable e) {
                LOG.error((Throwable)new PluginException(e, this.pluginDescriptor.getPluginId()));
                return registrar;
            }
        }
        if (!this.myDomClass.isAssignableFrom(handler2.getRawType())) {
            return registrar;
        }
        if (this.myExtender == null) {
            try {
                this.myExtender = (DomExtender)project2.instantiateClass(this.extenderClassName, this.pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                return registrar;
            }
        }
        if (!this.myExtender.supportsStubs() && XmlUtil.isStubBuilding()) {
            return registrar;
        }
        if (registrar == null) {
            registrar = new DomExtensionsRegistrarImpl();
        }
        this.myExtender.registerExtensions(handler2.getProxy(), registrar);
        return registrar;
    }

    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DomExtenderEP.$$$reportNull$$$0(4);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domClassName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/reflect/DomExtenderEP";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extend";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setPluginDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

