/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuotedValueConverter<T>
extends ResolvingConverter<T>
implements CustomReferenceConverter<T> {
    public static final char[] QUOTE_SIGNS = new char[]{'\'', '\"', '`'};

    protected char[] getQuoteSigns() {
        return QUOTE_SIGNS;
    }

    protected char getQuoteSign(T t, ConvertContext context) {
        return '\u0000';
    }

    @Nullable
    protected abstract T convertString(@Nullable String var1, ConvertContext var2);

    @Nullable
    protected abstract String convertValue(@Nullable T var1, ConvertContext var2);

    protected abstract Object[] getReferenceVariants(ConvertContext var1, GenericDomValue<T> var2, TextRange var3);

    protected abstract ResolveResult @NotNull [] multiResolveReference(@Nullable T var1, ConvertContext var2);

    @InspectionMessage
    protected abstract String getUnresolvedMessage(String var1);

    @Override
    @NotNull
    public Collection<? extends T> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            QuotedValueConverter.$$$reportNull$$$0(0);
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            QuotedValueConverter.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public T fromString(String str, @NotNull ConvertContext context) {
        if (context == null) {
            QuotedValueConverter.$$$reportNull$$$0(2);
        }
        return this.convertString(QuotedValueConverter.unquote(str, this.getQuoteSigns()), context);
    }

    @Override
    public String toString(T ts, @NotNull ConvertContext context) {
        if (context == null) {
            QuotedValueConverter.$$$reportNull$$$0(3);
        }
        char delimiter = this.getQuoteSign(ts, context);
        String s = this.convertValue(ts, context);
        return delimiter > '\u0000' ? delimiter + s + delimiter : s;
    }

    @Override
    public PsiReference @NotNull [] createReferences(GenericDomValue<T> genericDomValue, PsiElement element, ConvertContext context) {
        String originalValue = genericDomValue.getStringValue();
        if (originalValue == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                QuotedValueConverter.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String unquotedValue = QuotedValueConverter.unquote(originalValue, this.getQuoteSigns());
        int valueOffset = range.substring(element.getText()).indexOf(unquotedValue);
        if (valueOffset < 0) {
            if (PsiReference.EMPTY_ARRAY == null) {
                QuotedValueConverter.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int start2 = range.getStartOffset() + valueOffset;
        int end = start2 + unquotedValue.length();
        boolean unclosedQuotation = valueOffset > 0 && end == range.getEndOffset();
        PsiReference[] psiReferenceArray = new PsiReference[]{this.createPsiReference(element, start2, end, true, context, genericDomValue, unclosedQuotation)};
        if (psiReferenceArray == null) {
            QuotedValueConverter.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static String unquote(String str) {
        return QuotedValueConverter.unquote(str, QUOTE_SIGNS);
    }

    @Contract(value="null, _ -> null")
    public static String unquote(String str, char[] quoteSigns) {
        if (str != null && str.length() > 2) {
            char c = str.charAt(0);
            for (char quote : quoteSigns) {
                if (quote != c) continue;
                return str.substring(1, c == str.charAt(str.length() - 1) ? str.length() - 1 : str.length());
            }
        }
        return str;
    }

    public static boolean quotationIsNotClosed(String str) {
        return StringUtil.isNotEmpty((String)str) && str.charAt(0) != str.charAt(str.length() - 1);
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start2, int end, boolean isSoft, ConvertContext context, GenericDomValue<T> genericDomValue, boolean badQuotation) {
        return new MyPsiReference(element, new TextRange(start2, end), isSoft, context, genericDomValue, badQuotation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/converters/QuotedValueConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/converters/QuotedValueConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 5, 6 -> new IllegalStateException(string2);
        };
    }

    protected class MyPsiReference
    extends PsiPolyVariantReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        protected final ConvertContext myContext;
        protected final GenericDomValue<T> myGenericDomValue;
        private final boolean myBadQuotation;

        public MyPsiReference(PsiElement element, TextRange range, boolean isSoft, ConvertContext context, GenericDomValue<T> genericDomValue, boolean badQuotation) {
            super(element, range, isSoft);
            this.myContext = context;
            this.myGenericDomValue = genericDomValue;
            this.myBadQuotation = badQuotation;
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            if (this.myBadQuotation) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    MyPsiReference.$$$reportNull$$$0(0);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            String value = this.getValue();
            ResolveResult[] resolveResultArray = QuotedValueConverter.this.multiResolveReference(QuotedValueConverter.this.convertString(value, this.myContext), this.myContext);
            if (resolveResultArray == null) {
                MyPsiReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = QuotedValueConverter.this.getReferenceVariants(this.myContext, this.myGenericDomValue, this.getRangeInElement());
            if (objectArray == null) {
                MyPsiReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string2 = this.myBadQuotation ? XmlDomBundle.message("dom.inspections.invalid.value.quotation", new Object[0]) : QuotedValueConverter.this.getUnresolvedMessage(this.getValue());
            if (string2 == null) {
                MyPsiReference.$$$reportNull$$$0(3);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/xml/converters/QuotedValueConverter$MyPsiReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

