/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@State(name="StructuralSearchPlugin", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationManager
implements PersistentStateComponent<Element> {
    private static final int MAX_RECENT_SIZE = 30;
    private static final int RECENT_CONFIGURATION_NAME_LENGTH = 40;
    @NonNls
    private static final String SEARCH_TAG_NAME = "searchConfiguration";
    @NonNls
    private static final String REPLACE_TAG_NAME = "replaceConfiguration";
    @NonNls
    private static final String SAVE_HISTORY_ATTR_NAME = "history";
    private final List<Configuration> configurations = new SmartList();
    private final List<Configuration> historyConfigurations = new SmartList();
    private final ConfigurationManagerState myIdeState;
    private final ProjectConfigurationManagerState myProjectState;
    private final Project myProject;
    private boolean myLastSaveWasInProject = false;

    public static ConfigurationManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ConfigurationManager.$$$reportNull$$$0(0);
        }
        return (ConfigurationManager)project2.getService(ConfigurationManager.class);
    }

    public ConfigurationManager(Project project2) {
        this.myProject = project2;
        this.myIdeState = ConfigurationManagerState.getInstance();
        this.myProjectState = ProjectConfigurationManagerState.getInstance(project2);
    }

    public Element getState() {
        Element state = new Element("state");
        ConfigurationManager.writeConfigurations(state, this.configurations, this.historyConfigurations);
        return state;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(1);
        }
        this.configurations.clear();
        this.historyConfigurations.clear();
        SmartList tmp = new SmartList();
        ConfigurationManager.readConfigurations(element, this.configurations, (Collection<? super Configuration>)tmp);
        this.migrate(this.configurations);
        for (Configuration configuration : tmp) {
            this.addHistoryConfiguration(configuration);
        }
        Collections.reverse(this.historyConfigurations);
    }

    private void migrate(@NotNull List<? extends Configuration> configurations) {
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(2);
        }
        if (configurations.isEmpty()) {
            return;
        }
        block0: for (Configuration configuration : configurations) {
            Configuration existing = this.myIdeState.get(configuration.getRefName());
            while (existing != null) {
                if (configuration.equals(existing)) continue block0;
                configuration.setName(configuration.getName() + "~");
                existing = this.myIdeState.get(configuration.getRefName());
            }
            this.myIdeState.add(configuration);
        }
        configurations.clear();
    }

    public void addHistoryConfiguration(@NotNull Configuration configuration) {
        String searchTemplate;
        if (configuration == null) {
            ConfigurationManager.$$$reportNull$$$0(3);
        }
        if ((configuration = configuration.copy()).getCreated() <= 0L) {
            configuration.setCreated(System.currentTimeMillis());
        }
        configuration.setName((String)((searchTemplate = configuration.getMatchOptions().getSearchPattern()).length() < 40 ? searchTemplate : searchTemplate.substring(0, 40).trim() + "\u2026"));
        Configuration old = ConfigurationManager.findConfiguration(this.historyConfigurations, configuration);
        if (old != null) {
            this.historyConfigurations.remove(old);
        }
        this.historyConfigurations.add(0, configuration);
        while (this.historyConfigurations.size() > 30) {
            this.historyConfigurations.remove(this.historyConfigurations.size() - 1);
        }
    }

    public Configuration getMostRecentConfiguration() {
        return this.historyConfigurations.isEmpty() ? null : this.historyConfigurations.get(0);
    }

    @TestOnly
    public void addConfiguration(Configuration configuration) {
        this.myIdeState.add(configuration);
    }

    public void removeConfiguration(Configuration configuration, boolean ide) {
        (ide ? this.myIdeState : this.myProjectState).remove(configuration.getRefName());
    }

    public static void writeConfigurations(@NotNull Element element, @NotNull Collection<? extends Configuration> configurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(4);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(5);
        }
        ConfigurationManager.writeConfigurations(element, configurations, Collections.emptyList());
    }

    private static void writeConfigurations(@NotNull Element element, @NotNull Collection<? extends Configuration> configurations, @NotNull Collection<? extends Configuration> historyConfigurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(6);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(7);
        }
        if (historyConfigurations == null) {
            ConfigurationManager.$$$reportNull$$$0(8);
        }
        for (Configuration configuration : configurations) {
            configuration.getMatchOptions().setScope(null);
            ConfigurationManager.saveConfiguration(element, configuration);
        }
        for (Configuration configuration : historyConfigurations) {
            Element infoElement = ConfigurationManager.saveConfiguration(element, configuration);
            infoElement.setAttribute(SAVE_HISTORY_ATTR_NAME, "1");
        }
    }

    @NotNull
    private static Element saveConfiguration(@NotNull Element element, @NotNull Configuration config) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(9);
        }
        if (config == null) {
            ConfigurationManager.$$$reportNull$$$0(10);
        }
        Element infoElement = new Element(config instanceof SearchConfiguration ? SEARCH_TAG_NAME : REPLACE_TAG_NAME);
        element.addContent(infoElement);
        config.writeExternal(infoElement);
        Element element2 = infoElement;
        if (element2 == null) {
            ConfigurationManager.$$$reportNull$$$0(11);
        }
        return element2;
    }

    public static void readConfigurations(@NotNull Element element, @NotNull Collection<? super Configuration> configurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(12);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(13);
        }
        ConfigurationManager.readConfigurations(element, configurations, (Collection<? super Configuration>)new SmartList());
    }

    private static void readConfigurations(@NotNull Element element, @NotNull Collection<? super Configuration> configurations, @NotNull Collection<? super Configuration> historyConfigurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(14);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(15);
        }
        if (historyConfigurations == null) {
            ConfigurationManager.$$$reportNull$$$0(16);
        }
        for (Element pattern : element.getChildren()) {
            Configuration config = ConfigurationManager.readConfiguration(pattern);
            if (config == null) continue;
            if (pattern.getAttribute(SAVE_HISTORY_ATTR_NAME) != null) {
                historyConfigurations.add(config);
                continue;
            }
            configurations.add(config);
        }
    }

    private static Configuration readConfiguration(@NotNull Element element) {
        Configuration config;
        String name;
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(17);
        }
        if ((name = element.getName()).equals(SEARCH_TAG_NAME)) {
            config = new SearchConfiguration();
        } else if (name.equals(REPLACE_TAG_NAME)) {
            config = new ReplaceConfiguration();
        } else {
            return null;
        }
        ((Configuration)config).readExternal(element);
        return config;
    }

    public @Unmodifiable List<String> getAllConfigurationNames() {
        return ContainerUtil.map(this.getAllConfigurations(), c -> c.getRefName());
    }

    public @Unmodifiable List<Configuration> getAllConfigurations() {
        return ContainerUtil.concat((List[])new List[]{StructuralSearchUtil.getPredefinedTemplates(), this.getIdeConfigurations(), this.getProjectConfigurations()});
    }

    @NotNull
    public List<Configuration> getIdeConfigurations() {
        List<Configuration> list2 = this.myIdeState.getAll();
        if (list2 == null) {
            ConfigurationManager.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public List<Configuration> getProjectConfigurations() {
        List<Configuration> list2 = this.myProjectState.getAll();
        if (list2 == null) {
            ConfigurationManager.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @Nullable
    public Configuration findConfigurationByName(String name) {
        Configuration projectConfiguration = this.myProjectState.get(name);
        if (projectConfiguration != null) {
            return projectConfiguration;
        }
        Configuration ideConfiguration = this.myIdeState.get(name);
        if (ideConfiguration != null) {
            return ideConfiguration;
        }
        return (Configuration)ContainerUtil.find(StructuralSearchUtil.getPredefinedTemplates(), config -> config.getRefName().equals(name));
    }

    @Nullable
    private static Configuration findConfiguration(@NotNull Collection<? extends Configuration> configurations, Configuration configuration) {
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(20);
        }
        return (Configuration)ContainerUtil.find(configurations, c -> {
            if (configuration instanceof ReplaceConfiguration) {
                return c instanceof ReplaceConfiguration && c.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern()) && c.getReplaceOptions().getReplacement().equals(configuration.getReplaceOptions().getReplacement());
            }
            return c instanceof SearchConfiguration && c.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern());
        });
    }

    @NotNull
    public List<Configuration> getHistoryConfigurations() {
        for (Configuration configuration : this.historyConfigurations) {
            configuration.getMatchOptions().initScope(this.myProject);
        }
        List<Configuration> list2 = Collections.unmodifiableList(this.historyConfigurations);
        if (list2 == null) {
            ConfigurationManager.$$$reportNull$$$0(21);
        }
        return list2;
    }

    public boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration) {
        int answer;
        if (newConfiguration == null) {
            ConfigurationManager.$$$reportNull$$$0(22);
        }
        Pair<@NlsSafe String, Boolean> nameAndProject = this.showInputDialog(newConfiguration.getName());
        while (nameAndProject.first != null && ((Boolean)nameAndProject.second != false ? this.myProjectState : this.myIdeState).get((String)nameAndProject.first) != null && (answer = Messages.showYesNoDialog((Project)this.myProject, (String)SSRBundle.message("overwrite.message", new Object[0]), (String)SSRBundle.message("overwrite.title", nameAndProject.first), (String)SSRBundle.message("button.replace", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon())) != 0) {
            nameAndProject = this.showInputDialog((String)nameAndProject.first);
        }
        if (nameAndProject.first != null) {
            newConfiguration.setName((String)nameAndProject.first);
            newConfiguration.setUuid(null);
            this.myLastSaveWasInProject = (Boolean)nameAndProject.second;
            ((Boolean)nameAndProject.second != false ? this.myProjectState : this.myIdeState).add(newConfiguration.copy());
            return true;
        }
        return false;
    }

    private @NotNull Pair<@Nullable @NlsSafe String, Boolean> showInputDialog(@NotNull String initial) {
        if (initial == null) {
            ConfigurationManager.$$$reportNull$$$0(23);
        }
        Pair pair = Messages.showInputDialogWithCheckBox((String)SSRBundle.message("template.name.label", new Object[0]), (String)SSRBundle.message("save.template.title", new Object[0]), (String)SSRBundle.message("checkbox.save.in.project", new Object[0]), (boolean)this.myLastSaveWasInProject, (boolean)true, (Icon)Messages.getQuestionIcon(), (String)initial, null);
        if (pair == null) {
            ConfigurationManager.$$$reportNull$$$0(24);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 18, 19, 21, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyConfigurations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfiguration";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "saveConfiguration";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeConfigurations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurations";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryConfigurations";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "showInputDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeConfigurations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveConfiguration";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readConfiguration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showSaveTemplateAsDialog";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showInputDialog";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11, 18, 19, 21, 24 -> new IllegalStateException(string2);
        };
    }

    @State(name="StructuralSearch", storages={@Storage(value="structuralSearch.xml")}, category=SettingsCategory.CODE)
    private static final class ConfigurationManagerState
    extends AbstractConfigurationManagerState {
        private ConfigurationManagerState() {
        }

        public static ConfigurationManagerState getInstance() {
            return (ConfigurationManagerState)ApplicationManager.getApplication().getService(ConfigurationManagerState.class);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @State(name="StructuralSearch", storages={@Storage(value="structuralSearch.xml")}, category=SettingsCategory.CODE)
    private static final class ProjectConfigurationManagerState
    extends AbstractConfigurationManagerState {
        private ProjectConfigurationManagerState() {
        }

        public static ProjectConfigurationManagerState getInstance(Project project2) {
            return (ProjectConfigurationManagerState)project2.getService(ProjectConfigurationManagerState.class);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class AbstractConfigurationManagerState
    implements PersistentStateComponent<Element> {
        public final Map<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();

        private AbstractConfigurationManagerState() {
        }

        public void add(Configuration configuration) {
            configuration.getMatchOptions().setScope(null);
            this.configurations.put(configuration.getRefName(), configuration);
        }

        public Configuration get(String name) {
            return this.configurations.get(name);
        }

        public void remove(String name) {
            this.configurations.remove(name);
        }

        public List<Configuration> getAll() {
            return new ArrayList<Configuration>(this.configurations.values());
        }

        @Nullable
        public Element getState() {
            Element element = new Element("state");
            for (Configuration configuration : this.configurations.values()) {
                ConfigurationManager.saveConfiguration(element, configuration);
            }
            return element;
        }

        public void loadState(@NotNull Element state) {
            if (state == null) {
                AbstractConfigurationManagerState.$$$reportNull$$$0(0);
            }
            for (Element child : state.getChildren()) {
                Configuration configuration = ConfigurationManager.readConfiguration(child);
                if (configuration == null) continue;
                this.configurations.put(configuration.getRefName(), configuration);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager$AbstractConfigurationManagerState", "loadState"));
        }
    }
}

