/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.utils.measurements;

import com.intellij.rml.dfa.utils.measurements.CustomResultHolder;
import com.intellij.rml.dfa.utils.measurements.CustomResultHolderImpl;
import com.intellij.rml.dfa.utils.measurements.DfaAggregatedMeasurementResult;
import com.intellij.rml.dfa.utils.measurements.DfaAggregationMeasurement;
import com.intellij.rml.dfa.utils.measurements.DfaBenchmarkMeasurement;
import com.intellij.rml.dfa.utils.measurements.DfaSingleMeasurementResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\u001e\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J(\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u001e0\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaAggregationMeasurement;", "Lcom/intellij/rml/dfa/utils/measurements/DfaBenchmarkMeasurement;", "warmupTimes", "", "roundTimes", "columns", "", "", "computeAverageDeviation", "", "block", "Lkotlin/Function1;", "Lcom/intellij/rml/dfa/utils/measurements/CustomResultHolder;", "", "<init>", "(IILjava/util/List;ZLkotlin/jvm/functions/Function1;)V", "run", "", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementID;", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult;", "verbose", "performRound", "checkColumns", "holder", "Lcom/intellij/rml/dfa/utils/measurements/CustomResultHolderImpl;", "printColumns", "printValues", "values", "prefix", "getColumnSizes", "Lkotlin/Pair;", "columnNames", "leftPadding", "columnMinLength", "Companion", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nDfaAggregationMeasurement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaAggregationMeasurement.kt\ncom/intellij/rml/dfa/utils/measurements/DfaAggregationMeasurement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,123:1\n1863#2,2:124\n1863#2:126\n1863#2:127\n1864#2:135\n1864#2:136\n1557#2:137\n1628#2,3:138\n1557#2:141\n1628#2,3:142\n1557#2:145\n1628#2,3:146\n1557#2:149\n1628#2,3:150\n1557#2:153\n1628#2,3:154\n381#3,7:128\n*S KotlinDebug\n*F\n+ 1 DfaAggregationMeasurement.kt\ncom/intellij/rml/dfa/utils/measurements/DfaAggregationMeasurement\n*L\n37#1:124,2\n41#1:126\n45#1:127\n45#1:135\n41#1:136\n50#1:137\n50#1:138,3\n60#1:141\n60#1:142,3\n74#1:145\n74#1:146,3\n93#1:149\n93#1:150,3\n101#1:153\n101#1:154,3\n46#1:128,7\n*E\n"})
public final class DfaAggregationMeasurement
implements DfaBenchmarkMeasurement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int warmupTimes;
    private final int roundTimes;
    @Nullable
    private List<String> columns;
    private final boolean computeAverageDeviation;
    @NotNull
    private final Function1<CustomResultHolder, Unit> block;
    private final int leftPadding;
    private final int columnMinLength;

    public DfaAggregationMeasurement(int warmupTimes, int roundTimes, @Nullable List<String> columns, boolean computeAverageDeviation, @NotNull Function1<? super CustomResultHolder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.warmupTimes = warmupTimes;
        this.roundTimes = roundTimes;
        this.columns = columns;
        this.computeAverageDeviation = computeAverageDeviation;
        this.block = block;
        this.leftPadding = 15;
        this.columnMinLength = 15;
    }

    public /* synthetic */ DfaAggregationMeasurement(int n, int n2, List list2, boolean bl, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            list2 = null;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(n, n2, list2, bl, (Function1<? super CustomResultHolder, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, DfaSingleMeasurementResult> run(boolean verbose) {
        Map map;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object object;
        Object values;
        int iter;
        int element$iv;
        Map results = new LinkedHashMap();
        if (this.columns != null) {
            this.printColumns();
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.warmupTimes);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            iter = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            values = this.performRound();
            this.printValues((List<? extends DfaSingleMeasurementResult>)values, "warmup [" + (iter + 1) + "/" + this.warmupTimes + "]");
        }
        $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.roundTimes);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            iter = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            values = this.performRound();
            this.printValues((List<? extends DfaSingleMeasurementResult>)values, "round [" + (iter + 1) + "/" + this.roundTimes + "]");
            List<String> list2 = this.columns;
            Intrinsics.checkNotNull(list2);
            Iterable $this$forEach$iv2 = CollectionsKt.zip((Iterable)list2, (Iterable)((Iterable)values));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object2;
                object = (Pair)element$iv2;
                boolean bl2 = false;
                String id = (String)object.component1();
                DfaSingleMeasurementResult value = (DfaSingleMeasurementResult)object.component2();
                Map $this$getOrPut$iv = results;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(id);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(id, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(value);
            }
        }
        List<String> list3 = this.columns;
        Intrinsics.checkNotNull(list3);
        Iterable $this$map$iv = list3;
        boolean $i$f$map = false;
        Iterable element$iv3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void id;
            String $i$f$forEach2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object v = results.get(id);
            Intrinsics.checkNotNull(v);
            List resultColumn = (List)v;
            if (!(resultColumn.size() == this.roundTimes)) {
                throw new IllegalStateException("Check failed.");
            }
            object = DfaAggregatedMeasurementResult.Companion.aggregate(resultColumn);
            DfaSingleMeasurementResult mean = ((DfaAggregatedMeasurementResult)object).component1();
            DfaSingleMeasurementResult avgDev = ((DfaAggregatedMeasurementResult)object).component2();
            collection.add(TuplesKt.to((Object)mean, (Object)avgDev));
        }
        Pair pair = CollectionsKt.unzip((Iterable)((List)destination$iv$iv));
        List means = (List)pair.component1();
        List avgDevs = (List)pair.component2();
        this.printValues(means, "mean");
        this.printValues(avgDevs, "avg-dev");
        if (this.computeAverageDeviation) {
            void $this$mapTo$iv$iv2;
            List<String> list4 = this.columns;
            Intrinsics.checkNotNull(list4);
            Iterable $this$map$iv2 = list4;
            boolean $i$f$map2 = false;
            values = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                object = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(Companion.avgDivColumn((String)it));
            }
            map = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv2), (Iterable)avgDevs));
        } else {
            map = MapsKt.emptyMap();
        }
        Map avgDivResult = map;
        List<String> list5 = this.columns;
        Intrinsics.checkNotNull(list5);
        return MapsKt.plus((Map)MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)list5, (Iterable)means)), (Map)avgDivResult);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DfaSingleMeasurementResult> performRound() {
        void $this$mapTo$iv$iv;
        CustomResultHolderImpl holder = new CustomResultHolderImpl();
        this.block.invoke((Object)holder);
        this.checkColumns(holder);
        if (this.columns == null) {
            this.columns = CollectionsKt.toList((Iterable)holder.getAllInfos().keySet());
            this.printColumns();
        }
        List<String> list2 = this.columns;
        Intrinsics.checkNotNull(list2);
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void id;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(holder.getInfo((String)id));
        }
        return (List)destination$iv$iv;
    }

    private final void checkColumns(CustomResultHolderImpl holder) {
        if (this.columns != null) {
            Set<String> actual = holder.getAllInfos().keySet();
            List<String> list2 = this.columns;
            Intrinsics.checkNotNull(list2);
            List<String> expect = list2;
            if (!((Collection)CollectionsKt.minus((Iterable)expect, (Iterable)actual)).isEmpty()) {
                System.err.println("DfaAggregationMeasurement: column(s) " + CollectionsKt.minus((Iterable)expect, (Iterable)actual) + " are missed");
            }
        }
    }

    private final void printColumns() {
        List<String> list2 = this.columns;
        Intrinsics.checkNotNull(list2);
        String header2 = CollectionsKt.joinToString$default((Iterable)this.getColumnSizes(list2), (CharSequence)"", null, null, (int)0, null, (Function1)printColumns.header.1.INSTANCE, (int)30, null);
        System.out.println((Object)(StringsKt.repeat((CharSequence)" ", (int)this.leftPadding) + header2));
    }

    /*
     * WARNING - void declaration
     */
    private final void printValues(List<? extends DfaSingleMeasurementResult> values, String prefix) {
        void $this$mapTo$iv$iv;
        List<String> list2 = this.columns;
        Intrinsics.checkNotNull(list2);
        Iterable $this$map$iv = this.getColumnSizes(list2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getSecond()).intValue());
        }
        List columnSizes = (List)destination$iv$iv;
        String raw2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.zip((Iterable)columnSizes, (Iterable)values), (CharSequence)"", null, null, (int)0, null, (Function1)printValues.raw.1.INSTANCE, (int)30, null);
        System.out.println((Object)(StringsKt.padStart$default((String)prefix, (int)this.leftPadding, (char)'\u0000', (int)2, null) + raw2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, Integer>> getColumnSizes(List<String> columnNames) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = columnNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)Math.max(it.length() + 5, this.columnMinLength)));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/rml/dfa/utils/measurements/DfaAggregationMeasurement$Companion;", "", "<init>", "()V", "avgDivColumn", "", "column", "isAvgDevColumn", "", "intellij.rml.dfa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String avgDivColumn(@NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            return column + "$dev";
        }

        public final boolean isAvgDevColumn(@NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            return StringsKt.endsWith$default((String)column, (String)"$dev", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

