/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeValueManipulator
extends AbstractElementManipulator<XmlAttributeValue> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeValueManipulator.class);

    public XmlAttributeValue handleContentChange(@NotNull XmlAttributeValue element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String text2;
        if (element == null) {
            XmlAttributeValueManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            XmlAttributeValueManipulator.$$$reportNull$$$0(1);
        }
        CheckUtil.checkWritable((PsiElement)element);
        String oldText = element.getText();
        try {
            String textBeforeRange = oldText.substring(0, range.getStartOffset());
            String textAfterRange = oldText.substring(range.getEndOffset());
            newContent = oldText.startsWith("'") || oldText.endsWith("'") ? newContent.replace("'", oldText.contains("&#39;") ? "&#39;" : "&apos;") : newContent.replace("\"", oldText.contains("&#34;") ? "&#34;" : "&quot;");
            text2 = "<a value=" + textBeforeRange + newContent + textAfterRange;
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Range: " + String.valueOf(range) + " in text: '" + oldText + "'", (Throwable)e);
            throw e;
        }
        Project project2 = element.getProject();
        XmlTag tag = element.getParent().getParent() instanceof HtmlTag ? XmlElementFactory.getInstance(project2).createHTMLTagFromText(text2) : XmlElementFactory.getInstance(project2).createTagFromText(text2);
        XmlAttribute attribute = tag.getAttribute("value");
        assert (attribute != null && attribute.getValueElement() != null);
        element.getNode().replaceAllChildrenToChildrenOf(attribute.getValueElement().getNode());
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttributeValue xmlAttributeValue) {
        PsiElement first;
        if (xmlAttributeValue == null) {
            XmlAttributeValueManipulator.$$$reportNull$$$0(2);
        }
        if ((first = xmlAttributeValue.getFirstChild()) == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                XmlAttributeValueManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        ASTNode firstNode = first.getNode();
        assert (firstNode != null);
        PsiElement last = xmlAttributeValue.getLastChild();
        ASTNode lastNode = last != null && last != first ? last.getNode() : null;
        int textLength = xmlAttributeValue.getTextLength();
        int start2 = firstNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER ? first.getTextLength() : 0;
        int end = lastNode != null && lastNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? last.getTextLength() : 0;
        return new TextRange(start2, textLength - end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttributeValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

