/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.whatsNew.reaction;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.platform.whatsNew.reaction.ReactionChecker;
import com.intellij.platform.whatsNew.reaction.ReactionsPanel;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u00012\u00020\u0002B,\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/whatsNew/reaction/ReactionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "text", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "icon", "Ljavax/swing/Icon;", "hoveredIcon", "selectedIcon", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "getHoveredIcon", "getSelectedIcon", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "getReactionStateChecker", "Lcom/intellij/platform/whatsNew/reaction/ReactionChecker;", "intellij.platform.whatsNew"})
abstract class ReactionAction
extends AnAction
implements DumbAware {
    @NotNull
    private final Icon icon;
    @NotNull
    private final Icon hoveredIcon;
    @NotNull
    private final Icon selectedIcon;

    public ReactionAction(@NotNull String text2, @NotNull Icon icon, @NotNull Icon hoveredIcon, @NotNull Icon selectedIcon) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)hoveredIcon, (String)"hoveredIcon");
        Intrinsics.checkNotNullParameter((Object)selectedIcon, (String)"selectedIcon");
        super(text2, null, icon);
        this.icon = icon;
        this.hoveredIcon = hoveredIcon;
        this.selectedIcon = selectedIcon;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final Icon getHoveredIcon() {
        return this.hoveredIcon;
    }

    @NotNull
    public final Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean selected = this.isSelected(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setIcon(selected ? this.selectedIcon : this.icon);
        presentation2.setHoveredIcon(selected ? this.selectedIcon : this.hoveredIcon);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public abstract boolean isSelected(@NotNull AnActionEvent var1);

    @Nullable
    public final ReactionChecker getReactionStateChecker(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return (ReactionChecker)e.getDataContext().getData(ReactionsPanel.STATE_CHECKER_KEY);
    }
}

