/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.whatsNew;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.whatsNew.WhatsNewContent;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/platform/whatsNew/WhatsNewContentVersionChecker;", "", "<init>", "()V", "Companion", "intellij.platform.whatsNew"})
@SourceDebugExtension(value={"SMAP\nWhatsNewContentVersionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhatsNewContentVersionChecker.kt\ncom/intellij/platform/whatsNew/WhatsNewContentVersionChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n15#2:67\n*S KotlinDebug\n*F\n+ 1 WhatsNewContentVersionChecker.kt\ncom/intellij/platform/whatsNew/WhatsNewContentVersionChecker\n*L\n10#1:67\n*E\n"})
public final class WhatsNewContentVersionChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String LAST_SHOWN_EAP_VERSION_PROP = "whats.new.last.shown.version";

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WhatsNewContentVersionChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u001d\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/whatsNew/WhatsNewContentVersionChecker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LAST_SHOWN_EAP_VERSION_PROP", "", "isNeedToShowContent", "", "whatsNewContent", "Lcom/intellij/platform/whatsNew/WhatsNewContent;", "saveLastShownContent", "", "content", "shouldShowWhatsNew", "storedVersion", "Lcom/intellij/platform/whatsNew/WhatsNewContent$ContentVersion;", "newVersion", "shouldShowWhatsNew$intellij_platform_whatsNew", "intellij.platform.whatsNew"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isNeedToShowContent(@NotNull WhatsNewContent whatsNewContent) {
            Intrinsics.checkNotNullParameter((Object)whatsNewContent, (String)"whatsNewContent");
            WhatsNewContent.ContentVersion contentVersion = whatsNewContent.getVersion();
            if (contentVersion == null) {
                Companion $this$isNeedToShowContent_u24lambda_u240 = this;
                boolean bl = false;
                LOG.info("What's New content provider returns null version. What's New will be ignored.");
                return false;
            }
            WhatsNewContent.ContentVersion newVersion = contentVersion;
            String string2 = PropertiesComponent.getInstance().getValue(WhatsNewContentVersionChecker.LAST_SHOWN_EAP_VERSION_PROP);
            if (string2 == null) {
                Companion $this$isNeedToShowContent_u24lambda_u241 = this;
                boolean bl = false;
                LOG.info("whats.new.last.shown.version is not defined. Will show What's New.");
                return true;
            }
            String savedVersionInfo = string2;
            WhatsNewContent.ContentVersion contentVersion2 = WhatsNewContent.ContentVersion.Companion.parse(savedVersionInfo);
            if (contentVersion2 == null) {
                Companion $this$isNeedToShowContent_u24lambda_u242 = this;
                boolean bl = false;
                LOG.warn("Cannot parse last shown What's New version: \"" + savedVersionInfo + "\". Will show What's new as fallback.");
                return true;
            }
            WhatsNewContent.ContentVersion savedVersion = contentVersion2;
            boolean result2 = this.shouldShowWhatsNew$intellij_platform_whatsNew(savedVersion, newVersion);
            LOG.info("Comparing versions " + newVersion + " and " + savedVersion + ": " + result2 + ".");
            return result2;
        }

        public final void saveLastShownContent(@NotNull WhatsNewContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            LOG.info("EapWhatsNew version saved '" + content.getVersion() + "'");
            WhatsNewContent.ContentVersion contentVersion = content.getVersion();
            if (contentVersion == null) {
                Companion $this$saveLastShownContent_u24lambda_u243 = this;
                boolean bl = false;
                LOG.error("What's New content " + content + " returned a null version.");
                return;
            }
            WhatsNewContent.ContentVersion version = contentVersion;
            PropertiesComponent.getInstance().setValue(WhatsNewContentVersionChecker.LAST_SHOWN_EAP_VERSION_PROP, version.toString());
        }

        public final boolean shouldShowWhatsNew$intellij_platform_whatsNew(@NotNull WhatsNewContent.ContentVersion storedVersion, @NotNull WhatsNewContent.ContentVersion newVersion) {
            Intrinsics.checkNotNullParameter((Object)storedVersion, (String)"storedVersion");
            Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
            if (storedVersion.getEap() == null && newVersion.getEap() == null) {
                if (StringKt.nullize$default((String)storedVersion.getHash(), (boolean)false, (int)1, null) == null || StringKt.nullize$default((String)newVersion.getHash(), (boolean)false, (int)1, null) == null) {
                    return newVersion.compareTo(storedVersion) > 0;
                }
                return newVersion.compareTo(storedVersion) > 0 && !Intrinsics.areEqual((Object)storedVersion.getHash(), (Object)newVersion.getHash());
            }
            if (StringKt.nullize$default((String)storedVersion.getHash(), (boolean)false, (int)1, null) != null && StringKt.nullize$default((String)newVersion.getHash(), (boolean)false, (int)1, null) != null) {
                return !Intrinsics.areEqual((Object)storedVersion.getHash(), (Object)newVersion.getHash()) && newVersion.compareTo(storedVersion) >= 0;
            }
            return newVersion.compareTo(storedVersion) > 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

