/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileBasedCodeFragmentType
implements CodeFragmentType {
    private final VirtualFile myFile;
    private final Project myProject;

    public FileBasedCodeFragmentType(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(1);
        }
        this.myFile = file;
        this.myProject = project2;
    }

    @Override
    public CompositeAppearance getTitle(boolean selected) {
        CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
        ending.addText(this.myFile.getName(), BasicTreeNode.getTextAttributes(selected));
        VirtualFile parent = this.myFile.getParent();
        ending.addComment(FileBasedCodeFragmentType.getPresentablePath(parent, this.myProject), BasicTreeNode.getCommentAttributes(selected));
        return ending.getAppearance();
    }

    @NotNull
    @NlsSafe
    private static String getPresentablePath(@NotNull VirtualFile file, @NotNull Project project2) {
        ProjectRootManager projectRootManager;
        int contentRootCount;
        if (file == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(3);
        }
        if ((contentRootCount = (projectRootManager = ProjectRootManager.getInstance((Project)project2)).getContentRoots().length) == 0) {
            String string2 = file.getPath();
            if (string2 == null) {
                FileBasedCodeFragmentType.$$$reportNull$$$0(4);
            }
            return string2;
        }
        VirtualFile contentRoot = projectRootManager.getFileIndex().getContentRootForFile(file);
        if (contentRoot == null) {
            String string3 = file.getPath();
            if (string3 == null) {
                FileBasedCodeFragmentType.$$$reportNull$$$0(5);
            }
            return string3;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
        if (relativePath == null) {
            String string4 = file.getPath();
            if (string4 == null) {
                FileBasedCodeFragmentType.$$$reportNull$$$0(6);
            }
            return string4;
        }
        String presentableRelativePath = contentRootCount == 1 ? relativePath : contentRoot.getName() + "/" + relativePath;
        String string5 = FileUtil.toSystemDependentName((String)(".../" + presentableRelativePath));
        if (string5 == null) {
            FileBasedCodeFragmentType.$$$reportNull$$$0(7);
        }
        return string5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/resultUI/FileBasedCodeFragmentType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6, 7 -> new IllegalStateException(string2);
        };
    }
}

