/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.ExternalIntegerKeyDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DuplicatesIndex.class);
    private static final int MAX_COST = 7000;
    private final PersistentHashMap<Integer, List<MyEntry>> myPersistentHashMap;
    private final DuplicatesProfile[] myProfiles;
    @NotNull
    private final Project myProject;

    public DuplicatesIndex(@NotNull Project project2, DuplicatesProfile @NotNull [] profiles2) throws IOException {
        if (project2 == null) {
            DuplicatesIndex.$$$reportNull$$$0(0);
        }
        if (profiles2 == null) {
            DuplicatesIndex.$$$reportNull$$$0(1);
        }
        this.myProfiles = profiles2;
        this.myProject = project2;
        File mapFile = ProjectUtil.getProjectCachePath((Project)project2, (String)"duplicates").toFile();
        IOUtil.deleteAllFilesStartingWith((File)mapFile);
        this.myPersistentHashMap = new PersistentHashMap(mapFile.toPath(), (KeyDescriptor)ExternalIntegerKeyDescriptor.INSTANCE, (DataExternalizer)new MyDataExternalizer());
        this.myPersistentHashMap.force();
    }

    public void dispose() {
        try {
            this.myPersistentHashMap.closeAndClean();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(@NotNull AnalysisScope scope) {
        if (scope == null) {
            DuplicatesIndex.$$$reportNull$$$0(2);
        }
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        final int totalFiles = scope.getFileCount();
        if (indicator != null) {
            indicator.setText(DupLocatorBundle.message("duplicates.indexing.progress", new Object[0]));
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            private int myFileCount = 0;

            public void visitFile(@NotNull PsiFile baseFile) {
                if (baseFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project2 = baseFile.getProject();
                ++this.myFileCount;
                if (indicator != null) {
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile != null) {
                        String url = virtualFile.getPresentableUrl();
                        String path = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)url, (Project)project2, (boolean)true, (boolean)false);
                        indicator.setText2(path);
                    }
                    indicator.setFraction((double)this.myFileCount / (double)totalFiles);
                }
                Int2ObjectMap<Set<MyEntry>> map = DuplicatesIndex.this.collectHashEntries(project2, baseFile);
                IntIterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    int hash2 = iterator.nextInt();
                    Set newEntries = (Set)map.get(hash2);
                    try {
                        ArrayList entries2 = (ArrayList)DuplicatesIndex.this.myPersistentHashMap.get((Object)hash2);
                        if (entries2 == null) {
                            entries2 = new ArrayList();
                        }
                        entries2.addAll(newEntries);
                        DuplicatesIndex.this.myPersistentHashMap.put((Object)hash2, new ArrayList(entries2));
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplicatesIndex$1", "visitFile"));
            }
        });
    }

    private Int2ObjectMap<Set<MyEntry>> collectHashEntries(Project project2, PsiFile baseFile) {
        try {
            VirtualFile vFile = baseFile.getVirtualFile();
            if (vFile == null) {
                return Int2ObjectMaps.emptyMap();
            }
            MyIndexingFragmentsCollector collector = new MyIndexingFragmentsCollector();
            DuplocateVisitor[] visitors = DuplicatesIndex.createVisitors(this.myProfiles, collector);
            for (PsiFile file : baseFile.getViewProvider().getAllFiles()) {
                for (DuplocateVisitor visitor2 : visitors) {
                    visitor2.visitNode((PsiElement)file);
                }
                InjectedLanguageManager.getInstance((Project)project2).dropFileCaches(file);
            }
            return collector.getResult();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
            return Int2ObjectMaps.emptyMap();
        }
    }

    public void processAll(@NotNull AnalysisScope scope, @NotNull FragmentsCollector collector) {
        if (scope == null) {
            DuplicatesIndex.$$$reportNull$$$0(3);
        }
        if (collector == null) {
            DuplicatesIndex.$$$reportNull$$$0(4);
        }
        try {
            IntArrayList hashes = new IntArrayList();
            this.myPersistentHashMap.processKeys(arg_0 -> DuplicatesIndex.lambda$processAll$0((IntList)hashes, arg_0));
            final Map<VirtualFile, Map<Language, IntSet>> map = this.getMap((IntList)hashes);
            final DuplocateVisitor[] visitors = DuplicatesIndex.createVisitors(this.myProfiles, new MyProcessingFragmentsCollector(map, collector));
            final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(DupLocatorBundle.message("duplicates.searching.progress", new Object[0]));
            }
            final int totalFiles = map.size();
            final Set<VirtualFile> fileSet = map.keySet();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
                private int myIndex = 0;

                public void visitFile(@NotNull PsiFile baseFile) {
                    if (baseFile == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!baseFile.isValid()) {
                        return;
                    }
                    VirtualFile vFile = baseFile.getVirtualFile();
                    if (vFile == null || !fileSet.contains(vFile)) {
                        return;
                    }
                    if (indicator != null) {
                        String url = vFile.getPresentableUrl();
                        String path = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)vFile, (String)url, (Project)DuplicatesIndex.this.myProject, (boolean)true, (boolean)false);
                        indicator.setText2(path);
                        indicator.setFraction((double)this.myIndex / (double)totalFiles);
                    }
                    ++this.myIndex;
                    for (Language language : ((Map)map.get(vFile)).keySet()) {
                        PsiFile file = baseFile.getViewProvider().getPsi(language);
                        if (file == null || !file.isValid()) continue;
                        for (DuplocateVisitor visitor2 : visitors) {
                            visitor2.visitNode((PsiElement)file);
                        }
                        InjectedLanguageManager.getInstance((Project)DuplicatesIndex.this.myProject).dropFileCaches(file);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplicatesIndex$2", "visitFile"));
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static IntSet getFragmentsSet(@NotNull Map<VirtualFile, Map<Language, IntSet>> map, @NotNull PsiFragment fragment) {
        Map<Language, IntSet> language2ranges;
        VirtualFile vFile;
        PsiFile file;
        Language language;
        if (map == null) {
            DuplicatesIndex.$$$reportNull$$$0(5);
        }
        if (fragment == null) {
            DuplicatesIndex.$$$reportNull$$$0(6);
        }
        if ((language = fragment.getLanguage()) != null && (file = fragment.getFile()) != null && (vFile = file.getVirtualFile()) != null && (language2ranges = map.get(vFile)) != null) {
            return language2ranges.get(language);
        }
        return null;
    }

    private Map<VirtualFile, Map<Language, IntSet>> getMap(@NotNull IntList hashes) throws IOException {
        if (hashes == null) {
            DuplicatesIndex.$$$reportNull$$$0(7);
        }
        Map result2 = CollectionFactory.createSmallMemoryFootprintMap();
        int n = hashes.size();
        for (int i = 0; i < n; ++i) {
            int hash2 = hashes.getInt(i);
            List entries2 = (List)this.myPersistentHashMap.get((Object)hash2);
            if (entries2.size() < 2) continue;
            for (MyEntry entry3 : entries2) {
                IntSet rangesSet;
                VirtualFile vFile;
                Language language;
                if (entry3.getTextRanges().length == 0 || (language = Language.findLanguageByID((String)entry3.getLanguageId())) == null || (vFile = ManagingFS.getInstance().findFileById(entry3.getFileId())) == null) continue;
                Map language2ranges = (Map)result2.get(vFile);
                if (language2ranges == null) {
                    language2ranges = CollectionFactory.createSmallMemoryFootprintMap();
                    result2.put(vFile, language2ranges);
                }
                if ((rangesSet = (IntSet)language2ranges.get(language)) == null) {
                    rangesSet = new IntOpenHashSet();
                    language2ranges.put(language, rangesSet);
                }
                rangesSet.add(DuplicatesIndex.computeHash(entry3.getTextRanges()));
            }
        }
        result2.entrySet().removeIf(entry2 -> ((Map)entry2.getValue()).isEmpty());
        return result2;
    }

    private static int computeHash(TextRange @NotNull [] ranges) {
        if (ranges == null) {
            DuplicatesIndex.$$$reportNull$$$0(8);
        }
        int result2 = 0;
        for (TextRange range : ranges) {
            result2 = result2 * 31 + range.getStartOffset();
            result2 = result2 * 31 + range.getEndOffset();
        }
        return result2;
    }

    private static DuplocateVisitor[] createVisitors(DuplicatesProfile[] profiles2, FragmentsCollector collector) {
        DuplocateVisitor[] visitors = new DuplocateVisitor[profiles2.length];
        for (int i = 0; i < visitors.length; ++i) {
            visitors[i] = profiles2[i].createVisitor(collector);
        }
        return visitors;
    }

    private static TextRange @NotNull [] getTextRanges(@NotNull PsiFragment fragment) {
        if (fragment == null) {
            DuplicatesIndex.$$$reportNull$$$0(9);
        }
        PsiElement[] elements = fragment.getElements();
        ArrayList<TextRange> ranges = new ArrayList<TextRange>(elements.length);
        for (PsiElement element : elements) {
            ranges.add(element != null ? element.getTextRange() : TextRange.EMPTY_RANGE);
        }
        TextRange[] textRangeArray = ranges.toArray(TextRange.EMPTY_ARRAY);
        if (textRangeArray == null) {
            DuplicatesIndex.$$$reportNull$$$0(10);
        }
        return textRangeArray;
    }

    private static /* synthetic */ boolean lambda$processAll$0(IntList hashes, Integer hash2) {
        hashes.add(hash2.intValue());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentsSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextRanges";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10 -> new IllegalStateException(string2);
        };
    }

    private static class MyDataExternalizer
    implements DataExternalizer<List<MyEntry>> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<MyEntry> entryList) throws IOException {
            if (out == null) {
                MyDataExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(entryList.size());
            for (MyEntry entry2 : entryList) {
                out.writeInt(entry2.getFileId());
                out.writeUTF(entry2.getLanguageId());
                TextRange[] textRanges = entry2.getTextRanges();
                out.writeInt(textRanges.length);
                for (TextRange textRange : textRanges) {
                    if (textRange == null) {
                        out.writeInt(0);
                        out.writeInt(0);
                        continue;
                    }
                    out.writeInt(textRange.getStartOffset());
                    out.writeInt(textRange.getEndOffset());
                }
            }
        }

        public List<MyEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyDataExternalizer.$$$reportNull$$$0(1);
            }
            int entriesCount = in.readInt();
            ArrayList<MyEntry> entryList = new ArrayList<MyEntry>(entriesCount);
            for (int i = 0; i < entriesCount; ++i) {
                int fileId = in.readInt();
                String languageId = in.readUTF();
                int textRangesCount = in.readInt();
                TextRange[] textRanges = new TextRange[textRangesCount];
                for (int j = 0; j < textRangesCount; ++j) {
                    int startOffset = in.readInt();
                    int endOffset = in.readInt();
                    textRanges[j] = startOffset == -1 || endOffset == -1 ? null : new TextRange(startOffset, endOffset);
                }
                MyEntry entry2 = new MyEntry(fileId, languageId, textRanges);
                entryList.add(entry2);
            }
            return entryList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyIndexingFragmentsCollector
    implements FragmentsCollector {
        private final Int2ObjectMap<Set<MyEntry>> myMap = new Int2ObjectOpenHashMap();

        private MyIndexingFragmentsCollector() {
        }

        @NotNull
        public Int2ObjectMap<Set<MyEntry>> getResult() {
            Int2ObjectMap<Set<MyEntry>> int2ObjectMap = this.myMap;
            if (int2ObjectMap == null) {
                MyIndexingFragmentsCollector.$$$reportNull$$$0(0);
            }
            return int2ObjectMap;
        }

        @Override
        public void add(int hash2, int cost, @Nullable PsiFragment frag) {
            if (frag == null) {
                return;
            }
            PsiFile file = frag.getFile();
            if (file == null) {
                return;
            }
            VirtualFile vFile = file.getVirtualFile();
            if (vFile == null) {
                return;
            }
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            int lowerBound = duplocatorState.getLowerBound();
            if (cost < lowerBound || cost > 7000) {
                return;
            }
            TextRange[] textRanges = DuplicatesIndex.getTextRanges(frag);
            Language language = frag.getLanguage();
            if (language == null) {
                return;
            }
            HashSet<MyEntry> entrySet = (HashSet<MyEntry>)this.myMap.get(hash2);
            if (entrySet == null) {
                entrySet = new HashSet<MyEntry>();
                this.myMap.put(hash2, entrySet);
            }
            int fileId = FileBasedIndex.getFileId((VirtualFile)vFile);
            entrySet.add(new MyEntry(fileId, language.getID(), textRanges));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesIndex$MyIndexingFragmentsCollector", "getResult"));
        }
    }

    private static class MyProcessingFragmentsCollector
    implements FragmentsCollector {
        private final Map<VirtualFile, Map<Language, IntSet>> myMap;
        private final FragmentsCollector myCollector;

        MyProcessingFragmentsCollector(Map<VirtualFile, Map<Language, IntSet>> map, FragmentsCollector collector) {
            this.myMap = map;
            this.myCollector = collector;
        }

        @Override
        public void add(int hash2, int cost, @Nullable PsiFragment frag) {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            if (cost < duplocatorState.getLowerBound() || cost > 7000) {
                return;
            }
            IntSet rangesSet = DuplicatesIndex.getFragmentsSet(this.myMap, frag);
            if (rangesSet != null) {
                boolean shouldAdd = false;
                TextRange[] textRanges = DuplicatesIndex.getTextRanges(frag);
                int rangesHash = DuplicatesIndex.computeHash(textRanges);
                if (rangesSet.contains(rangesHash)) {
                    shouldAdd = true;
                }
                if (shouldAdd) {
                    this.myCollector.add(hash2, cost, frag);
                }
                return;
            }
            this.myCollector.add(hash2, cost, frag);
        }
    }

    private static final class MyEntry {
        private final int myFileId;
        private final String myLanguageId;
        private final TextRange[] myTextRanges;

        private MyEntry(int fileId, @NotNull String languageId, TextRange @NotNull [] textRanges) {
            if (languageId == null) {
                MyEntry.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                MyEntry.$$$reportNull$$$0(1);
            }
            this.myFileId = fileId;
            this.myLanguageId = languageId;
            this.myTextRanges = textRanges;
        }

        public int getFileId() {
            return this.myFileId;
        }

        @NotNull
        @NlsSafe
        public String getLanguageId() {
            String string2 = this.myLanguageId;
            if (string2 == null) {
                MyEntry.$$$reportNull$$$0(2);
            }
            return string2;
        }

        public TextRange @NotNull [] getTextRanges() {
            if (this.myTextRanges == null) {
                MyEntry.$$$reportNull$$$0(3);
            }
            return this.myTextRanges;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEntry myEntry = (MyEntry)o;
            if (this.myFileId != myEntry.myFileId) {
                return false;
            }
            if (!this.myLanguageId.equals(myEntry.myLanguageId)) {
                return false;
            }
            return Arrays.equals(this.myTextRanges, myEntry.myTextRanges);
        }

        public int hashCode() {
            int result2 = this.myFileId;
            result2 = 31 * result2 + this.myLanguageId.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.myTextRanges);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRanges";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

