/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.ExternallyTagSynchronizedLanguage;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.htmlInspections.RenameTagBeginOrEndIntentionAction;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.XmlTypedHandlersAdditionalSupport;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlUtil;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlTagNameSynchronizer
implements EditorFactoryListener {
    private static final Key<Boolean> SKIP_COMMAND = Key.create((String)"tag.name.synchronizer.skip.command");
    private static final Logger LOG = Logger.getInstance(XmlTagNameSynchronizer.class);
    private static final Set<Language> SUPPORTED_LANGUAGES = Set.of(HTMLLanguage.INSTANCE, XMLLanguage.INSTANCE, XHTMLLanguage.INSTANCE);
    private static final Key<TagNameSynchronizer> SYNCHRONIZER_KEY = Key.create((String)"tag_name_synchronizer");

    private XmlTagNameSynchronizer() {
    }

    private static void createSynchronizerFor(Editor editor) {
        Project project2 = editor.getProject();
        if (project2 == null || !(editor instanceof EditorImpl)) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (editor.isDisposed() || project2.isDisposed()) {
                return null;
            }
            Document document = editor.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            Language language = XmlTagNameSynchronizer.findXmlLikeLanguage(project2, file);
            if (language != null) {
                new TagNameSynchronizer((EditorImpl)editor, project2, language).listenForDocumentChanges();
            }
            return null;
        }).coalesceBy(new Object[]{Pair.create((Object)editor, XmlTagNameSynchronizer.class)}).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static void recreateSynchronizers() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            TagNameSynchronizer synchronizer = (TagNameSynchronizer)editor.getUserData(SYNCHRONIZER_KEY);
            if (synchronizer != null) {
                Disposer.dispose((Disposable)synchronizer);
            }
            XmlTagNameSynchronizer.createSynchronizerFor(editor);
        }
    }

    @NotNull
    private static Stream<TagNameSynchronizer> findSynchronizers(@Nullable Document document) {
        if (document == null || !WebEditorOptions.getInstance().isSyncTagEditing()) {
            Stream<TagNameSynchronizer> stream = Stream.empty();
            if (stream == null) {
                XmlTagNameSynchronizer.$$$reportNull$$$0(0);
            }
            return stream;
        }
        Stream<TagNameSynchronizer> stream = EditorFactory.getInstance().editors(document, null).map(editor -> (TagNameSynchronizer)editor.getUserData(SYNCHRONIZER_KEY)).filter(Objects::nonNull);
        if (stream == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(1);
        }
        return stream;
    }

    private static Language findXmlLikeLanguage(Project project2, VirtualFile file) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = file != null && file.isValid() ? PsiManager.getInstance((Project)project2).findFile(file) : null;
        if (psiFile != null) {
            for (Language language : psiFile.getViewProvider().getLanguages()) {
                if ((ContainerUtil.find(SUPPORTED_LANGUAGES, arg_0 -> ((Language)language).isKindOf(arg_0)) == null || language instanceof TemplateLanguage || language instanceof ExternallyTagSynchronizedLanguage) && !XmlTypedHandlersAdditionalSupport.supportsTypedHandlers(psiFile, language)) continue;
                return language;
            }
        }
        return null;
    }

    public static void runWithoutCancellingSyncTagsEditing(@NotNull Document document, @NotNull Runnable runnable) {
        if (document == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            XmlTagNameSynchronizer.$$$reportNull$$$0(3);
        }
        document.putUserData(SKIP_COMMAND, (Object)Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            document.putUserData(SKIP_COMMAND, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findSynchronizers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runWithoutCancellingSyncTagsEditing";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }

    private static final class TagNameSynchronizer
    implements DocumentListener,
    CaretListener,
    Disposable {
        private static final Key<Couple<RangeMarker>> MARKERS_KEY = Key.create((String)"tag.name.synchronizer.markers");
        private static final TreeSet<Segment> allMarkers = new TreeSet<Segment>(Comparator.comparingInt(Segment::getStartOffset));
        private final PsiDocumentManagerBase myDocumentManager;
        private final Language myLanguage;
        private final EditorImpl myEditor;
        private final Project myProject;
        private boolean myApplying;

        private TagNameSynchronizer(EditorImpl editor, Project project2, Language language) {
            this.myEditor = editor;
            this.myLanguage = language;
            this.myDocumentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2);
            this.myProject = project2;
        }

        public void dispose() {
            this.myEditor.putUserData(SYNCHRONIZER_KEY, null);
            allMarkers.clear();
        }

        private void listenForDocumentChanges() {
            Disposer.register((Disposable)this.myEditor.getDisposable(), (Disposable)this);
            this.myEditor.getDocument().addDocumentListener((DocumentListener)this, (Disposable)this);
            this.myEditor.getCaretModel().addCaretListener((CaretListener)this, (Disposable)this);
            this.myEditor.putUserData(SYNCHRONIZER_KEY, (Object)this);
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                Couple<RangeMarker> markers = TagNameSynchronizer.getMarkers(caret);
                if (markers == null) continue;
                allMarkers.add((Segment)markers.first);
                allMarkers.add((Segment)markers.second);
            }
        }

        public void caretRemoved(@NotNull CaretEvent event) {
            Caret caret;
            if (event == null) {
                TagNameSynchronizer.$$$reportNull$$$0(0);
            }
            if ((caret = event.getCaret()) != null) {
                TagNameSynchronizer.clearMarkers(caret);
            }
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            int caretOffset;
            Segment floor;
            if (event == null) {
                TagNameSynchronizer.$$$reportNull$$$0(1);
            }
            if (!WebEditorOptions.getInstance().isSyncTagEditing()) {
                return;
            }
            Document document = event.getDocument();
            Project project2 = Objects.requireNonNull(this.myEditor.getProject());
            if (this.myApplying || project2.isDefault() || UndoManager.getInstance((Project)project2).isUndoInProgress() || !PomModelImpl.isAllowPsiModification() || document.isInBulkUpdate()) {
                return;
            }
            int offset = event.getOffset();
            int oldLength = event.getOldLength();
            CharSequence fragment = event.getNewFragment();
            int newLength = event.getNewLength();
            if (document.getUserData(SKIP_COMMAND) == Boolean.TRUE) {
                return;
            }
            CaretImpl caret = this.myEditor.getCaretModel().getCurrentCaret();
            for (int i = 0; i < newLength; ++i) {
                if (this.isValidTagNameChar(fragment.charAt(i))) continue;
                TagNameSynchronizer.clearMarkers((Caret)caret);
                return;
            }
            Couple markers = TagNameSynchronizer.getMarkers((Caret)caret);
            if (markers != null && !TagNameSynchronizer.fitsInMarker(markers, offset, oldLength)) {
                TagNameSynchronizer.clearMarkers((Caret)caret);
                markers = null;
            }
            if ((floor = allMarkers.floor((Segment)new TextRange(caretOffset = caret.getOffset(), caretOffset))) != null && (markers == null || floor != markers.second && floor != markers.first) && caretOffset <= floor.getEndOffset()) {
                TagNameSynchronizer.clearMarkers((Caret)caret);
                return;
            }
            if (markers == null) {
                RangeMarker support;
                PsiFile file = this.myDocumentManager.getPsiFile(document);
                if (file == null || this.myDocumentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                RangeMarker leader = this.createTagNameMarker((Caret)caret);
                if (leader == null) {
                    return;
                }
                leader.setGreedyToLeft(true);
                leader.setGreedyToRight(true);
                if (this.myDocumentManager.isUncommited(document)) {
                    this.myDocumentManager.commitDocument(document);
                }
                if ((support = this.findSupport(leader, file, document)) == null) {
                    return;
                }
                support.setGreedyToLeft(true);
                support.setGreedyToRight(true);
                markers = Couple.of((Object)leader, (Object)support);
                if (!TagNameSynchronizer.fitsInMarker((Couple<RangeMarker>)markers, offset, oldLength)) {
                    return;
                }
                TagNameSynchronizer.setMarkers((Caret)caret, (Couple<RangeMarker>)markers);
            }
        }

        private static boolean fitsInMarker(Couple<RangeMarker> markers, int offset, int oldLength) {
            RangeMarker leader = (RangeMarker)markers.first;
            return leader.isValid() && offset >= leader.getStartOffset() && offset + oldLength <= leader.getEndOffset();
        }

        private static Couple<RangeMarker> getMarkers(Caret caret) {
            return (Couple)caret.getUserData(MARKERS_KEY);
        }

        private static void setMarkers(Caret caret, Couple<RangeMarker> markers) {
            caret.putUserData(MARKERS_KEY, markers);
            allMarkers.add((Segment)markers.first);
            allMarkers.add((Segment)markers.second);
        }

        private static void clearMarkers(Caret caret) {
            Couple markers = (Couple)caret.getUserData(MARKERS_KEY);
            if (markers != null) {
                allMarkers.remove(markers.first);
                allMarkers.remove(markers.second);
                ((RangeMarker)markers.first).dispose();
                ((RangeMarker)markers.second).dispose();
                caret.putUserData(MARKERS_KEY, null);
            }
        }

        private RangeMarker createTagNameMarker(Caret caret) {
            int offset = caret.getOffset();
            DocumentEx document = this.myEditor.getDocument();
            CharSequence sequence = document.getCharsSequence();
            int start2 = -1;
            boolean seenColon = false;
            for (int i = offset - 1; i >= Math.max(0, offset - 50); --i) {
                try {
                    char c = sequence.charAt(i);
                    if (c == '<' || c == '/' && i > 0 && sequence.charAt(i - 1) == '<') {
                        start2 = i + 1;
                        break;
                    }
                    if (!this.isValidTagNameChar(c)) break;
                    seenColon |= c == ':';
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("incorrect offset:" + i + ", initial: " + offset, new Attachment[]{new Attachment("document.txt", sequence.toString())});
                    return null;
                }
            }
            if (start2 < 0) {
                return null;
            }
            int end = -1;
            for (int i = offset; i < Math.min(document.getTextLength(), offset + 50); ++i) {
                char c = sequence.charAt(i);
                if (!this.isValidTagNameChar(c) || seenColon && c == ':') {
                    end = i;
                    break;
                }
                seenColon |= c == ':';
            }
            if (end < 0 || start2 > end) {
                return null;
            }
            return document.createRangeMarker(start2, end, true);
        }

        void beforeCommandFinished() {
            CaretAction action = caret -> {
                Couple<RangeMarker> markers = TagNameSynchronizer.getMarkers(caret);
                DocumentEx document = this.myEditor.getDocument();
                if (markers == null || !((RangeMarker)markers.first).isValid() || !((RangeMarker)markers.second).isValid() || TagNameSynchronizer.getNameToReplace((Document)document, markers) == null) {
                    return;
                }
                Runnable apply2 = () -> TagNameSynchronizer.lambda$beforeCommandFinished$0((Document)document, markers);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
                    if (lookup != null) {
                        lookup.performGuardedChange(apply2);
                    } else {
                        apply2.run();
                    }
                });
            };
            this.myApplying = true;
            try {
                if (this.myEditor.getCaretModel().isIteratingOverCarets()) {
                    action.perform((Caret)this.myEditor.getCaretModel().getCurrentCaret());
                } else {
                    this.myEditor.getCaretModel().runForEachCaret(action);
                }
            }
            finally {
                this.myApplying = false;
            }
        }

        @Nullable
        private static String getNameToReplace(Document document, @NotNull Couple<RangeMarker> markers) {
            if (markers == null) {
                TagNameSynchronizer.$$$reportNull$$$0(2);
            }
            RangeMarker leader = (RangeMarker)markers.first;
            RangeMarker support = (RangeMarker)markers.second;
            if (document.getTextLength() < leader.getEndOffset()) {
                return null;
            }
            String name = document.getText(leader.getTextRange());
            if (document.getTextLength() >= support.getEndOffset() && !name.equals(document.getText(support.getTextRange()))) {
                return name;
            }
            return null;
        }

        private RangeMarker findSupport(RangeMarker leader, PsiFile file, Document document) {
            int offset;
            PsiElement element;
            TextRange support;
            TextRange leaderRange = leader.getTextRange();
            if (!TagNameSynchronizer.isSupportRangeValid(document, leaderRange, support = TagNameSynchronizer.findSupportRange(element = TagNameSynchronizer.findNameElement(InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)file, (int)(offset = leader.getStartOffset()))))) && file.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
                element = TagNameSynchronizer.findNameElement(file.getViewProvider().findElementAt(offset, this.myLanguage));
                support = TagNameSynchronizer.findSupportRange(element);
            }
            if (!TagNameSynchronizer.isSupportRangeValid(document, leaderRange, support)) {
                return TagNameSynchronizer.findSupportForEmptyTag(leader, element, document);
            }
            return document.createRangeMarker(support.getStartOffset(), support.getEndOffset(), true);
        }

        private static PsiElement findNameElement(@Nullable PsiElement element) {
            return element instanceof OuterLanguageElement ? TemplateLanguageUtil.getSameLanguageTreeNext((PsiElement)element) : element;
        }

        private boolean isValidTagNameChar(char c) {
            if (XmlUtil.isValidTagNameChar(c)) {
                return true;
            }
            XmlExtension extension = this.getXmlExtension();
            if (extension == null) {
                return false;
            }
            return extension.isValidTagNameChar(c);
        }

        @Nullable
        private XmlExtension getXmlExtension() {
            PsiFile psiFile;
            DocumentEx document = this.myEditor.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile((Document)document);
            PsiFile psiFile2 = psiFile = file != null && file.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(file) : null;
            if (psiFile == null) {
                return null;
            }
            return XmlExtension.getExtension(psiFile);
        }

        private static RangeMarker findSupportForEmptyTag(RangeMarker leader, PsiElement element, Document document) {
            int nextCharPos;
            int offset = leader.getStartOffset();
            if (offset != leader.getEndOffset() || element == null || offset == 0) {
                return null;
            }
            XmlTag tag = (XmlTag)ObjectUtils.tryCast((Object)element.getParent(), XmlTag.class);
            CharSequence contents = document.getCharsSequence();
            if (tag != null && tag.getName().isEmpty()) {
                PsiElement startTag = tag.getFirstChild();
                PsiElement endTag = tag.getLastChild();
                if (endTag instanceof XmlToken && endTag.getNode().getElementType() == XmlTokenType.XML_TAG_END) {
                    endTag = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endTag);
                }
                if (startTag != endTag && startTag instanceof LeafPsiElement && endTag instanceof LeafPsiElement) {
                    int startTagOffset = startTag.getNode().getStartOffset();
                    int endTagOffset = endTag.getNode().getStartOffset();
                    if (startTagOffset + 1 == offset) {
                        return contents.charAt(endTagOffset) == '<' && contents.charAt(endTagOffset + 1) == '/' ? document.createRangeMarker(endTagOffset + 2, endTagOffset + 2, true) : null;
                    }
                    if (endTagOffset + 2 == offset) {
                        return contents.charAt(startTagOffset) == '<' ? document.createRangeMarker(startTagOffset + 1, startTagOffset + 1, true) : null;
                    }
                }
                return null;
            }
            TextRange range = (TextRange)ObjectUtils.doIfNotNull((Object)((PsiElement)ObjectUtils.doIfNotNull((Object)element.getParent(), PsiElement::getParent)), PsiElement::getTextRange);
            if (range == null) {
                return null;
            }
            int length = contents.length();
            char prev = contents.charAt(offset - 1);
            if (prev == '<') {
                int nextCharPos2 = StringUtil.skipWhitespaceForward((CharSequence)contents, (int)offset);
                if (nextCharPos2 >= 0 && nextCharPos2 < length && contents.charAt(nextCharPos2) == '>') {
                    int endTagStart;
                    int endTagEnd;
                    PsiFile file;
                    TextRange nextTagsPair;
                    int nextTagStart = StringUtil.indexOf((CharSequence)contents, (char)'<', (int)nextCharPos2, (int)range.getEndOffset());
                    char nextTagFirstChar = contents.charAt(StringUtil.skipWhitespaceForward((CharSequence)contents, (int)(nextTagStart + 1)));
                    int searchStart = nextCharPos2;
                    if (nextTagFirstChar != '/' && nextTagFirstChar != '>' && (nextTagsPair = TagNameSynchronizer.findSupportRange(TagNameSynchronizer.findNameElement(InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)(file = element.getContainingFile()), (int)nextTagStart)))) != null && nextTagsPair.getEndOffset() > nextCharPos2) {
                        searchStart = nextTagsPair.getEndOffset();
                    }
                    int n = endTagEnd = (endTagStart = StringUtil.indexOf((CharSequence)contents, (char)'<', (int)searchStart, (int)range.getEndOffset())) > 0 && endTagStart < length - 1 && contents.charAt(endTagStart + 1) == '/' ? StringUtil.skipWhitespaceForward((CharSequence)contents, (int)(endTagStart + 2)) : -1;
                    if (endTagEnd > 0 && endTagEnd < length && contents.charAt(endTagEnd) == '>') {
                        return document.createRangeMarker(endTagStart + 2, endTagStart + 2, true);
                    }
                    return document.createRangeMarker(offset, offset, true);
                }
            } else if (prev == '/' && offset >= 2 && contents.charAt(offset - 2) == '<' && (nextCharPos = StringUtil.skipWhitespaceForward((CharSequence)contents, (int)offset)) >= 0 && nextCharPos < length && contents.charAt(nextCharPos) == '>') {
                int startTagStart;
                int startTagEnd = StringUtil.lastIndexOf((CharSequence)contents, (char)'>', (int)range.getStartOffset(), (int)(offset - 2));
                int n = startTagStart = startTagEnd > 0 ? StringUtil.skipWhitespaceBackward((CharSequence)contents, (int)startTagEnd) - 1 : -1;
                if (startTagStart > 0 && startTagStart < length && contents.charAt(startTagStart) == '<') {
                    return document.createRangeMarker(startTagStart + 1, startTagStart + 1, true);
                }
                return document.createRangeMarker(offset, offset, true);
            }
            return null;
        }

        private static boolean isSupportRangeValid(@NotNull Document document, @NotNull TextRange leader, @Nullable TextRange support) {
            if (document == null) {
                TagNameSynchronizer.$$$reportNull$$$0(3);
            }
            if (leader == null) {
                TagNameSynchronizer.$$$reportNull$$$0(4);
            }
            if (support == null) {
                return false;
            }
            return document.getText(leader).equals(document.getText(support));
        }

        @Nullable
        private static TextRange findSupportRange(@Nullable PsiElement leader) {
            if (leader == null || TreeUtil.findSibling((ASTNode)leader.getNode(), (IElementType)XmlTokenType.XML_TAG_END) == null) {
                return null;
            }
            PsiElement support = RenameTagBeginOrEndIntentionAction.findOtherSide(leader, false);
            if (support == null || leader == support) {
                support = RenameTagBeginOrEndIntentionAction.findOtherSide(leader, true);
            }
            if (support == null) {
                return null;
            }
            int start2 = TagNameSynchronizer.findSupportRangeStart(support);
            int end = TagNameSynchronizer.findSupportRangeEnd(support);
            TextRange supportRange = TextRange.create((int)start2, (int)end);
            return InjectedLanguageManager.getInstance((Project)leader.getProject()).injectedToHost((PsiElement)leader.getContainingFile(), supportRange);
        }

        private static int findSupportRangeStart(@NotNull PsiElement support) {
            if (support == null) {
                TagNameSynchronizer.$$$reportNull$$$0(5);
            }
            PsiElement current = support;
            while (current.getPrevSibling() instanceof OuterLanguageElement) {
                current = current.getPrevSibling();
            }
            return current.getTextRange().getStartOffset();
        }

        private static int findSupportRangeEnd(@NotNull PsiElement support) {
            if (support == null) {
                TagNameSynchronizer.$$$reportNull$$$0(6);
            }
            PsiElement current = support;
            while (current.getNextSibling() instanceof OuterLanguageElement) {
                current = current.getNextSibling();
            }
            return current.getTextRange().getEndOffset();
        }

        private static /* synthetic */ void lambda$beforeCommandFinished$0(Document document, Couple markers) {
            String name = TagNameSynchronizer.getNameToReplace(document, (Couple<RangeMarker>)markers);
            if (name != null) {
                RangeMarker support = (RangeMarker)markers.second;
                document.replaceString(support.getStartOffset(), support.getEndOffset(), (CharSequence)name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markers";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leader";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$TagNameSynchronizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretRemoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNameToReplace";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupportRangeValid";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findSupportRangeStart";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findSupportRangeEnd";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyDynamicPluginListener
    implements DynamicPluginListener {
        public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                MyDynamicPluginListener.$$$reportNull$$$0(0);
            }
            XmlTagNameSynchronizer.recreateSynchronizers();
        }

        public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (pluginDescriptor == null) {
                MyDynamicPluginListener.$$$reportNull$$$0(1);
            }
            XmlTagNameSynchronizer.recreateSynchronizers();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "pluginDescriptor";
            objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyDynamicPluginListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginUnloaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyCommandListener
    implements CommandListener {
        MyCommandListener() {
        }

        public void beforeCommandFinished(@NotNull CommandEvent event) {
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(0);
            }
            XmlTagNameSynchronizer.findSynchronizers(event.getDocument()).forEach(synchronizer -> synchronizer.beforeCommandFinished());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyCommandListener", "beforeCommandFinished"));
        }
    }

    public static class MyEditorFactoryListener
    implements EditorFactoryListener {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                MyEditorFactoryListener.$$$reportNull$$$0(0);
            }
            ReadAction.compute(() -> {
                XmlTagNameSynchronizer.createSynchronizerFor(event.getEditor());
                return null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyEditorFactoryListener", "editorCreated"));
        }
    }
}

