/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.number;

import ai.grazie.utils.StringValueClassSerializer;
import ai.grazie.utils.mpp.MPPComparable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0007\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002$%B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0017\u0012\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0017\u0012\u0006\u0010\b\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0017\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0017\u0012\u0006\u0010\b\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\u000bJ\u0011\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0006\u0010\u001d\u001a\u00020\u001aJ\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\rH\u0086\u0002J\b\u0010!\u001a\u00020\u0010H\u0016J\u0006\u0010\"\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006&"}, d2={"Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "Lai/grazie/utils/mpp/MPPComparable;", "integer", "", "fraction", "(JJ)V", "exponent", "(JJJ)V", "value", "", "(D)V", "", "(F)V", "", "(I)V", "(J)V", "", "(Ljava/lang/String;)V", "getFraction$utils_common", "()J", "getInteger$utils_common", "asDouble", "asFloat", "compareTo", "other", "equals", "", "", "hashCode", "isZero", "minus", "plus", "times", "toString", "toStringFraction", "toStringInteger", "Companion", "Serializer", "utils-common"})
@SourceDebugExtension(value={"SMAP\nFixedPrecisionFloatTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedPrecisionFloatTest.kt\nai/grazie/utils/mpp/number/FixedPrecisionFloat\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,147:1\n142#2:148\n131#2,5:149\n*S KotlinDebug\n*F\n+ 1 FixedPrecisionFloatTest.kt\nai/grazie/utils/mpp/number/FixedPrecisionFloat\n*L\n123#1:148\n123#1:149,5\n*E\n"})
public final class FixedPrecisionFloat
implements MPPComparable<FixedPrecisionFloat> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long integer;
    private final long fraction;
    public static final long EXPONENT = 1000000000000L;
    @NotNull
    private static final FixedPrecisionFloat ZERO = new FixedPrecisionFloat(0L, 0L);

    public final long getInteger$utils_common() {
        return this.integer;
    }

    public final long getFraction$utils_common() {
        return this.fraction;
    }

    public FixedPrecisionFloat(long integer, long fraction) {
        this.integer = integer + fraction / 1000000000000L;
        this.fraction = fraction % 1000000000000L;
    }

    public FixedPrecisionFloat(long integer, long fraction, long exponent) {
        this(integer, fraction * (1000000000000L / exponent));
    }

    public FixedPrecisionFloat(double value) {
        this((long)value, (long)(value % 1.0 * (double)1000000000000L));
    }

    public FixedPrecisionFloat(float value) {
        this((long)value, (long)(value % 1.0f * (float)1000000000000L));
    }

    public FixedPrecisionFloat(int value) {
        this(value, 0L);
    }

    public FixedPrecisionFloat(long value) {
        this(value, 0L);
    }

    public FixedPrecisionFloat(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char[] cArray = new char[]{'.'};
        List list2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)value, (String)"_", (String)"", (boolean)false, (int)4, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String integer = (String)list2.get(0);
        String fraction = (String)list2.get(1);
        this.integer = Long.parseLong(integer);
        this.fraction = Long.parseLong(StringsKt.padEnd((String)fraction, (int)12, (char)'0'));
    }

    public final float asFloat() {
        return (float)this.integer + (float)this.fraction / 1.0E12f;
    }

    public final double asDouble() {
        return (double)this.integer + (double)this.fraction / 1.0E12;
    }

    @NotNull
    public final FixedPrecisionFloat plus(@NotNull FixedPrecisionFloat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long fraction = this.fraction + other.fraction;
        long integer = this.integer + other.integer + fraction / 1000000000000L;
        return new FixedPrecisionFloat(integer, fraction % 1000000000000L);
    }

    @NotNull
    public final FixedPrecisionFloat times(int other) {
        long fraction = this.fraction * (long)other % 1000000000000L;
        long integer = this.integer * (long)other + this.fraction * (long)other / 1000000000000L;
        return new FixedPrecisionFloat(integer, fraction % 1000000000000L);
    }

    @NotNull
    public final FixedPrecisionFloat minus(@NotNull FixedPrecisionFloat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long fraction = this.fraction - other.fraction;
        if (fraction >= 0L) {
            return new FixedPrecisionFloat(this.integer - other.integer, fraction);
        }
        if (fraction < 0L) {
            return new FixedPrecisionFloat(this.integer - other.integer - 1L, fraction + 1000000000000L);
        }
        long integer = this.integer - other.integer - fraction / 1000000000000L;
        return new FixedPrecisionFloat(integer, fraction % 1000000000000L);
    }

    public final boolean isZero() {
        return this.integer == 0L && this.fraction == 0L;
    }

    @Override
    public int compareTo(@NotNull FixedPrecisionFloat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.integer != other.integer) {
            return Intrinsics.compare((long)this.integer, (long)other.integer);
        }
        return Intrinsics.compare((long)this.fraction, (long)other.fraction);
    }

    @NotNull
    public final String toStringInteger() {
        return String.valueOf(this.integer);
    }

    @NotNull
    public final String toStringFraction() {
        CharSequence charSequence;
        block2: {
            String $this$trimEnd$iv = StringsKt.padStart((String)String.valueOf(this.fraction), (int)12, (char)'0');
            boolean $i$f$trimEnd = false;
            CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
            boolean $i$f$trimEnd2 = false;
            int n = $this$trimEnd$iv$iv.length() + -1;
            if (0 <= n) {
                do {
                    int index$iv$iv = n--;
                    char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (it == '0') continue;
                    charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                    break block2;
                } while (0 <= n);
            }
            charSequence = "";
        }
        return ((Object)charSequence).toString();
    }

    @NotNull
    public String toString() {
        return this.toStringInteger() + "." + this.toStringFraction();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FixedPrecisionFloat cfr_ignored_0 = (FixedPrecisionFloat)other;
        if (this.integer != ((FixedPrecisionFloat)other).integer) {
            return false;
        }
        return this.fraction == ((FixedPrecisionFloat)other).fraction;
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.integer);
        result2 = 31 * result2 + Long.hashCode(this.fraction);
        return result2;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lai/grazie/utils/mpp/number/FixedPrecisionFloat$Companion;", "", "()V", "EXPONENT", "", "ZERO", "Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "getZERO", "()Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "serializer", "Lkotlinx/serialization/KSerializer;", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FixedPrecisionFloat getZERO() {
            return ZERO;
        }

        @NotNull
        public final KSerializer<FixedPrecisionFloat> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lai/grazie/utils/mpp/number/FixedPrecisionFloat$Serializer;", "Lai/grazie/utils/StringValueClassSerializer;", "Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "()V", "utils-common"})
    public static final class Serializer
    extends StringValueClassSerializer<FixedPrecisionFloat> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super("FixedPrecisionFloat", 1.INSTANCE, 2.INSTANCE);
        }
    }
}

