/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer.rule;

import ai.grazie.Direction;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.tokenizer.NonDestructiveTokenizer;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u000e\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer;", "Lai/grazie/nlp/tokenizer/NonDestructiveTokenizer;", "pattern", "Lai/grazie/nlp/patterns/Pattern;", "direction", "Lai/grazie/Direction;", "ignore", "(Lai/grazie/nlp/patterns/Pattern;Lai/grazie/Direction;Lai/grazie/nlp/patterns/Pattern;)V", "getDirection", "()Lai/grazie/Direction;", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "isEdgeMatch", "", "text", "", "range", "Lai/grazie/text/TextRange;", "tokenRanges", "", "tokenize", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "Lai/grazie/text/Text;", "nlp-tokenizer"})
@SourceDebugExtension(value={"SMAP\nPatternSplitTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternSplitTokenizer.kt\nai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1557#2:46\n1628#2,3:47\n827#2:50\n855#2:51\n1755#2,3:52\n856#2:55\n1053#2:56\n774#2:57\n865#2,2:58\n*S KotlinDebug\n*F\n+ 1 PatternSplitTokenizer.kt\nai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer\n*L\n17#1:46\n17#1:47,3\n27#1:50\n27#1:51\n27#1:52,3\n27#1:55\n27#1:56\n39#1:57\n39#1:58,2\n*E\n"})
public final class PatternSplitTokenizer
implements NonDestructiveTokenizer {
    @NotNull
    private final Pattern pattern;
    @NotNull
    private final Direction direction;
    @Nullable
    private final Pattern ignore;

    public PatternSplitTokenizer(@NotNull Pattern pattern, @NotNull Direction direction, @Nullable Pattern ignore) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.pattern = pattern;
        this.direction = direction;
        this.ignore = ignore;
    }

    @NotNull
    public final Pattern getPattern() {
        return this.pattern;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Tokenizer.Token> tokenize(@NotNull Text text2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Iterable $this$map$iv = this.tokenRanges(text2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(text2.substring((TextRange)it), (TextRange)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> tokenRanges(@NotNull CharSequence text2) {
        void $this$filterTo$iv$iv;
        void $this$sortedBy$iv;
        Iterator $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<TextRange> rawMatches = this.pattern.find(text2);
        if (rawMatches.isEmpty() || rawMatches.size() == 1 && this.isEdgeMatch(text2, rawMatches.get(0))) {
            return text2.length() == 0 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new TextRange(0, text2.length()));
        }
        Object object = this.ignore;
        if (object == null || (object = object.find(text2)) == null) {
            object = CollectionsKt.emptyList();
        }
        List<TextRange> ignore = object;
        Iterable $this$filterNot$iv = rawMatches;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block12: {
                element$iv$iv = iterator.next();
                TextRange match2 = (TextRange)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = ignore;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TextRange it = (TextRange)element$iv;
                        boolean bl3 = false;
                        if (!it.intersects(match2)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List matches = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        });
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int start2 = 0;
        for (TextRange match3 : matches) {
            int endExclusive = switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1 -> Math.max(match3.getStart() - 1, start2);
                case 2 -> Math.max(match3.getEndExclusive(), start2);
                default -> throw new NoWhenBranchMatchedException();
            };
            ranges.add(new TextRange(start2, endExclusive));
            start2 = endExclusive;
        }
        ranges.add(new TextRange(start2, text2.length()));
        Iterable $this$filter$iv = ranges;
        boolean $i$f$filter = false;
        Iterable endExclusive = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextRange it = (TextRange)element$iv$iv;
            boolean bl = false;
            if (!it.isNotEmpty()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final boolean isEdgeMatch(CharSequence text2, TextRange range) {
        return this.direction == Direction.Right && range.getEndExclusive() == text2.length() || this.direction == Direction.Left && range.getStart() == 0;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.Left.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Right.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

