/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.langs.alphabet;

import ai.grazie.nlp.langs.alphabet.NoneAlphabet;
import ai.grazie.nlp.langs.alphabet.RegexAlphabet;
import ai.grazie.nlp.langs.alphabet.SetBasedAlphabet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet;", "", "group", "Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "(Lai/grazie/nlp/langs/alphabet/Alphabet$Group;)V", "getGroup", "()Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "matchAny", "", "input", "", "matchAnySpecial", "matchAnyUnique", "matchEntire", "Companion", "Group", "Lai/grazie/nlp/langs/alphabet/NoneAlphabet;", "Lai/grazie/nlp/langs/alphabet/RegexAlphabet;", "Lai/grazie/nlp/langs/alphabet/SetBasedAlphabet;", "nlp-langs"})
public abstract class Alphabet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Group group;
    @NotNull
    private static final Alphabet ENGLISH = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz", "", "");
    @NotNull
    private static final Alphabet FRENCH = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u0152");
    @NotNull
    private static final Alphabet GERMAN = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df", "\u00e4\u00f6\u00fc\u00df", "\u00df");
    @NotNull
    private static final Alphabet DUTCH = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00eb\u00ef\u0133", "\u00e0\u00e9\u00eb\u00ef\u0133", "\u0133");
    @NotNull
    private static final Alphabet ITALIAN = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00ec");
    @NotNull
    private static final Alphabet POLISH = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u017c\u0107\u0119\u015b\u017a");
    @NotNull
    private static final Alphabet PORTUGUESE = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5");
    @NotNull
    private static final Alphabet ROMANIAN = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u015f\u0163");
    @NotNull
    private static final Alphabet SLOVAK = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u010f\u013e\u013a\u0148\u0155\u0165\u00fd");
    @NotNull
    private static final Alphabet SPANISH = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00a1\u00bf");
    @NotNull
    private static final Alphabet ASTURIAN = new SetBasedAlphabet(Group.LATIN, "abcdefghilmn\u00f1oprstuvxyz", "\u00f1", "");
    @NotNull
    private static final Alphabet BRETON = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnoprstuvwyz\u00e2\u00ea\u00ee\u00f4\u00fb\u00f9\u00fc\u00f1", "\u00e2\u00ea\u00ee\u00f4\u00fb\u00f9\u00fc\u00f1", "");
    @NotNull
    private static final Alphabet CATALAN = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00e8\u00ed\u00ef\u00f3\u00f2\u00fa\u00fc\u00e7", "\u00e0\u00e9\u00e8\u00ed\u00ef\u00f3\u00f2\u00fa\u00fc\u00e7", "");
    @NotNull
    private static final Alphabet DANISH = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e6\u00f8\u00e5", "\u00e6\u00f8\u00e5", "\u00e6\u00f8");
    @NotNull
    private static final Alphabet ESPERANTO = new SetBasedAlphabet(Group.LATIN, "abc\u0109defg\u011dh\u0125ij\u0135klmnoprs\u015dtu\u016dvz", "\u0109\u011d\u0125\u0135\u015d\u016d", "\u0109\u011d\u0125\u0135\u015d\u016d");
    @NotNull
    private static final Alphabet GALICIAN = new SetBasedAlphabet(Group.LATIN, "abcdefghilmn\u00f1opqrstuvxz", "\u00f1", "");
    @NotNull
    private static final Alphabet IRISH = new SetBasedAlphabet(Group.LATIN, "abcdefghilmnoprstu\u00e1\u00e9\u00ed\u00f3\u00fa", "\u00e1\u00e9\u00ed\u00f3\u00fa", "");
    @NotNull
    private static final Alphabet SLOVENE = new SetBasedAlphabet(Group.LATIN, "abc\u010ddefghijklmnoprs\u0161tuvz\u017e", "\u010d\u0161\u017e", "");
    @NotNull
    private static final Alphabet SWEDISH = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6", "\u00e5\u00e4\u00f6", "");
    @NotNull
    private static final Alphabet TAGALOG = new SetBasedAlphabet(Group.LATIN, "abcdefghijklmn\u00f1opqrstuvwxyz", "\u00f1", "");
    @NotNull
    private static final Alphabet GREEK = new RegexAlphabet(Group.GREEK, new Regex("[\\u0370-\\u03FF]+"), null, null, 12, null);
    @NotNull
    private static final Alphabet KHMER = new RegexAlphabet(Group.KHMER, new Regex("[\\u1780-\\u17FF]+"), null, null, 12, null);
    @NotNull
    private static final Alphabet TAMIL = new RegexAlphabet(Group.TAMIL, new Regex("[\\u0B80-\\u0BFF]+"), null, null, 12, null);
    @NotNull
    private static final Alphabet ARABIC = new RegexAlphabet(Group.ARABIC, new Regex("[\\u0600-\\u06FF]+"), null, null);
    @NotNull
    private static final Alphabet PERSIAN = new RegexAlphabet(Group.ARABIC, new Regex("[\\u0600-\\u06FF\\u200C]+"), new Regex("\\u200C"), new Regex("\\u200C"));
    @NotNull
    private static final Alphabet CHINESE = new RegexAlphabet(Group.ASIAN, new Regex("[\\u4E00-\\u9FFF\\u3400-\\u4DBF]+"), null, null, 12, null);
    @NotNull
    private static final Alphabet JAPANESE = new RegexAlphabet(Group.ASIAN, new Regex("[\\u3040-\\u309F\\u30A0-\\u30FF\\u31F0-\\u31FF\\u4E00-\\u9FFF\\u3400-\\u4DBF]+"), null, null, 12, null);
    @NotNull
    private static final Alphabet KOREAN = new RegexAlphabet(Group.ASIAN, new Regex("[\\uAC00-\\uD7A3\\u1100-\\u11FF\\u3130-\\u318F]+"), null, null, 12, null);
    @NotNull
    private static final Alphabet RUSSIAN = new SetBasedAlphabet(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "\u0451\u0439\u044a\u044b\u044d", "\u044a");
    @NotNull
    private static final Alphabet UKRANIAN = new SetBasedAlphabet(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0491\u0434\u0435\u0454\u0436\u0437\u0438\u0456\u0457\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044c\u044e\u044f\u02bc'", "\u0454\u0456\u0457\u0491", "\u0457\u0491");
    @NotNull
    private static final Alphabet BELARUSIAN = new SetBasedAlphabet(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0456\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u045e\u0444\u0445\u0446\u0447\u0448\u044b\u044c\u044d\u044e\u044f", "\u0451\u0439\u0454\u044b\u0456\u045e", "\u045e");
    @NotNull
    private static final Alphabet NONE = new NoneAlphabet();
    @NotNull
    private static final LinkedHashSet<Alphabet> all;
    @NotNull
    private static final LinkedHashSet<Alphabet> latin;
    @NotNull
    private static final LinkedHashSet<Alphabet> greek;
    @NotNull
    private static final LinkedHashSet<Alphabet> khmer;
    @NotNull
    private static final LinkedHashSet<Alphabet> tamil;
    @NotNull
    private static final LinkedHashSet<Alphabet> arabic;
    @NotNull
    private static final LinkedHashSet<Alphabet> cyrillic;
    @NotNull
    private static final LinkedHashSet<Alphabet> asian;

    private Alphabet(Group group) {
        this.group = group;
    }

    @NotNull
    public final Group getGroup() {
        return this.group;
    }

    public abstract boolean matchEntire(@NotNull CharSequence var1);

    public abstract boolean matchAny(@NotNull CharSequence var1);

    public abstract boolean matchAnySpecial(@NotNull CharSequence var1);

    public abstract boolean matchAnyUnique(@NotNull CharSequence var1);

    public /* synthetic */ Alphabet(Group group, DefaultConstructorMarker $constructor_marker) {
        this(group);
    }

    static {
        Object[] objectArray = new Alphabet[]{ENGLISH, FRENCH, GERMAN, DUTCH, ITALIAN, POLISH, PORTUGUESE, ROMANIAN, SLOVAK, SLOVENE, SWEDISH, SPANISH, TAGALOG, ASTURIAN, BRETON, CATALAN, DANISH, ESPERANTO, GALICIAN, IRISH, GREEK, KHMER, TAMIL, ARABIC, PERSIAN, CHINESE, JAPANESE, RUSSIAN, UKRANIAN, BELARUSIAN};
        all = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{ENGLISH, FRENCH, GERMAN, DUTCH, ITALIAN, POLISH, PORTUGUESE, ROMANIAN, SLOVAK, SLOVENE, SWEDISH, SPANISH, TAGALOG, ASTURIAN, BRETON, CATALAN, DANISH, ESPERANTO, GALICIAN, IRISH};
        latin = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{GREEK};
        greek = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{KHMER};
        khmer = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{TAMIL};
        tamil = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{ARABIC, PERSIAN};
        arabic = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{RUSSIAN, UKRANIAN, BELARUSIAN};
        cyrillic = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{CHINESE, JAPANESE};
        asian = SetsKt.linkedSetOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\bA\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010X\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G2\u0006\u0010Y\u001a\u00020ZR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0011\u00103\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006R\u0011\u00105\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006R\u0011\u00107\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0006R\u0011\u00109\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0006R\u0011\u0010;\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0006R\u0011\u0010=\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0006R\u0011\u0010?\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0006R\u0011\u0010A\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0006R\u0011\u0010C\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0006R!\u0010E\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR!\u0010J\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010IR!\u0010L\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010IR!\u0010N\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010IR!\u0010P\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010IR!\u0010R\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010IR!\u0010T\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010IR!\u0010V\u001a\u0012\u0012\u0004\u0012\u00020\u00040Fj\b\u0012\u0004\u0012\u00020\u0004`G\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010I\u00a8\u0006["}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet$Companion;", "", "()V", "ARABIC", "Lai/grazie/nlp/langs/alphabet/Alphabet;", "getARABIC", "()Lai/grazie/nlp/langs/alphabet/Alphabet;", "ASTURIAN", "getASTURIAN", "BELARUSIAN", "getBELARUSIAN", "BRETON", "getBRETON", "CATALAN", "getCATALAN", "CHINESE", "getCHINESE", "DANISH", "getDANISH", "DUTCH", "getDUTCH", "ENGLISH", "getENGLISH", "ESPERANTO", "getESPERANTO", "FRENCH", "getFRENCH", "GALICIAN", "getGALICIAN", "GERMAN", "getGERMAN", "GREEK", "getGREEK", "IRISH", "getIRISH", "ITALIAN", "getITALIAN", "JAPANESE", "getJAPANESE", "KHMER", "getKHMER", "KOREAN", "getKOREAN", "NONE", "getNONE", "PERSIAN", "getPERSIAN", "POLISH", "getPOLISH", "PORTUGUESE", "getPORTUGUESE", "ROMANIAN", "getROMANIAN", "RUSSIAN", "getRUSSIAN", "SLOVAK", "getSLOVAK", "SLOVENE", "getSLOVENE", "SPANISH", "getSPANISH", "SWEDISH", "getSWEDISH", "TAGALOG", "getTAGALOG", "TAMIL", "getTAMIL", "UKRANIAN", "getUKRANIAN", "all", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getAll", "()Ljava/util/LinkedHashSet;", "arabic", "getArabic", "asian", "getAsian", "cyrillic", "getCyrillic", "greek", "getGreek", "khmer", "getKhmer", "latin", "getLatin", "tamil", "getTamil", "byGroup", "group", "Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "nlp-langs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Alphabet getENGLISH() {
            return ENGLISH;
        }

        @NotNull
        public final Alphabet getFRENCH() {
            return FRENCH;
        }

        @NotNull
        public final Alphabet getGERMAN() {
            return GERMAN;
        }

        @NotNull
        public final Alphabet getDUTCH() {
            return DUTCH;
        }

        @NotNull
        public final Alphabet getITALIAN() {
            return ITALIAN;
        }

        @NotNull
        public final Alphabet getPOLISH() {
            return POLISH;
        }

        @NotNull
        public final Alphabet getPORTUGUESE() {
            return PORTUGUESE;
        }

        @NotNull
        public final Alphabet getROMANIAN() {
            return ROMANIAN;
        }

        @NotNull
        public final Alphabet getSLOVAK() {
            return SLOVAK;
        }

        @NotNull
        public final Alphabet getSPANISH() {
            return SPANISH;
        }

        @NotNull
        public final Alphabet getASTURIAN() {
            return ASTURIAN;
        }

        @NotNull
        public final Alphabet getBRETON() {
            return BRETON;
        }

        @NotNull
        public final Alphabet getCATALAN() {
            return CATALAN;
        }

        @NotNull
        public final Alphabet getDANISH() {
            return DANISH;
        }

        @NotNull
        public final Alphabet getESPERANTO() {
            return ESPERANTO;
        }

        @NotNull
        public final Alphabet getGALICIAN() {
            return GALICIAN;
        }

        @NotNull
        public final Alphabet getIRISH() {
            return IRISH;
        }

        @NotNull
        public final Alphabet getSLOVENE() {
            return SLOVENE;
        }

        @NotNull
        public final Alphabet getSWEDISH() {
            return SWEDISH;
        }

        @NotNull
        public final Alphabet getTAGALOG() {
            return TAGALOG;
        }

        @NotNull
        public final Alphabet getGREEK() {
            return GREEK;
        }

        @NotNull
        public final Alphabet getKHMER() {
            return KHMER;
        }

        @NotNull
        public final Alphabet getTAMIL() {
            return TAMIL;
        }

        @NotNull
        public final Alphabet getARABIC() {
            return ARABIC;
        }

        @NotNull
        public final Alphabet getPERSIAN() {
            return PERSIAN;
        }

        @NotNull
        public final Alphabet getCHINESE() {
            return CHINESE;
        }

        @NotNull
        public final Alphabet getJAPANESE() {
            return JAPANESE;
        }

        @NotNull
        public final Alphabet getKOREAN() {
            return KOREAN;
        }

        @NotNull
        public final Alphabet getRUSSIAN() {
            return RUSSIAN;
        }

        @NotNull
        public final Alphabet getUKRANIAN() {
            return UKRANIAN;
        }

        @NotNull
        public final Alphabet getBELARUSIAN() {
            return BELARUSIAN;
        }

        @NotNull
        public final Alphabet getNONE() {
            return NONE;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getAll() {
            return all;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getLatin() {
            return latin;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getGreek() {
            return greek;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getKhmer() {
            return khmer;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getTamil() {
            return tamil;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getArabic() {
            return arabic;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getCyrillic() {
            return cyrillic;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getAsian() {
            return asian;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> byGroup(@NotNull Group group) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            return switch (WhenMappings.$EnumSwitchMapping$0[group.ordinal()]) {
                case 1 -> this.getLatin();
                case 2 -> this.getGreek();
                case 3 -> this.getKhmer();
                case 4 -> this.getTamil();
                case 5 -> this.getArabic();
                case 6 -> this.getAsian();
                case 7 -> this.getCyrillic();
                case 8 -> {
                    Object[] var2_2 = new Alphabet[]{this.getNONE()};
                    yield SetsKt.linkedSetOf((Object[])var2_2);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Group.values().length];
                try {
                    nArray[Group.LATIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.GREEK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.KHMER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.TAMIL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.ARABIC.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.ASIAN.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.CYRILLIC.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.NONE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u000b\b\u0086\u0001\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "", "acceptableChar", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "getAcceptableChar", "()Lkotlin/jvm/functions/Function1;", "matchAny", "input", "", "matchEntire", "LATIN", "GREEK", "KHMER", "TAMIL", "ARABIC", "ASIAN", "CYRILLIC", "NONE", "Companion", "nlp-langs"})
    @SourceDebugExtension(value={"SMAP\nAlphabet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet$Group\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,106:1\n1088#2,2:107\n1069#2,2:109\n*S KotlinDebug\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet$Group\n*L\n29#1:107,2\n30#1:109,2\n*E\n"})
    public static final class Group
    extends Enum<Group> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Function1<Character, Boolean> acceptableChar;
        @NotNull
        private static final List<Group> all;
        @NotNull
        private static final List<Group> withSpaces;
        public static final /* enum */ Group LATIN;
        public static final /* enum */ Group GREEK;
        public static final /* enum */ Group KHMER;
        public static final /* enum */ Group TAMIL;
        public static final /* enum */ Group ARABIC;
        public static final /* enum */ Group ASIAN;
        public static final /* enum */ Group CYRILLIC;
        public static final /* enum */ Group NONE;
        private static final /* synthetic */ Group[] $VALUES;

        private Group(Function1<? super Character, Boolean> acceptableChar) {
            this.acceptableChar = acceptableChar;
        }

        @NotNull
        public final Function1<Character, Boolean> getAcceptableChar() {
            return this.acceptableChar;
        }

        public final boolean matchAny(@NotNull CharSequence input2) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
                CharSequence $this$any$iv = input2;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!((Boolean)this.acceptableChar.invoke((Object)Character.valueOf(it))).booleanValue()) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public final boolean matchEntire(@NotNull CharSequence input2) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
                CharSequence $this$all$iv = input2;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (((Boolean)this.acceptableChar.invoke((Object)Character.valueOf(it))).booleanValue()) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String value) {
            return Enum.valueOf(Group.class, value);
        }

        static {
            LATIN = new Group((Function1<? super Character, Boolean>)((Function1)1.INSTANCE));
            GREEK = new Group((Function1<? super Character, Boolean>)((Function1)2.INSTANCE));
            KHMER = new Group((Function1<? super Character, Boolean>)((Function1)3.INSTANCE));
            TAMIL = new Group((Function1<? super Character, Boolean>)((Function1)4.INSTANCE));
            ARABIC = new Group((Function1<? super Character, Boolean>)((Function1)5.INSTANCE));
            ASIAN = new Group((Function1<? super Character, Boolean>)((Function1)6.INSTANCE));
            CYRILLIC = new Group((Function1<? super Character, Boolean>)((Function1)7.INSTANCE));
            NONE = new Group((Function1<? super Character, Boolean>)((Function1)8.INSTANCE));
            $VALUES = groupArray = new Group[]{Group.LATIN, Group.GREEK, Group.KHMER, Group.TAMIL, Group.ARABIC, Group.ASIAN, Group.CYRILLIC, Group.NONE};
            Companion = new Companion(null);
            Group[] groupArray = new Group[]{LATIN, GREEK, KHMER, TAMIL, ARABIC, ASIAN, CYRILLIC};
            all = CollectionsKt.listOf((Object[])groupArray);
            groupArray = new Group[]{LATIN, GREEK, CYRILLIC};
            withSpaces = CollectionsKt.listOf((Object[])groupArray);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet$Group$Companion;", "", "()V", "all", "", "Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "getAll", "()Ljava/util/List;", "withSpaces", "getWithSpaces", "nlp-langs"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<Group> getAll() {
                return all;
            }

            @NotNull
            public final List<Group> getWithSpaces() {
                return withSpaces;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

