/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocAccess;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryFileRawTypedHandler;", "Lcom/intellij/codeInsight/template/impl/editorActions/TypedActionHandlerBase;", "original", "Lcom/intellij/openapi/editor/actionSystem/TypedActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/TypedActionHandler;)V", "getOriginal", "()Lcom/intellij/openapi/editor/actionSystem/TypedActionHandler;", "execute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "charTyped", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "intellij.cidr.debugger"})
public final class CidrMemoryFileRawTypedHandler
extends TypedActionHandlerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypedActionHandler original;
    @NotNull
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    public CidrMemoryFileRawTypedHandler(@NotNull TypedActionHandler original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        super(original);
        this.original = original;
    }

    @NotNull
    public final TypedActionHandler getOriginal() {
        return this.original;
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        MemoryViewFile memoryViewFile;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        VirtualFile virtualFile = editor.getVirtualFile();
        MemoryViewFile memoryViewFile2 = memoryViewFile = virtualFile instanceof MemoryViewFile ? (MemoryViewFile)virtualFile : null;
        CidrMemoryDoc<Object> memoryDoc = memoryViewFile2 != null ? memoryViewFile2.getMemoryDoc() : null;
        CidrMemoryDoc<?> cidrMemoryDoc = memoryDoc;
        if (cidrMemoryDoc == null || (cidrMemoryDoc = cidrMemoryDoc.getDataProvider()) == null) {
            this.original.execute(editor, charTyped, dataContext);
            return;
        }
        CidrMemoryDoc<?> dataProvider = cidrMemoryDoc;
        if (editor.getSelectionModel().hasSelection(true)) {
            String string = CidrDebuggerBundle.message("debug.memory.editing.action.is.not.supported", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            HintManager.getInstance().showInformationHint(editor, message, null);
            return;
        }
        String readOnlyReason = dataProvider.readOnlyReason();
        if (readOnlyReason == null) {
            memoryDoc.getDocAccess().edit((Function1)new Function1<?, Unit>(this, editor, charTyped, dataContext){
                final /* synthetic */ CidrMemoryFileRawTypedHandler this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ char $charTyped;
                final /* synthetic */ DataContext $dataContext;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    this.$charTyped = $charTyped;
                    this.$dataContext = $dataContext;
                }

                public final void invoke(CidrMemoryDocAccess.DocAccessScope<? extends Object> $this$edit) {
                    Intrinsics.checkNotNullParameter($this$edit, (String)"$this$edit");
                    this.this$0.getOriginal().execute(this.$editor, this.$charTyped, this.$dataContext);
                }
            });
        } else {
            HintManager.getInstance().showInformationHint(editor, readOnlyReason, null);
        }
    }

    @JvmStatic
    public static final void initIfNeeded() {
        Companion.initIfNeeded();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryFileRawTypedHandler$Companion;", "", "<init>", "()V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "initIfNeeded", "", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicBoolean getInitialized() {
            return initialized;
        }

        @JvmStatic
        public final void initIfNeeded() {
            if (this.getInitialized().compareAndSet(false, true)) {
                TypedActionHandler typedActionHandler = TypedAction.getInstance().getRawHandler();
                Intrinsics.checkNotNullExpressionValue((Object)typedActionHandler, (String)"getRawHandler(...)");
                TypedActionHandler originalHandler = typedActionHandler;
                TypedAction.getInstance().setupRawHandler((TypedActionHandler)new CidrMemoryFileRawTypedHandler(originalHandler));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

