/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameCacheKt;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameNode;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameRenderOptions;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameSugarizeOptions;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameToStringRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.SugarizeCache;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B%\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/StringRenderCache;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/SugarizeCache;", "parse", "Lkotlin/Function1;", "", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameNode;", "renderer", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameToStringRenderer;", "<init>", "(Lkotlin/jvm/functions/Function1;Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameToStringRenderer;)V", "stringRenderCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/StringRenderCache$StringRenderKey;", "Ljava/util/Optional;", "renderString", "s", "sugarizeOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;", "renderOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;", "StringRenderKey", "intellij.cidr.debugger"})
final class StringRenderCache
extends SugarizeCache {
    @NotNull
    private final LoadingCache<StringRenderKey, Optional<String>> stringRenderCache;

    public StringRenderCache(@NotNull Function1<? super String, ? extends CxxNameNode> parse, @NotNull CxxNameToStringRenderer renderer) {
        Intrinsics.checkNotNullParameter(parse, (String)"parse");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        super(parse);
        LoadingCache loadingCache = CxxNameCacheKt.access$getCaffeine$p().build(arg_0 -> StringRenderCache.stringRenderCache$lambda$1(arg_0 -> StringRenderCache.stringRenderCache$lambda$0(this, renderer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.stringRenderCache = loadingCache;
    }

    @Nullable
    public final String renderString(@NotNull String s, @NotNull CxxNameSugarizeOptions sugarizeOptions, @NotNull CxxNameRenderOptions renderOptions) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)sugarizeOptions, (String)"sugarizeOptions");
        Intrinsics.checkNotNullParameter((Object)renderOptions, (String)"renderOptions");
        StringRenderKey key = new StringRenderKey(s, sugarizeOptions, renderOptions);
        Optional optional = (Optional)this.stringRenderCache.get((Object)key);
        return optional != null ? (String)UtilKt.orNull((Optional)optional) : null;
    }

    private static final Optional stringRenderCache$lambda$0(StringRenderCache this$0, CxxNameToStringRenderer $renderer, StringRenderKey stringRenderKey) {
        String s = stringRenderKey.component1();
        CxxNameSugarizeOptions sugarizeOptions = stringRenderKey.component2();
        CxxNameRenderOptions renderOptions = stringRenderKey.component3();
        CxxNameNode node = this$0.sugarizeNode(s, sugarizeOptions);
        return node == null ? Optional.empty() : Optional.of($renderer.renderString(node, renderOptions));
    }

    private static final Optional stringRenderCache$lambda$1(Function1 $tmp0, Object key) {
        return (Optional)$tmp0.invoke(key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/StringRenderCache$StringRenderKey;", "", "string", "", "sugarizeOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;", "renderOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;)V", "getString", "()Ljava/lang/String;", "getSugarizeOptions", "()Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;", "getRenderOptions", "()Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.debugger"})
    private static final class StringRenderKey {
        @NotNull
        private final String string;
        @NotNull
        private final CxxNameSugarizeOptions sugarizeOptions;
        @NotNull
        private final CxxNameRenderOptions renderOptions;

        public StringRenderKey(@NotNull String string, @NotNull CxxNameSugarizeOptions sugarizeOptions, @NotNull CxxNameRenderOptions renderOptions) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)sugarizeOptions, (String)"sugarizeOptions");
            Intrinsics.checkNotNullParameter((Object)renderOptions, (String)"renderOptions");
            this.string = string;
            this.sugarizeOptions = sugarizeOptions;
            this.renderOptions = renderOptions;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        @NotNull
        public final CxxNameSugarizeOptions getSugarizeOptions() {
            return this.sugarizeOptions;
        }

        @NotNull
        public final CxxNameRenderOptions getRenderOptions() {
            return this.renderOptions;
        }

        @NotNull
        public final String component1() {
            return this.string;
        }

        @NotNull
        public final CxxNameSugarizeOptions component2() {
            return this.sugarizeOptions;
        }

        @NotNull
        public final CxxNameRenderOptions component3() {
            return this.renderOptions;
        }

        @NotNull
        public final StringRenderKey copy(@NotNull String string, @NotNull CxxNameSugarizeOptions sugarizeOptions, @NotNull CxxNameRenderOptions renderOptions) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)sugarizeOptions, (String)"sugarizeOptions");
            Intrinsics.checkNotNullParameter((Object)renderOptions, (String)"renderOptions");
            return new StringRenderKey(string, sugarizeOptions, renderOptions);
        }

        public static /* synthetic */ StringRenderKey copy$default(StringRenderKey stringRenderKey, String string, CxxNameSugarizeOptions cxxNameSugarizeOptions, CxxNameRenderOptions cxxNameRenderOptions, int n, Object object) {
            if ((n & 1) != 0) {
                string = stringRenderKey.string;
            }
            if ((n & 2) != 0) {
                cxxNameSugarizeOptions = stringRenderKey.sugarizeOptions;
            }
            if ((n & 4) != 0) {
                cxxNameRenderOptions = stringRenderKey.renderOptions;
            }
            return stringRenderKey.copy(string, cxxNameSugarizeOptions, cxxNameRenderOptions);
        }

        @NotNull
        public String toString() {
            return "StringRenderKey(string=" + this.string + ", sugarizeOptions=" + this.sugarizeOptions + ", renderOptions=" + this.renderOptions + ")";
        }

        public int hashCode() {
            int result = this.string.hashCode();
            result = result * 31 + this.sugarizeOptions.hashCode();
            result = result * 31 + this.renderOptions.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StringRenderKey)) {
                return false;
            }
            StringRenderKey stringRenderKey = (StringRenderKey)other;
            if (!Intrinsics.areEqual((Object)this.string, (Object)stringRenderKey.string)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sugarizeOptions, (Object)stringRenderKey.sugarizeOptions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.renderOptions, (Object)stringRenderKey.renderOptions);
        }
    }
}

