/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CidrRichValueBuilder;", "", "<init>", "()V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "s", "", "appendString", "quotedString", "appendComment", "comment", "getRichValue", "escapeRichValueMark", "Companion", "intellij.cidr.debugger"})
public final class CidrRichValueBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    @NotNull
    private static final String UNESCAPED_MARK = "\u00fe";
    @NotNull
    private static final String ESCAPED_MARK = "\u00fe\u00fe";

    @NotNull
    public final CidrRichValueBuilder append(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.builder.append(s);
        return this;
    }

    @NotNull
    public final CidrRichValueBuilder appendString(@NotNull String quotedString) {
        Intrinsics.checkNotNullParameter((Object)quotedString, (String)"quotedString");
        this.builder.append('\u00fe');
        this.builder.append('S');
        this.builder.append(this.escapeRichValueMark(quotedString));
        this.builder.append('\u00fe');
        this.builder.append('E');
        return this;
    }

    @NotNull
    public final CidrRichValueBuilder appendComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.builder.append('\u00fe');
        this.builder.append('C');
        this.builder.append(this.escapeRichValueMark(comment));
        this.builder.append('\u00fe');
        this.builder.append('E');
        return this;
    }

    @NotNull
    public final String getRichValue() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String escapeRichValueMark(String s) {
        return StringsKt.replace$default((String)s, (String)UNESCAPED_MARK, (String)ESCAPED_MARK, (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CidrRichValueBuilder$Companion;", "", "<init>", "()V", "UNESCAPED_MARK", "", "ESCAPED_MARK", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

