/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Key;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J(\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRichValuePresentation;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "value", "", "type", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "getSeparator", "renderValue", "", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "renderToken", "richToken", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRendererUtils$RichValueToken;", "extractText", "", "renderUiValue", "renderString", "string", "getType", "Companion", "intellij.cidr.debugger"})
public final class CidrRichValuePresentation
extends XValuePresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @Nullable
    private final String type;
    public static final char MARK = '\u00fe';
    public static final char STRING = 'S';
    public static final char KEYWORD = 'K';
    public static final char NUMBER = 'N';
    public static final char COMMENT = 'C';
    public static final char CHAR = 'V';
    public static final char END = 'E';
    @JvmField
    @NotNull
    public static final Key<Boolean> RENDER_UI_VALUE;

    public CidrRichValuePresentation(@NotNull String value, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.type = type;
    }

    public /* synthetic */ CidrRichValuePresentation(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public String getSeparator() {
        String string;
        CharSequence charSequence;
        if (((CharSequence)this.value).length() == 0 && ((charSequence = (CharSequence)this.type) == null || charSequence.length() == 0)) {
            string = "";
        } else {
            String string2 = super.getSeparator();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparator(...)");
        }
        return string;
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        boolean renderUiValue = TestModeFlags.is(RENDER_UI_VALUE);
        boolean extractText = XValuePresentationUtil.isValueTextExtractor((XValuePresentation.XValueTextRenderer)renderer) && !renderUiValue;
        int currentIndex = 0;
        int renderedIndex = 0;
        TextAttributesKey defaultAttributes = DefaultLanguageHighlighterColors.IDENTIFIER;
        while (currentIndex < this.value.length()) {
            ValueRendererUtils.RichValueToken richToken = ValueRendererUtils.readRichValueToken(this.value, currentIndex);
            if (richToken != null) {
                if (renderedIndex < currentIndex) {
                    String string = this.value.substring(renderedIndex, currentIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    renderer.renderValue(string, defaultAttributes);
                }
                this.renderToken(renderer, richToken, extractText, renderUiValue);
                renderedIndex = richToken.endIndex;
                currentIndex = richToken.endIndex;
                continue;
            }
            ++currentIndex;
        }
        if (renderedIndex < this.value.length()) {
            String string = this.value.substring(renderedIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            renderer.renderValue(string, defaultAttributes);
        }
    }

    private final void renderToken(XValuePresentation.XValueTextRenderer renderer, ValueRendererUtils.RichValueToken richToken, boolean extractText, boolean renderUiValue) {
        String richTokenContents = richToken.tokenContent;
        switch (richToken.tokenType) {
            case 'S': {
                Intrinsics.checkNotNull((Object)richTokenContents);
                this.renderString(renderer, richTokenContents, extractText, renderUiValue);
                break;
            }
            case 'K': {
                renderer.renderKeywordValue(richTokenContents);
                break;
            }
            case 'N': {
                renderer.renderNumericValue(richTokenContents);
                break;
            }
            case 'C': {
                if (extractText) break;
                renderer.renderComment(richTokenContents);
                break;
            }
            case 'V': {
                renderer.renderValue(richTokenContents);
                break;
            }
            default: {
                renderer.renderValue(richTokenContents);
            }
        }
    }

    private final void renderString(XValuePresentation.XValueTextRenderer renderer, String string, boolean extractText, boolean renderUiValue) {
        String string2 = ValueRendererUtils.trimStringPrefix(string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStringPrefix(...)");
        String quotedString = string2;
        String prefix = StringsKt.removeSuffix((String)string, (CharSequence)quotedString);
        String noQuotes = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)quotedString, (CharSequence)"\""), (CharSequence)"\"");
        if (extractText) {
            renderer.renderStringValue(noQuotes, "\"\\", -1);
        } else {
            renderer.renderValue(prefix);
            if (renderUiValue) {
                StringBuilder result = new StringBuilder(quotedString.length());
                int n = quotedString.length();
                block9: for (int i = 0; i < n; ++i) {
                    char c = quotedString.charAt(i);
                    switch (c) {
                        case '\u0007': {
                            StringBuilder stringBuilder = result.append("\\a");
                            continue block9;
                        }
                        case '\b': {
                            StringBuilder stringBuilder = result.append("\\b");
                            continue block9;
                        }
                        case '\t': {
                            StringBuilder stringBuilder = result.append("\\t");
                            continue block9;
                        }
                        case '\n': {
                            StringBuilder stringBuilder = result.append("\\n");
                            continue block9;
                        }
                        case '\u000b': {
                            StringBuilder stringBuilder = result.append("\\v");
                            continue block9;
                        }
                        case '\f': {
                            StringBuilder stringBuilder = result.append("\\f");
                            continue block9;
                        }
                        case '\r': {
                            StringBuilder stringBuilder = result.append("\\r");
                            continue block9;
                        }
                        default: {
                            StringBuilder stringBuilder = result.append(c);
                        }
                    }
                }
                renderer.renderStringValue(result.toString(), "\"\\", -1);
            } else {
                renderer.renderStringValue(noQuotes, "\"\\", -1);
            }
        }
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    static {
        Key key = Key.create((String)"CidrRichValuePresentation.extractUiValue");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RENDER_UI_VALUE = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrRichValuePresentation$Companion;", "", "<init>", "()V", "MARK", "", "STRING", "KEYWORD", "NUMBER", "COMMENT", "CHAR", "END", "RENDER_UI_VALUE", "Lcom/intellij/openapi/util/Key;", "", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

