/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.evaluation.ApplyFixExpressionHyperLink;
import com.jetbrains.cidr.execution.debugger.evaluation.ErrorPresentationWithFix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\r*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrErrorWithFixValue;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "message", "", "fixedExpr", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "setErrorPresentation", "", "Lcom/intellij/xdebugger/frame/XValueNode;", "enableFixByLink", "", "hasFixLink", "getHasFixLink", "(Lcom/intellij/xdebugger/frame/XValueNode;)Z", "computePresentation", "node", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.cidr.debugger"})
public final class CidrErrorWithFixValue
extends XNamedValue {
    @NotNull
    private final String message;
    @Nullable
    private final String fixedExpr;

    public CidrErrorWithFixValue(@NlsSafe @NotNull String message, @Nullable String fixedExpr) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super("error");
        this.message = message;
        this.fixedExpr = fixedExpr;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    private final void setErrorPresentation(XValueNode $this$setErrorPresentation, boolean enableFixByLink) {
        $this$setErrorPresentation.setPresentation(XDebuggerUIConstants.ERROR_MESSAGE_ICON, (XValuePresentation)new ErrorPresentationWithFix(this.message, this.fixedExpr, enableFixByLink), false);
    }

    private final boolean getHasFixLink(XValueNode $this$hasFixLink) {
        XValueNodeImpl xValueNodeImpl = $this$hasFixLink instanceof XValueNodeImpl ? (XValueNodeImpl)$this$hasFixLink : null;
        XValuePresentation xValuePresentation = xValueNodeImpl != null ? xValueNodeImpl.getValuePresentation() : null;
        ErrorPresentationWithFix errorPresentationWithFix = xValuePresentation instanceof ErrorPresentationWithFix ? (ErrorPresentationWithFix)xValuePresentation : null;
        return errorPresentationWithFix != null ? errorPresentationWithFix.getEnableFixByLink() : false;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        if (node.isObsolete()) {
            return;
        }
        if (this.getHasFixLink(node)) {
            return;
        }
        if (node instanceof XValueNodeImpl && !((charSequence = (CharSequence)this.fixedExpr) == null || charSequence.length() == 0)) {
            this.setErrorPresentation(node, true);
            ((XValueNodeImpl)node).clearAdditionalHyperlinks();
            ((XValueNodeImpl)node).addAdditionalHyperlink((XDebuggerTreeNodeHyperlink)new ApplyFixExpressionHyperLink((XValueNodeImpl)node, this.fixedExpr));
        } else {
            this.setErrorPresentation(node, false);
        }
    }
}

