/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCodePointHandlerBase<T extends XBreakpoint<?>, C extends LLCodepoint>
extends XBreakpointHandler<T> {
    protected final CidrDebugProcess myProcess;
    private final Map<Integer, C> myIdToCodepoint;
    private final Map<T, List<Integer>> myBreakpoints;
    private final Map<Integer, T> myIdToBreakpoint;

    public CidrCodePointHandlerBase(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<T, ?>> type) {
        if (type == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(0);
        }
        super(type);
        this.myIdToCodepoint = new HashMap<Integer, C>();
        this.myBreakpoints = FactoryMap.create(key -> new ArrayList());
        this.myIdToBreakpoint = new HashMap<Integer, T>();
        this.myProcess = process;
    }

    public void registerBreakpoint(@NotNull T breakpoint) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(1);
        }
        long threadId = this.myProcess.getCurrentThreadId();
        int frameIndex = this.myProcess.getCurrentFrameIndex();
        CidrDebuggerLog.LOG.debug("Register breakpoint " + String.valueOf(breakpoint) + ", thread " + threadId + ", frame " + frameIndex);
        this.myProcess.postCommand(driver -> this.doRegisterBreakpoint(driver, breakpoint, threadId, frameIndex));
    }

    public void unregisterBreakpoint(@NotNull T breakpoint, boolean temporary) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(2);
        }
        CidrDebuggerLog.LOG.debug("Unregister breakpoint " + String.valueOf(breakpoint));
        this.myProcess.postCommand(driver -> this.doUnregisterBreakpoint(driver, breakpoint));
    }

    /*
     * WARNING - void declaration
     */
    protected void doRegisterBreakpoint(@NotNull DebuggerDriver driver, @NotNull T breakpoint, long threadId, int n) throws ExecutionException {
        void frameIndex;
        Collection<C> added;
        if (driver == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(3);
        }
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(4);
        }
        if ((added = this.addCodepointsInBackend(driver, breakpoint, threadId, (int)frameIndex)).isEmpty()) {
            return;
        }
        this.registerCodepointsMapping(breakpoint, added);
    }

    protected void doUnregisterBreakpoint(@NotNull DebuggerDriver driver, @NotNull T breakpoint) throws ExecutionException {
        List<Integer> idsToRemove;
        if (driver == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(5);
        }
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(6);
        }
        if ((idsToRemove = this.unregisterCodepointsMapping(breakpoint)).isEmpty()) {
            return;
        }
        try {
            this.removeCodepointsInBackend(driver, idsToRemove, breakpoint);
        }
        catch (DebuggerCommandException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCodepointsMapping(@NotNull T breakpoint, @NotNull Collection<C> added) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(7);
        }
        if (added == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(8);
        }
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            List<Integer> breakpointIds = this.myBreakpoints.get(breakpoint);
            for (LLCodepoint each : added) {
                this.myIdToCodepoint.put(each.getId(), each);
                breakpointIds.add(each.getId());
                this.myIdToBreakpoint.put(each.getId(), breakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> unregisterCodepointsMapping(@NotNull T breakpoint) {
        List<Integer> idsToRemove;
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(9);
        }
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            idsToRemove = this.myBreakpoints.remove(breakpoint);
            if (idsToRemove == null) {
                return Collections.emptyList();
            }
            for (Integer each : idsToRemove) {
                this.myIdToCodepoint.remove(each);
                this.myIdToBreakpoint.remove(each);
            }
        }
        return Collections.unmodifiableList(idsToRemove);
    }

    protected abstract Collection<C> addCodepointsInBackend(@NotNull DebuggerDriver var1, @NotNull T var2, long var3, int var5) throws ExecutionException;

    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull T breakpoint) throws ExecutionException, DebuggerCommandException {
        if (driver == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(10);
        }
        if (ids == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(11);
        }
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(12);
        }
        driver.removeCodepoints(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getXBreakpoint(int id) {
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            return (T)((XBreakpoint)this.myIdToBreakpoint.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public C getCodepoint(int id) {
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            return (C)((LLCodepoint)this.myIdToCodepoint.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCodepoint(int id, @NotNull C codepoint) {
        if (codepoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(13);
        }
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            this.myIdToCodepoint.replace(id, codepoint);
        }
    }

    @Nullable
    protected String convertCondition(@NotNull XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        XExpression conditionExpression;
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(14);
        }
        if ((conditionExpression = breakpoint.getConditionExpression()) == null) {
            return null;
        }
        String condition = conditionExpression.getExpression();
        String conversion = (String)WriteAction.computeAndWait(() -> {
            try {
                return CidrEvaluatorHelper.getInstance().convertExpression(this.myProcess, condition, breakpoint.getSourcePosition());
            }
            catch (CidrEvaluatorHelper.ConversionException e) {
                if (breakpoint instanceof XLineBreakpoint) {
                    this.myProcess.getSession().setBreakpointInvalid((XLineBreakpoint)breakpoint, e.getMessage());
                }
                return null;
            }
        });
        if (conversion != null) {
            return conversion;
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codepoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRegisterBreakpoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doUnregisterBreakpoint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCodepointsMapping";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterCodepointsMapping";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCodepointsInBackend";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCodepoint";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "convertCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

