/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a&\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0000\u00a8\u0006\t"}, d2={"waitForSemaphore", "", "s", "Lcom/intellij/util/concurrency/Semaphore;", "", "timeoutMillis", "", "extraCondition", "Lkotlin/Function0;", "intellij.cidr.debugger"})
@JvmName(name="GdbUtil")
public final class GdbUtil {
    public static final void waitForSemaphore(@NotNull Semaphore s) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
    }

    public static final boolean waitForSemaphore(@NotNull Semaphore s, long timeoutMillis) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            return s.waitForUnsafe(timeoutMillis);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
    }

    public static final boolean waitForSemaphore(@NotNull Semaphore s, long timeoutMillis, @NotNull Function0<Boolean> extraCondition) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter(extraCondition, (String)"extraCondition");
        long iterationTimeout = RangesKt.coerceIn((long)timeoutMillis, (long)0L, (long)1000L);
        long totalTimeWaited = 0L;
        boolean result = false;
        while (!((result = GdbUtil.waitForSemaphore(s, iterationTimeout)) || timeoutMillis >= 0L && (totalTimeWaited += iterationTimeout) >= timeoutMillis || ((Boolean)extraCondition.invoke()).booleanValue())) {
        }
        return result;
    }
}

