/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbBaseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBResponseVisitor
extends GdbBaseVisitor<GDBResponse> {
    private static final Pattern ID_PATTERN = Pattern.compile("[\\w-]*");

    private static <T> T getResultValue(GDBResponse.ResultRecord val) {
        GDBTuple tuple = val.getResultList();
        return (T)(switch ((GDBResponse.ResultRecord.Type)val.getType()) {
            case GDBResponse.ResultRecord.Type.tuple_value -> tuple;
            case GDBResponse.ResultRecord.Type.list_value, GDBResponse.ResultRecord.Type.str_value -> GDBResponseVisitor.getSoleElement(tuple);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield null;
            }
        });
    }

    private static <T> T getSoleResult(GDBResponse.ResultRecord val) {
        GDBTuple tuple = val.getResultList();
        return GDBResponseVisitor.getSoleElement(tuple);
    }

    private static <T> T getSoleElement(GDBTuple tuple) {
        if (tuple.size() != 1) {
            throw new IllegalArgumentException("Expected tuple of a single element: " + String.valueOf(tuple));
        }
        return (T)tuple.get(0);
    }

    public static GDBResponse getResponse(@Nullable String varName, GDBResponse.ResultRecord val) {
        Object value = GDBResponseVisitor.getResultValue(val);
        if (varName != null) {
            value = Pair.create((Object)varName, value);
        }
        GDBTuple r = GDBTuple.of(new Object[]{value});
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.result, r, null);
    }

    @Override
    public GDBResponse visitResult(@NotNull GdbParser.ResultContext ctx) {
        if (ctx == null) {
            GDBResponseVisitor.$$$reportNull$$$0(0);
        }
        GDBResponse.ResultRecord val = (GDBResponse.ResultRecord)this.visitValue(ctx.value());
        return GDBResponseVisitor.getResponse(ctx.variable == null ? null : ctx.variable.getText(), val);
    }

    @Override
    public GDBResponse visitCnst(@NotNull GdbParser.CnstContext ctx) {
        if (ctx == null) {
            GDBResponseVisitor.$$$reportNull$$$0(1);
        }
        GDBTuple r = GDBTuple.of(new Object[]{GDBResponseVisitor.getUnquotedString(ctx.cString(), true)});
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.str_value, r, null);
    }

    @Override
    public GDBResponse visitTuple(@NotNull GdbParser.TupleContext ctx) {
        if (ctx == null) {
            GDBResponseVisitor.$$$reportNull$$$0(2);
        }
        GDBTuple results = this.doVisitTuple(ctx.result());
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.tuple_value, results, null);
    }

    private GDBTuple doVisitTuple(List<GdbParser.ResultContext> items) {
        return items.stream().map(each -> GDBResponseVisitor.getSoleResult((GDBResponse.ResultRecord)this.visitResult((GdbParser.ResultContext)each))).collect(Collectors.toCollection(GDBTuple::new));
    }

    private GDBTuple doVisitList(List<GdbParser.ResultContext> items) {
        return GDBTuple.of(new Object[]{this.doVisitTuple(items)});
    }

    @Override
    public GDBResponse visitList(@NotNull GdbParser.ListContext ctx) {
        if (ctx == null) {
            GDBResponseVisitor.$$$reportNull$$$0(3);
        }
        GDBTuple result = this.doVisitList(ctx.result());
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.list_value, result, null);
    }

    @Override
    public GDBResponse visitResultRecord(@NotNull GdbParser.ResultRecordContext ctx) {
        if (ctx == null) {
            GDBResponseVisitor.$$$reportNull$$$0(4);
        }
        String commandToken = null;
        if (ctx.commandToken != null) {
            commandToken = ctx.commandToken.getText();
        }
        GDBTuple results = this.doVisitTuple(ctx.result());
        if (ctx.listTailToken != null) {
            results = GDBTuple.of(new Object[]{Couple.of((Object)"changelist", (Object)results)});
        } else if (results.size() == 1 && results.get(0) instanceof String) {
            results = GDBTuple.of(new Object[]{Couple.of((Object)"msg", results.get(0))});
        }
        GDBResponse.ResultRecord.Type type = GDBResponse.ResultRecord.Type.valueOf(ctx.resultClass.getText());
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, type, results, commandToken);
    }

    @Override
    public GDBResponse visitAsyncRecord(@NotNull GdbParser.AsyncRecordContext ctx) {
        String type;
        String prefix;
        if (ctx == null) {
            GDBResponseVisitor.$$$reportNull$$$0(5);
        }
        String commandToken = null;
        if (ctx.commandToken != null) {
            commandToken = ctx.commandToken.getText();
        }
        if (ctx.quirk == null) {
            prefix = ctx.prefix.getText();
            type = ctx.asyncClass.getText();
        } else {
            String prefixAndType = ctx.quirk.getText();
            prefix = prefixAndType.substring(0, 1);
            type = GDBResponseVisitor.extractIdentifier(prefixAndType, 1);
        }
        GDBTuple results = this.doVisitTuple(ctx.result());
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.forPrefix(prefix), type, results, commandToken);
    }

    private static String extractIdentifier(String s, int start) {
        Matcher matcher = ID_PATTERN.matcher(s);
        if (!matcher.find(start)) {
            throw new RuntimeException("Unable to parse: '" + s + "'");
        }
        return matcher.group();
    }

    @Override
    public GDBResponse visitStreamRecord(@NotNull GdbParser.StreamRecordContext ctx) {
        if (ctx == null) {
            GDBResponseVisitor.$$$reportNull$$$0(6);
        }
        String prefix = ctx.prefix.getText();
        return new GDBResponse.StreamRecord(GDBResponse.StreamRecord.Category.forPrefix(prefix), GDBResponseVisitor.getUnquotedString(ctx.cString(), true));
    }

    @NotNull
    private static String getUnquotedString(@NotNull GdbParser.CStringContext stringContext, boolean unescape) {
        if (stringContext == null) {
            GDBResponseVisitor.$$$reportNull$$$0(7);
        }
        String str = stringContext.getText();
        assert (str.length() >= 2) : "at least the enclosing quotes must be there";
        String result = str.substring(1, str.length() - 1);
        String string = unescape ? DebuggerDriver.unescapeString(result) : result;
        if (string == null) {
            GDBResponseVisitor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponseVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponseVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnquotedString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitCnst";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitTuple";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitResultRecord";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitAsyncRecord";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitStreamRecord";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedString";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

