/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.io.ProcessKt;
import com.jetbrains.cidr.execution.debugger.FailedToFindProfilerException;
import com.jetbrains.cidr.execution.debugger.NativeSelfProfilerPathProvider;
import com.jetbrains.cidr.execution.debugger.NativeSelfProfilerPaths;
import com.jetbrains.cidr.execution.debugger.NativeSelfProfilingService;
import com.jetbrains.cidr.execution.debugger.ProfilerExitedWithErrorException;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u000fH\u0002J!\u0010#\u001a\u00020\u00072\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130%\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010&R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService;", "", "<init>", "()V", "context", "Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService$SessionContext;", "registerPidForProfiling", "", "pid", "", "unregisterPidForProfiling", "canStartProfiling", "", "startProfiling", "resultDirectory", "", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "saveSnapshotAndStopProfiling", "Ljava/nio/file/Path;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelProfiling", "getProfilerLocation", "Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilerPaths;", "startProfilingImpl", "Ljava/lang/Process;", "profilerPaths", "output", "handleProcessOutput", "process", "handleProfilingInProgress", "sessionScope", "doneMarker", "sendCommand", "command", "cleanUp", "paths", "", "([Ljava/nio/file/Path;)V", "Companion", "SessionContext", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nNativeSelfProfilingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeSelfProfilingService.kt\ncom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,241:1\n1#2:242\n15#3:243\n*S KotlinDebug\n*F\n+ 1 NativeSelfProfilingService.kt\ncom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService\n*L\n33#1:243\n*E\n"})
public final class NativeSelfProfilingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile SessionContext context;
    @NotNull
    private static final String STOP_COMMAND = "-stop\n";
    @NotNull
    private static final String PING_COMMAND = "-ping\n";
    @NotNull
    private static final String ADD_PID_COMMAND = "-add-pid %s\n";
    @NotNull
    private static final String REMOVE_PID_COMMAND = "-remove-pid %s\n";
    @NotNull
    private static final Logger LOG;

    public final void registerPidForProfiling(long pid) {
        block1: {
            boolean bl;
            boolean bl2 = bl = this.context != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            SessionContext sessionContext = this.context;
            if (sessionContext == null) break block1;
            SessionContext it = sessionContext;
            boolean bl3 = false;
            Process process = it.getProcess();
            String string = ADD_PID_COMMAND;
            Object[] objectArray = new Object[]{pid};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.sendCommand(process, string2);
        }
    }

    public final void unregisterPidForProfiling(long pid) {
        block1: {
            boolean bl;
            boolean bl2 = bl = this.context != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            SessionContext sessionContext = this.context;
            if (sessionContext == null) break block1;
            SessionContext it = sessionContext;
            boolean bl3 = false;
            Process process = it.getProcess();
            String string = REMOVE_PID_COMMAND;
            Object[] objectArray = new Object[]{pid};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.sendCommand(process, string2);
        }
    }

    public final boolean canStartProfiling() {
        return SystemInfo.isWin8OrNewer && this.context == null;
    }

    public final void startProfiling(@NotNull String resultDirectory, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)resultDirectory, (String)"resultDirectory");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        boolean bl = this.canStartProfiling();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        try {
            SessionContext newContext;
            this.context = newContext = new SessionContext(CoroutineScopeKt.childScope$default((CoroutineScope)parentScope, (String)"NativeProfiling", null, (boolean)false, (int)2, null));
            NativeSelfProfilerPaths profilerPaths = this.getProfilerLocation();
            String filename = "Snapshot_" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            Path path = Paths.get(resultDirectory + "\\" + filename + ".etl", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            newContext.setOutput(path);
            Path path2 = Paths.get(resultDirectory + "\\" + filename + ".etl.done", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            newContext.setDoneMarker(path2);
            newContext.setProcess(this.startProfilingImpl(profilerPaths, newContext.getOutput()));
            this.handleProcessOutput(newContext.getProcess(), newContext.getSessionScope());
            newContext.setProfilingScope(this.handleProfilingInProgress(newContext.getSessionScope(), newContext.getProcess(), newContext.getOutput(), newContext.getDoneMarker()));
        }
        catch (Throwable e) {
            LOG.error(e);
            this.cancelProfiling();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object saveSnapshotAndStopProfiling(@NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof saveSnapshotAndStopProfiling.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ NativeSelfProfilingService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveSnapshotAndStopProfiling((Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                snapshotResult = new Ref.ObjectRef();
                v0 = var3_6 = this.context != null;
                if (_Assertions.ENABLED && !var3_6) {
                    var4_7 = "Assertion failed";
                    throw new AssertionError((Object)var4_7);
                }
                NativeSelfProfilingService.LOG.debug("User stopped profiling");
                v1 = this.context;
                if (v1 == null) return snapshotResult.element;
                it = v1;
                $i$a$-let-NativeSelfProfilingService$saveSnapshotAndStopProfiling$2 = false;
                kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)it.getProfilingScope(), null, (int)1, null);
                this.sendCommand(it.getProcess(), "-stop\n");
                $continuation.L$0 = this;
                $continuation.L$1 = snapshotResult;
                $continuation.L$2 = it;
                $continuation.label = 1;
                v2 = ProcessKt.awaitExit((Process)it.getProcess(), (Continuation)$continuation);
                v3 = v2;
                if (v2 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl47
            }
            case 1: {
                $i$a$-let-NativeSelfProfilingService$saveSnapshotAndStopProfiling$2 = false;
                it = (SessionContext)$continuation.L$2;
                snapshotResult = (Ref.ObjectRef)$continuation.L$1;
                this = (NativeSelfProfilingService)$continuation.L$0;
                ** try [egrp 1[TRYBLOCK] [1 : 258->392)] { 
lbl44:
                // 1 sources

                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl47:
                // 2 sources

                errorCode = ((Number)v3).intValue();
                NativeSelfProfilingService.LOG.debug("Profiling finished");
                v4 = new LinkOption[]{};
                if (Files.exists(it.getDoneMarker(), Arrays.copyOf(v4, v4.length))) {
                    snapshotResult.element = it.getOutput();
                    var8_13 = new Path[]{it.getDoneMarker()};
                    this.cleanUp(var8_13);
                    return snapshotResult.element;
                }
                var8_14 = new Path[]{it.getOutput()};
                this.cleanUp(var8_14);
                e = new ProfilerExitedWithErrorException(errorCode);
                NativeSelfProfilingService.LOG.error((Throwable)e);
                throw e;
lbl60:
                // 1 sources

                finally {
                    this.cancelProfiling();
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void cancelProfiling() {
        block2: {
            SessionContext sessionContext = this.context;
            if (sessionContext == null) break block2;
            SessionContext it = sessionContext;
            boolean bl = false;
            try {
                this.sendCommand(it.getProcess(), STOP_COMMAND);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)it.getSessionScope(), null, (int)1, null);
            this.context = null;
        }
    }

    private final NativeSelfProfilerPaths getProfilerLocation() {
        NativeSelfProfilerPaths profilerPaths = NativeSelfProfilerPathProvider.Companion.getProfilerPaths();
        LOG.debug("Self-profiler paths: " + profilerPaths);
        if (profilerPaths == null) {
            throw new FailedToFindProfilerException();
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(profilerPaths.getProfilerLocation(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FailedToFindProfilerException();
        }
        return profilerPaths;
    }

    private final Process startProfilingImpl(NativeSelfProfilerPaths profilerPaths, Path output) {
        String[] stringArray = new String[]{((Object)profilerPaths.getProfilerLocation()).toString(), "-out", ((Object)output).toString(), "-filter"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        if (!((Collection)profilerPaths.getAdditionalProbingPaths()).isEmpty()) {
            commandLine.withEnvironment("JB_ADDITIONAL_PROBING_PATHS", CollectionsKt.joinToString$default((Iterable)profilerPaths.getAdditionalProbingPaths(), (CharSequence)";", null, null, (int)0, null, NativeSelfProfilingService::startProfilingImpl$lambda$4, (int)30, null));
        }
        LOG.debug("Starting profiler: " + commandLine);
        return ExecUtil.sudo((GeneralCommandLine)commandLine, (String)"");
    }

    private final void handleProcessOutput(Process process, CoroutineScope parentScope) {
        BufferedReader bufferedReader = process.inputReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"inputReader(...)");
        NativeSelfProfilingService.handleProcessOutput$readAndLog(parentScope, process, bufferedReader, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)LOG){

            public final void invoke(String p0) {
                ((Logger)this.receiver).debug(p0);
            }
        }));
        BufferedReader bufferedReader2 = process.errorReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader2, (String)"errorReader(...)");
        NativeSelfProfilingService.handleProcessOutput$readAndLog(parentScope, process, bufferedReader2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)LOG){

            public final void invoke(String p0) {
                ((Logger)this.receiver).warn(p0);
            }
        }));
    }

    private final CoroutineScope handleProfilingInProgress(CoroutineScope sessionScope, Process process, Path output, Path doneMarker) {
        CoroutineScope profilingScope = CoroutineScopeKt.childScope$default((CoroutineScope)sessionScope, (String)"NativeProfiling.InProgress", null, (boolean)false, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)profilingScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, this, output, doneMarker, null){
            int label;
            final /* synthetic */ Process $process;
            final /* synthetic */ NativeSelfProfilingService this$0;
            final /* synthetic */ Path $output;
            final /* synthetic */ Path $doneMarker;
            {
                this.$process = $process;
                this.this$0 = $receiver;
                this.$output = $output;
                this.$doneMarker = $doneMarker;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ProcessKt.awaitExit((Process)this.$process, (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        errorCode = ((Number)v0).intValue();
                        var3_4 = new Path[]{this.$output, this.$doneMarker};
                        NativeSelfProfilingService.access$cleanUp(this.this$0, var3_4);
                        this.this$0.cancelProfiling();
                        e = new ProfilerExitedWithErrorException(errorCode);
                        NativeSelfProfilingService.access$getLOG$cp().error((Throwable)e);
                        throw e;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)profilingScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, process, null){
            int label;
            final /* synthetic */ NativeSelfProfilingService this$0;
            final /* synthetic */ Process $process;
            {
                this.this$0 = $receiver;
                this.$process = $process;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                        // 2 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl16
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        NativeSelfProfilingService.access$sendCommand(this.this$0, this.$process, "-ping\n");
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return profilingScope;
    }

    private final void sendCommand(Process process, String command) {
        process.outputWriter().write(command);
        process.outputWriter().flush();
    }

    private final void cleanUp(Path ... paths) {
        for (Path path : paths) {
            Files.deleteIfExists(path);
        }
    }

    private static final CharSequence startProfilingImpl$lambda$4(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)it).toString();
    }

    private static final void handleProcessOutput$readAndLog(CoroutineScope $parentScope, Process $process, BufferedReader reader, Function1<? super String, Unit> logFunc) {
        BuildersKt.launch$default((CoroutineScope)$parentScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($process, reader, logFunc, null){
            int label;
            final /* synthetic */ Process $process;
            final /* synthetic */ BufferedReader $reader;
            final /* synthetic */ Function1<String, Unit> $logFunc;
            {
                this.$process = $process;
                this.$reader = $reader;
                this.$logFunc = $logFunc;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 2 sources

                        while (this.$process.isAlive()) {
                            this.label = 1;
                            v0 = ProcessKt.readLineAsync((BufferedReader)this.$reader, (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if ((text = (String)v0) == null) ** GOTO lbl19
                        this.$logFunc.invoke((Object)("Self-Profiler: " + text));
                        ** GOTO lbl5
lbl19:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ void access$cleanUp(NativeSelfProfilingService $this, Path ... paths) {
        $this.cleanUp(paths);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$sendCommand(NativeSelfProfilingService $this, Process process, String command) {
        $this.sendCommand(process, command);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NativeSelfProfilingService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService$Companion;", "", "<init>", "()V", "STOP_COMMAND", "", "PING_COMMAND", "ADD_PID_COMMAND", "REMOVE_PID_COMMAND", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService;", "intellij.cidr.debugger"})
    @SourceDebugExtension(value={"SMAP\nNativeSelfProfilingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeSelfProfilingService.kt\ncom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,241:1\n40#2,3:242\n*S KotlinDebug\n*F\n+ 1 NativeSelfProfilingService.kt\ncom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService$Companion\n*L\n35#1:242,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeSelfProfilingService getInstance() {
            boolean $i$f$service = false;
            Class<NativeSelfProfilingService> serviceClass$iv = NativeSelfProfilingService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (NativeSelfProfilingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/execution/debugger/NativeSelfProfilingService$SessionContext;", "", "sessionScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getSessionScope", "()Lkotlinx/coroutines/CoroutineScope;", "profilingScope", "getProfilingScope", "setProfilingScope", "process", "Ljava/lang/Process;", "getProcess", "()Ljava/lang/Process;", "setProcess", "(Ljava/lang/Process;)V", "output", "Ljava/nio/file/Path;", "getOutput", "()Ljava/nio/file/Path;", "setOutput", "(Ljava/nio/file/Path;)V", "doneMarker", "getDoneMarker", "setDoneMarker", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.debugger"})
    private static final class SessionContext {
        @NotNull
        private final CoroutineScope sessionScope;
        public CoroutineScope profilingScope;
        public Process process;
        public Path output;
        public Path doneMarker;

        public SessionContext(@NotNull CoroutineScope sessionScope) {
            Intrinsics.checkNotNullParameter((Object)sessionScope, (String)"sessionScope");
            this.sessionScope = sessionScope;
        }

        @NotNull
        public final CoroutineScope getSessionScope() {
            return this.sessionScope;
        }

        @NotNull
        public final CoroutineScope getProfilingScope() {
            CoroutineScope coroutineScope = this.profilingScope;
            if (coroutineScope != null) {
                return coroutineScope;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"profilingScope");
            return null;
        }

        public final void setProfilingScope(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
            this.profilingScope = coroutineScope;
        }

        @NotNull
        public final Process getProcess() {
            Process process = this.process;
            if (process != null) {
                return process;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            return null;
        }

        public final void setProcess(@NotNull Process process) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"<set-?>");
            this.process = process;
        }

        @NotNull
        public final Path getOutput() {
            Path path = this.output;
            if (path != null) {
                return path;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            return null;
        }

        public final void setOutput(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
            this.output = path;
        }

        @NotNull
        public final Path getDoneMarker() {
            Path path = this.doneMarker;
            if (path != null) {
                return path;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneMarker");
            return null;
        }

        public final void setDoneMarker(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
            this.doneMarker = path;
        }

        @NotNull
        public final CoroutineScope component1() {
            return this.sessionScope;
        }

        @NotNull
        public final SessionContext copy(@NotNull CoroutineScope sessionScope) {
            Intrinsics.checkNotNullParameter((Object)sessionScope, (String)"sessionScope");
            return new SessionContext(sessionScope);
        }

        public static /* synthetic */ SessionContext copy$default(SessionContext sessionContext, CoroutineScope coroutineScope, int n, Object object) {
            if ((n & 1) != 0) {
                coroutineScope = sessionContext.sessionScope;
            }
            return sessionContext.copy(coroutineScope);
        }

        @NotNull
        public String toString() {
            return "SessionContext(sessionScope=" + this.sessionScope + ")";
        }

        public int hashCode() {
            return this.sessionScope.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionContext)) {
                return false;
            }
            SessionContext sessionContext = (SessionContext)other;
            return Intrinsics.areEqual((Object)this.sessionScope, (Object)sessionContext.sessionScope);
        }
    }
}

