/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColoredText;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.TextTransferable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrDisasmRegistersKt;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrFrameChildrenContributor;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrameVariables;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRegistersValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrReturnValue;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderBase myUserDataHolder;
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;
    @NotNull
    private final LLFrame myFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    @Nullable
    private final LLValue myReturnValue;
    @Nullable
    private final XSourcePosition mySourcePosition;
    private final boolean myIsUserCode;
    private boolean myShowsRegisters;
    public static final Key<Boolean> THROW_ON_VARIABLES_COLLECTION = Key.create((String)"THROW_ON_VARIABLES_COLLECTION");
    @NotNull
    private final XSourcePosition myDisasmPosition;

    public CidrStackFrame(@NotNull CidrDebugProcess process, @NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause, @Nullable LLValue returnValue) {
        if (process == null) {
            CidrStackFrame.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            CidrStackFrame.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            CidrStackFrame.$$$reportNull$$$0(2);
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.myProcess = process;
        this.myThread = thread;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
        this.myReturnValue = returnValue;
        String file = this.myFrame.getFile();
        this.mySourcePosition = file == null ? null : this.myProcess.createSourcePosition(file, this.myFrame.getHash(), this.myFrame.getLine());
        this.myDisasmPosition = this.myProcess.createDisasmPosition(this.myFrame.getProgramCounter());
        this.myIsUserCode = this.mySourcePosition != null && this.calculateIsUserCode(this.mySourcePosition.getFile());
    }

    private boolean calculateIsUserCode(@NotNull VirtualFile file) {
        if (file == null) {
            CidrStackFrame.$$$reportNull$$$0(3);
        }
        Project project = this.myProcess.getProject();
        return (Boolean)ReadAction.compute(() -> ProjectScope.getProjectScope((Project)project).contains(file));
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(4);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(5);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(6);
        }
        if (value == null) {
            CidrStackFrame.$$$reportNull$$$0(7);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrStackFrame.$$$reportNull$$$0(8);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(9);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        if (cidrDebugProcess == null) {
            CidrStackFrame.$$$reportNull$$$0(10);
        }
        return cidrDebugProcess;
    }

    @NotNull
    public LLThread getThread() {
        LLThread lLThread = this.myThread;
        if (lLThread == null) {
            CidrStackFrame.$$$reportNull$$$0(11);
        }
        return lLThread;
    }

    public long getThreadId() {
        return this.myThread.getId();
    }

    @NotNull
    public LLFrame getFrame() {
        LLFrame lLFrame = this.myFrame;
        if (lLFrame == null) {
            CidrStackFrame.$$$reportNull$$$0(12);
        }
        return lLFrame;
    }

    public int getFrameIndex() {
        return this.myFrame.getIndex();
    }

    @Nullable
    public LLValue getReturnValue() {
        return this.myReturnValue;
    }

    public Object getEqualityObject() {
        return Pair.create((Object)this.myThread.getId(), (Object)this.myFrame.getIndex());
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public boolean hasSourceFile() {
        return this.mySourcePosition != null;
    }

    @NotNull
    public XSourcePosition getDisasmPosition() {
        XSourcePosition xSourcePosition = this.myDisasmPosition;
        if (xSourcePosition == null) {
            CidrStackFrame.$$$reportNull$$$0(13);
        }
        return xSourcePosition;
    }

    public boolean isUserCode() {
        return this.myIsUserCode;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        boolean showModule;
        String module;
        SimpleTextAttributes unknownSymbolAttributes;
        XSourcePosition position;
        if (component == null) {
            CidrStackFrame.$$$reportNull$$$0(14);
        }
        SimpleTextAttributes functionNameAttributes = (position = this.getSourcePosition()) != null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        SimpleTextAttributes simpleTextAttributes = unknownSymbolAttributes = position != null ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES;
        if (this.myFrame.getInlined()) {
            component.append(CidrDebuggerBundle.message("stack.frame.label.inlined", new Object[0]) + " ", SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
        String string = module = (showModule = CidrDebuggerSettings.getInstance().isShowFrameModuleName()) ? this.myFrame.getModule() : null;
        if (module != null) {
            component.append("[" + module + "] ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (this.myFrame.hasSymbolInfo()) {
            if (!Registry.is((String)"cidr.debugger.frameTypeDecorator", (boolean)true)) {
                component.append(this.myFrame.getFunction(), functionNameAttributes);
            } else {
                CidrFrameTypeDecorator decorator = this.getFrameTypeDecorator();
                boolean isPlainTextRendering = component instanceof TextTransferable.ColoredStringBuilder;
                ColoredText coloredText = decorator.getFrameFunctionColoredText(this, functionNameAttributes, !isPlainTextRendering);
                component.append(coloredText);
            }
        } else {
            component.append(CidrDebuggerBundle.message("debug.frames.unknownFunction", new Object[0]), unknownSymbolAttributes);
        }
        if (position != null) {
            component.append(" " + position.getFile().getName() + ":" + (position.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(" " + String.valueOf(this.myFrame.getProgramCounter()), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrStackFrame.$$$reportNull$$$0(15);
        }
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node, this.myProcess.getSession())) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            try {
                this.doComputeChildren(driver, node);
            }
            catch (DebuggerCommandException e) {
                if (!node.isObsolete()) {
                    node.setErrorMessage(e.getMessage());
                }
            }
            catch (ExecutionException e) {
                if (!node.isObsolete()) {
                    node.setErrorMessage(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                }
                throw e;
            }
        });
    }

    private void doComputeChildren(@NotNull DebuggerDriver driver, @NotNull XCompositeNode node) throws DebuggerCommandException, ExecutionException {
        DebuggerDriver.FrameVariables frameVariables;
        XValueChildrenList list;
        if (driver == null) {
            CidrStackFrame.$$$reportNull$$$0(16);
        }
        if (node == null) {
            CidrStackFrame.$$$reportNull$$$0(17);
        }
        if (node.isObsolete()) {
            return;
        }
        CidrStackFrameVariables frameVars = new CidrStackFrameVariables(this.myProcess.getDriverName());
        if (this.mySuspensionCause != null) {
            XValueChildrenList list2 = new XValueChildrenList(1);
            list2.add(new XNamedValue(this.mySuspensionCause.causeType.toDisplayString()){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    node.setPresentation(CidrStackFrame.this.mySuspensionCause.icon, null, CidrStackFrame.this.mySuspensionCause.reason, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "place";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame$1";
                    objectArray[2] = "computePresentation";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            node.addChildren(list2, false);
        }
        boolean disasmOpened = this.isDisasmOpened();
        boolean showInlineRegisters = false;
        if (Registry.is((String)"cidr.debugger.showRegisters") && driver.supportsRegisters() && (CidrDebuggerSettings.getInstance().isShowRegisters() || disasmOpened)) {
            list = new XValueChildrenList(1);
            list.add((XNamedValue)new CidrRegistersValue(this.myProcess, this));
            node.addChildren(list, false);
            this.myShowsRegisters = true;
            if (disasmOpened && Registry.is((String)"cidr.debugger.showInlineRegistersInDisasm")) {
                showInlineRegisters = true;
            }
        }
        if (this.myReturnValue != null) {
            list = new XValueChildrenList(1);
            list.add((XNamedValue)new CidrReturnValue(this.myReturnValue, CidrDebuggerBundle.message("debug.function.return.value", new Object[0]), this.myProcess, null, this));
            node.addChildren(list, false);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VARIABLES_COLLECTION);
        XSourcePosition framePosition = this.getSourcePosition();
        driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().isValuesFilterEnabled());
        if (this.myFrame.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT) {
            List<LLValue> vars = ((LLDBDriver)driver).getVariables(this.myThread.getId(), this.myFrame.getIndex(), true, true);
            frameVariables = new DebuggerDriver.FrameVariables(vars, true);
        } else {
            frameVariables = driver.getFrameVariables(this.myThread, this.myFrame);
        }
        boolean showInlineRegistersFinal = showInlineRegisters;
        List<CidrFrameChildrenContributor> contributors = CidrFrameChildrenContributor.getContributors(this, driver);
        frameVars.startFilterLocalVariables();
        List<LLValue> vars = frameVariables.getVariables();
        CompletableFuture<List<LLValue>> filterLocalVariables = frameVariables.isFiltered() ? CompletableFuture.completedFuture(vars) : this.myProcess.getTypesHelper(this).filterLocalVariables(framePosition, vars, () -> ((XCompositeNode)node).isObsolete());
        filterLocalVariables.whenComplete((filteredVars, t) -> {
            boolean last;
            if (t != null && !(t instanceof CancellationException)) {
                CidrDebuggerLog.LOG.error("Failed to filter local variables", t);
            }
            if (node.isObsolete()) {
                return;
            }
            frameVars.finishFilterLocalVariables();
            boolean bl = last = !showInlineRegistersFinal && contributors.isEmpty();
            if (filteredVars != null) {
                frameVars.addLocalValues((Collection<? extends LLValue>)filteredVars, this.myProcess, framePosition, this, node, last);
            } else {
                vars.forEach(v -> v.setValid(false));
                frameVars.addLocalValues(vars, this.myProcess, framePosition, this, node, last);
            }
            if (showInlineRegistersFinal) {
                CidrDisasmRegistersKt.loadRegistersForDisasm(this, frameVars, node, contributors.isEmpty());
            }
            if (!contributors.isEmpty()) {
                CidrDisasmRegistersKt.loadValuesFromContributors(driver, this, frameVars, node, contributors, true);
            }
        });
    }

    public CidrEvaluator getEvaluator() {
        return CidrDebuggerLanguageSupportManager.getInstance().createEvaluator(this);
    }

    @NotNull
    public CidrFrameTypeDecorator getFrameTypeDecorator() {
        CidrFrameTypeDecorator cidrFrameTypeDecorator = CidrDebuggerLanguageSupportManager.getInstance().createFrameTypeDecorator(this);
        if (cidrFrameTypeDecorator == null) {
            CidrStackFrame.$$$reportNull$$$0(18);
        }
        return cidrFrameTypeDecorator;
    }

    public String toString() {
        return this.myFrame.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CidrStackFrame frame = (CidrStackFrame)((Object)o);
        return this.myProcess.equals(frame.myProcess) && this.myThread.equals(frame.myThread) && this.myFrame.equals(frame.myFrame);
    }

    public int hashCode() {
        return Objects.hash(this.myProcess, this.myThread, this.myFrame);
    }

    public boolean isDisasmOpened() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile file;
            EditorEx editorEx;
            if (!(editor instanceof EditorEx) || !(editorEx = (EditorEx)editor).getGutterComponentEx().isShowing() || (file = editor.getVirtualFile()) == null || file.getFileType() != DisasmFileType.INSTANCE || this.myProcess.fileToMemoryDoc(file) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isShowsRegisters() {
        return this.myShowsRegisters;
    }

    public void setShowsRegisters(boolean showsRegisters) {
        this.myShowsRegisters = showsRegisters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11, 12, 13, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getThread";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisasmPosition";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameTypeDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateIsUserCode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11, 12, 13, 18 -> new IllegalStateException(string);
        };
    }
}

