/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CidrLineGutterDraggableObject
implements GutterDraggableObject {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;

    CidrLineGutterDraggableObject(@NotNull CidrDebugProcess process, @NotNull LLThread thread) {
        if (process == null) {
            CidrLineGutterDraggableObject.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            CidrLineGutterDraggableObject.$$$reportNull$$$0(1);
        }
        this.myProcess = process;
        this.myThread = thread;
    }

    public boolean copy(int line, @Nullable VirtualFile file, int actionId) {
        if (file == null) {
            return false;
        }
        CidrDebuggerUsagesCollector.logExecutionPointWasMovedByDragAndDrop();
        return this.myProcess.jumpToLine(this.myThread, file, line);
    }

    public Cursor getCursor(int line, VirtualFile file, int actionId) {
        this.updateCaretPosition(file, line);
        return super.getCursor(line, file, actionId);
    }

    private void updateCaretPosition(VirtualFile file, int line) {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProcess.getProject()).getSelectedEditor(file);
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "process";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "thread";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrLineGutterDraggableObject";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

