/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XSourceKind;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeUtilsKt;
import com.intellij.xdebugger.mixedMode.XExecutionStackWithNativeThreadId;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrLineGutterIconRenderer;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.StackFilteringContainer;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLMissingThread;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExecutionStack
extends XExecutionStack
implements XExecutionStackWithNativeThreadId {
    @NotNull
    protected final CidrDebugProcess myProcess;
    @NotNull
    protected final LLThread myThread;
    @Nullable
    private volatile CidrStackFrame myTopFrame;
    @Nullable
    protected final CidrSuspensionCause mySuspensionCause;
    @Nullable
    protected final LLValue myReturnValue;
    @NotNull
    private final CidrStackFramesCache myStackFramesCache;
    private boolean myBatchRequests;
    @Nullable
    private LLFrame myPreferableFrameToSelect;

    public CidrExecutionStack(@NotNull CidrDebugProcess process, @NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause suspensionCause, @Nullable LLValue returnValue) {
        if (process == null) {
            CidrExecutionStack.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            CidrExecutionStack.$$$reportNull$$$0(1);
        }
        super(thread.getDisplayName(), CidrExecutionStack.getThreadIcon(thread, current));
        this.myStackFramesCache = new CidrStackFramesCache();
        this.myBatchRequests = true;
        this.myProcess = process;
        this.myThread = thread;
        this.mySuspensionCause = suspensionCause;
        this.myReturnValue = returnValue;
        this.myTopFrame = frame == null || this.myThread instanceof LLMissingThread ? null : this.newFrame(frame);
    }

    public long getNativeThreadId() {
        if (this.myThread instanceof LLMissingThread) {
            return -1L;
        }
        String tid = this.myThread.getTid();
        if (tid == null) {
            return -1L;
        }
        return Long.parseLong(tid);
    }

    @NotNull
    private static Icon getThreadIcon(@NotNull LLThread thread, boolean current) {
        if (thread == null) {
            CidrExecutionStack.$$$reportNull$$$0(2);
        }
        if (thread.isFrozen()) {
            Icon icon = AllIcons.Debugger.Freeze;
            if (icon == null) {
                CidrExecutionStack.$$$reportNull$$$0(3);
            }
            return icon;
        }
        if (current) {
            Icon icon = AllIcons.Debugger.ThreadCurrent;
            if (icon == null) {
                CidrExecutionStack.$$$reportNull$$$0(4);
            }
            return icon;
        }
        Icon icon = AllIcons.Debugger.ThreadSuspended;
        if (icon == null) {
            CidrExecutionStack.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    public LLThread getThread() {
        LLThread lLThread = this.myThread;
        if (lLThread == null) {
            CidrExecutionStack.$$$reportNull$$$0(6);
        }
        return lLThread;
    }

    @Nullable
    public CidrStackFrame getTopFrame() {
        return this.myTopFrame;
    }

    @Nullable
    public CidrSuspensionCause getSuspensionCause() {
        return this.mySuspensionCause;
    }

    public void renewTopFrame() {
        CidrStackFrame topFrame = this.myTopFrame;
        if (topFrame != null) {
            this.myTopFrame = this.newFrame(topFrame.getFrame());
        }
    }

    public void setPreferableFrameToSelect(@Nullable LLFrame frame) {
        this.myPreferableFrameToSelect = frame;
    }

    public void computeStackFrames(int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
        int firstFrameIndexForLoading;
        Object proxyContainer;
        if (this.myThread instanceof LLMissingThread) {
            container.addStackFrames(Collections.emptyList(), true);
            return;
        }
        boolean filteringSupported = this.myProcess.isLibraryFrameFilterSupported();
        boolean filteringTurnedOff = XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames();
        boolean filterOutLibraryFrames = filteringSupported && !filteringTurnedOff && XMixedModeUtilsKt.getCanFilterFramesMixedModeAware((XDebugProcess)this.myProcess);
        Object object = proxyContainer = filterOutLibraryFrames ? new StackFilteringContainer(this, container, firstFrameIndex) : container;
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(container, this.myProcess.getSession())) {
            return;
        }
        int n = firstFrameIndexForLoading = filterOutLibraryFrames ? 0 : firstFrameIndex;
        if (this.myBatchRequests) {
            this.doComputeStackFramesWithBatching(firstFrameIndexForLoading, (XExecutionStack.XStackFrameContainer)proxyContainer);
        } else {
            this.doComputeStackFrames(firstFrameIndexForLoading, (XExecutionStack.XStackFrameContainer)proxyContainer);
        }
    }

    private static void addStackFramesToContainer(@NotNull XExecutionStack.XStackFrameContainer container, @NotNull List<CidrStackFrame> frames2, @Nullable XStackFrame toSelect, boolean hasMore) {
        if (container == null) {
            CidrExecutionStack.$$$reportNull$$$0(7);
        }
        if (frames2 == null) {
            CidrExecutionStack.$$$reportNull$$$0(8);
        }
        if (container instanceof XStackFrameContainerEx) {
            ((XStackFrameContainerEx)container).addStackFrames(frames2, toSelect, !hasMore);
        } else {
            container.addStackFrames(frames2, !hasMore);
        }
    }

    private void doComputeStackFramesWithBatching(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        this.myProcess.postCommand(driver -> {
            try {
                boolean hasMore;
                boolean repeat;
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_FRAME_COLLECTION);
                ArrayList<CidrStackFrame> result = new ArrayList<CidrStackFrame>();
                CidrStackFrame toSelect = null;
                int currentFrom = originalFrom;
                int currentBatchSize = 100;
                do {
                    if (container.isObsolete()) {
                        return;
                    }
                    repeat = false;
                    DebuggerDriver.ResultList<LLFrame> framesResult = this.myStackFramesCache.getFrames(driver, currentFrom, currentBatchSize, currentFrom == 0);
                    CidrStackFrame top = this.myTopFrame;
                    result.ensureCapacity(result.size() + framesResult.list.size());
                    for (int i = 0; i < framesResult.list.size(); ++i) {
                        CidrStackFrame frame;
                        if (container.isObsolete()) {
                            return;
                        }
                        if (currentFrom == 0 && i == 0) {
                            if (top != null) {
                                frame = top;
                            } else {
                                frame = top = this.newFrame((LLFrame)framesResult.list.get(i));
                                this.myTopFrame = top;
                            }
                        } else {
                            frame = this.newFrame((LLFrame)framesResult.list.get(i));
                        }
                        result.add(frame);
                        if (!frame.getFrame().equals(this.myPreferableFrameToSelect)) continue;
                        toSelect = frame;
                    }
                    hasMore = framesResult.hasMore;
                    if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame() || toSelect != null || (toSelect = (CidrStackFrame)((Object)((Object)ContainerUtil.find(result, CidrStackFrame::hasSourceFile)))) != null || !hasMore || framesResult.list.size() >= currentBatchSize) continue;
                    currentFrom = framesResult.list.size();
                    currentBatchSize -= currentFrom;
                    repeat = true;
                } while (repeat);
                CidrExecutionStack.addStackFramesToContainer(container, result, toSelect, hasMore);
                if (hasMore && !container.isObsolete()) {
                    this.doComputeStackFramesWithBatching(currentFrom + result.size(), container);
                }
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private void doComputeStackFrames(int originalFrom, XExecutionStack.XStackFrameContainer container) {
        this.myProcess.postCommand(driver -> {
            try {
                boolean hasMore;
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_FRAME_COLLECTION);
                ArrayList<CidrStackFrame> result = new ArrayList<CidrStackFrame>();
                CidrStackFrame toSelect = null;
                int currentFrom = originalFrom;
                do {
                    if (container.isObsolete()) {
                        return;
                    }
                    DebuggerDriver.ResultList<LLFrame> framesResult = this.myStackFramesCache.getFrames(driver, currentFrom, 100, false);
                    CidrStackFrame top = this.myTopFrame;
                    result.ensureCapacity(result.size() + framesResult.list.size());
                    for (int i = 0; i < framesResult.list.size(); ++i) {
                        CidrStackFrame frame;
                        if (container.isObsolete()) {
                            return;
                        }
                        if (currentFrom == 0 && i == 0) {
                            if (top == null) {
                                this.myTopFrame = top = this.newFrame((LLFrame)framesResult.list.get(i));
                            }
                            frame = top;
                        } else {
                            frame = this.newFrame((LLFrame)framesResult.list.get(i));
                        }
                        result.add(frame);
                        if (!frame.getFrame().equals(this.myPreferableFrameToSelect)) continue;
                        toSelect = frame;
                    }
                    hasMore = framesResult.hasMore;
                    currentFrom = framesResult.list.size();
                    if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame() || toSelect != null) continue;
                    toSelect = (CidrStackFrame)((Object)((Object)ContainerUtil.find(result, CidrStackFrame::hasSourceFile)));
                } while (hasMore);
                CidrExecutionStack.addStackFramesToContainer(container, result, toSelect, false);
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private boolean shouldSelectDisasmFrame() {
        return this.mySuspensionCause == null || ((XDebugSessionImpl)this.myProcess.getSession()).getCurrentSourceKind() == XSourceKind.ALTERNATIVE;
    }

    @NotNull
    protected CidrStackFrame newFrame(@NotNull LLFrame frame) {
        if (frame == null) {
            CidrExecutionStack.$$$reportNull$$$0(9);
        }
        return new CidrStackFrame(this.myProcess, this.myThread, frame, this.mySuspensionCause, frame.getIndex() == 0 ? this.myReturnValue : null);
    }

    @Nullable
    public GutterIconRenderer getExecutionLineIconRenderer() {
        return this.myProcess.supportsJumpToLine() ? new CidrLineGutterIconRenderer(this.myProcess, this.myThread) : super.getExecutionLineIconRenderer();
    }

    public String toString() {
        return this.myThread.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CidrExecutionStack stack = (CidrExecutionStack)((Object)o);
        return this.myProcess.equals(stack.myProcess) && this.myThread.equals(stack.myThread);
    }

    public int hashCode() {
        return Objects.hash(this.myProcess, this.myThread);
    }

    public void setRequestsBatching(boolean enable) {
        this.myBatchRequests = enable;
    }

    @Nullable
    public LLValue getReturnValue() {
        return this.myReturnValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrExecutionStack";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrExecutionStack";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThreadIcon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addStackFramesToContainer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newFrame";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private class CidrStackFramesCache {
        @NotNull
        private final List<LLFrame> myFrames = new ArrayList<LLFrame>();
        private boolean myHasMore = true;

        private CidrStackFramesCache() {
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull DebuggerDriver driver, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            if (driver == null) {
                CidrStackFramesCache.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"cidr.debugger.cache.callstacks", (boolean)true)) {
                DebuggerDriver.ResultList<LLFrame> resultList = driver.getFrames(CidrExecutionStack.this.myThread, from, count, untilFirstLineWithCode);
                if (resultList == null) {
                    CidrStackFramesCache.$$$reportNull$$$0(1);
                }
                return resultList;
            }
            if (untilFirstLineWithCode) {
                this.cacheUntil(driver, from, false);
                if (this.myFrames.size() < from + count) {
                    for (int i = from; i < this.myFrames.size(); ++i) {
                        if (!this.myFrames.get(i).hasDebugInfo()) continue;
                        return this.createResult(from, this.myFrames.size());
                    }
                }
            }
            this.cacheUntil(driver, from + count, untilFirstLineWithCode);
            return this.createResult(from, Integer.min(from + count, this.myFrames.size()));
        }

        private void cacheUntil(@NotNull DebuggerDriver driver, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
            if (driver == null) {
                CidrStackFramesCache.$$$reportNull$$$0(2);
            }
            if (!this.myHasMore) {
                return;
            }
            if (this.myFrames.size() >= count) {
                return;
            }
            DebuggerDriver.ResultList<LLFrame> result = driver.getFrames(CidrExecutionStack.this.myThread, this.myFrames.size(), count - this.myFrames.size(), untilFirstLineWithCode);
            this.myFrames.addAll(result.list);
            this.myHasMore = result.hasMore;
        }

        @NotNull
        private DebuggerDriver.ResultList<LLFrame> createResult(int from, int to) {
            return new DebuggerDriver.ResultList<LLFrame>(this.myFrames.subList(from, to), this.myHasMore || this.myFrames.size() > to);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrExecutionStack$CidrStackFramesCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrExecutionStack$CidrStackFramesCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFrames";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "cacheUntil";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

