/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.debugger.TimelineElement;
import com.jetbrains.cidr.execution.debugger.TimelineElementDetailsConsole;
import com.jetbrains.cidr.execution.debugger.TimelineModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineContent;", "Ljavax/swing/JComponent;", "model", "Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "detailsView", "Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/TimelineModel;Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;)V", "getModel", "()Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "getDetailsView", "()Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "getScrollPane", "()Lcom/intellij/ui/components/JBScrollPane;", "setScrollPane", "(Lcom/intellij/ui/components/JBScrollPane;)V", "paintComponent", "", "graphics", "Ljava/awt/Graphics;", "Companion", "MyMouseListener", "intellij.cidr.debugger"})
public final class CidrDebugEventsTimelineContent
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimelineModel model;
    @NotNull
    private final TimelineElementDetailsConsole detailsView;
    @Nullable
    private JBScrollPane scrollPane;
    public static final int MARGIN_X = 10;
    public static final int MARGIN_TOP = 0;
    private static final int SECOND_WIDTH = 100;
    @NotNull
    private static final Font FONT;
    @NotNull
    private static final BasicStroke DASH_STROKE;
    @NotNull
    private static final BasicStroke NORMAL_STROKE;

    public CidrDebugEventsTimelineContent(@NotNull TimelineModel model, @NotNull TimelineElementDetailsConsole detailsView) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)detailsView), (String)"detailsView");
        this.model = model;
        this.detailsView = detailsView;
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseListener());
        this.model.addUpdateListener((Function0<Unit>)((Function0)() -> CidrDebugEventsTimelineContent._init_$lambda$0(this)));
    }

    @NotNull
    public final TimelineModel getModel() {
        return this.model;
    }

    @NotNull
    public final TimelineElementDetailsConsole getDetailsView() {
        return this.detailsView;
    }

    @Nullable
    public final JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final void setScrollPane(@Nullable JBScrollPane jBScrollPane) {
        this.scrollPane = jBScrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@Nullable Graphics graphics) {
        super.paintComponent(graphics);
        Graphics graphics2 = graphics;
        Graphics graphics3 = graphics2 != null ? graphics2.create() : null;
        Graphics2D graphics2D = graphics3 instanceof Graphics2D ? (Graphics2D)graphics3 : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g = graphics2D;
        try {
            long endMs;
            UISettings.Companion.setupAntialiasing((Graphics)g);
            g.setFont(FONT);
            if (this.model.getDebugSessionEvents().isEmpty() && this.model.getElements().isEmpty()) {
                g.setColor((Color)JBColor.GRAY);
                g.drawString("Debug session has not started yet", 10, 20);
                return;
            }
            long startMs = this.model.getStartTime();
            if (startMs >= (endMs = this.model.getMaxTime())) {
                return;
            }
            int seconds = this.model.getSecondsCount();
            int rowHeight = Companion.rowHeight(this);
            int totalEventHeight = Companion.contentHeight(this.model, rowHeight);
            Color lineColor = Companion.getLineColor();
            g.setColor(lineColor);
            g.setStroke(DASH_STROKE);
            int s = 0;
            if (s <= seconds) {
                while (true) {
                    int secondStartOffset = Companion.secondStartOffsetX(this.model, s);
                    g.drawLine(secondStartOffset, 0, secondStartOffset, 0 + totalEventHeight);
                    if (s == seconds) break;
                    ++s;
                }
            }
            g.setStroke(NORMAL_STROKE);
            int offsetY = 0;
            Iterator<TimelineElement> iterator = this.model.getElements().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<TimelineElement> iterator2 = iterator;
            while (iterator2.hasNext()) {
                TimelineElement event;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                IntRange rangeX = Companion.elementRangeX(this.model, event);
                g.setColor(lineColor);
                g.drawLine(10, offsetY + rowHeight, Companion.secondStartOffsetX(this.model, seconds), offsetY + rowHeight);
                g.setColor(Intrinsics.areEqual((Object)event, (Object)this.model.getSelectedElement()) ? (Color)JBColor.BLUE : (event.isEmptyPlaceholder() ? (Color)JBColor.GRAY : (Color)JBColor.RED));
                g.fillRect(rangeX.getFirst(), offsetY, rangeX.getLast() - rangeX.getFirst(), rowHeight);
                offsetY += rowHeight;
            }
            this.setPreferredSize(new Dimension(Companion.contentWidth(this.model), 0 + totalEventHeight));
        }
        finally {
            g.dispose();
        }
    }

    private static final Unit _init_$lambda$0(CidrDebugEventsTimelineContent this$0) {
        JScrollBar scrollBar;
        JBScrollPane jBScrollPane = this$0.scrollPane;
        JScrollBar jScrollBar = scrollBar = jBScrollPane != null ? jBScrollPane.getVerticalScrollBar() : null;
        double scrollPercent = scrollBar == null ? 0.0 : (scrollBar.isVisible() ? (double)scrollBar.getValue() + (double)scrollBar.getVisibleAmount() * 1.0 / (double)scrollBar.getMaximum() : 1.0);
        this$0.revalidate();
        this$0.repaint();
        if (scrollPercent >= 0.9) {
            this$0.scrollRectToVisible(new Rectangle(Companion.contentWidth(this$0.model), Companion.contentHeight(this$0.model, Companion.rowHeight(this$0)), 1, 1));
        }
        return Unit.INSTANCE;
    }

    static {
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont(...)");
        FONT = font;
        int n = 0;
        float[] fArray = new float[2];
        float f = 10.0f;
        int n2 = 0;
        int n3 = 0;
        float f2 = 1.0f;
        while (n < 2) {
            int n4 = n++;
            fArray[n4] = 5.0f;
        }
        float f3 = 0.0f;
        float[] fArray2 = fArray;
        float f4 = f;
        int n5 = n2;
        int n6 = n3;
        float f5 = f2;
        DASH_STROKE = new BasicStroke(f5, n6, n5, f4, fArray2, f3);
        NORMAL_STROKE = new BasicStroke(1.0f);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J%\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001bJ\u0016\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0005J\u0016\u0010$\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineContent$Companion;", "", "<init>", "()V", "MARGIN_X", "", "MARGIN_TOP", "SECOND_WIDTH", "FONT", "Ljava/awt/Font;", "Lorg/jetbrains/annotations/NotNull;", "getFONT", "()Ljava/awt/Font;", "DASH_STROKE", "Ljava/awt/BasicStroke;", "NORMAL_STROKE", "contentHeight", "model", "Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "rowHeight", "contentWidth", "component", "Ljavax/swing/JComponent;", "rowIndex", "y", "(Lcom/jetbrains/cidr/execution/debugger/TimelineModel;Ljavax/swing/JComponent;I)Ljava/lang/Integer;", "elementAtY", "Lcom/jetbrains/cidr/execution/debugger/TimelineElement;", "elementRangeX", "Lkotlin/ranges/IntRange;", "event", "millisStartOffsetX", "time", "", "secondStartOffsetX", "second", "secondStartTime", "getLineColor", "Ljava/awt/Color;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font getFONT() {
            return FONT;
        }

        public final int contentHeight(@NotNull TimelineModel model, int rowHeight) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return rowHeight * (model.getElements().size() + 1);
        }

        public final int contentWidth(@NotNull TimelineModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return 20 + model.getSecondsCount() * 100;
        }

        public final int rowHeight(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return component.getFontMetrics(this.getFONT()).getHeight();
        }

        @Nullable
        public final Integer rowIndex(@NotNull TimelineModel model, @NotNull JComponent component, int y) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            int rowHeight = this.rowHeight(component);
            int row = y / rowHeight;
            boolean bl = 0 <= row ? row < model.getElements().size() : false;
            if (bl) {
                return row;
            }
            return null;
        }

        @Nullable
        public final TimelineElement elementAtY(@NotNull TimelineModel model, @NotNull JComponent component, int y) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            int rowHeight = this.rowHeight(component);
            int row = y / rowHeight;
            boolean bl = 0 <= row ? row < model.getElements().size() : false;
            if (bl) {
                return model.getElements().get(row);
            }
            return null;
        }

        @NotNull
        public final IntRange elementRangeX(@NotNull TimelineModel model, @NotNull TimelineElement event) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            int startX = this.millisStartOffsetX(model, event.getStartTime());
            int endX = this.millisStartOffsetX(model, TimelineModel.finishTimeOrNow$default(model, event, null, 2, null));
            return new IntRange(startX, Math.max(endX, startX + 1));
        }

        public final int millisStartOffsetX(@NotNull TimelineModel model, long time) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            double secondsFromStart = (double)(time - model.getStartTime()) / 1000.0;
            return 10 + (int)(secondsFromStart * (double)100);
        }

        public final int secondStartOffsetX(@NotNull TimelineModel model, int second) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return this.millisStartOffsetX(model, this.secondStartTime(model, second));
        }

        public final long secondStartTime(@NotNull TimelineModel model, int second) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return model.getStartTime() + (long)(second * 1000);
        }

        @NotNull
        public final Color getLineColor() {
            Color color;
            if (JBColor.isBright()) {
                JBColor jBColor = JBColor.LIGHT_GRAY;
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"LIGHT_GRAY");
                color = (Color)jBColor;
            } else {
                JBColor jBColor = JBColor.GRAY;
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
                color = (Color)jBColor;
            }
            return color;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineContent$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "Ljava/awt/event/MouseMotionListener;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineContent;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseMoved", "intellij.cidr.debugger"})
    public final class MyMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TimelineElement element = Companion.elementAtY(CidrDebugEventsTimelineContent.this.getModel(), CidrDebugEventsTimelineContent.this, e.getY());
                if (element == null) break block2;
                IntRange rangeX = Companion.elementRangeX(CidrDebugEventsTimelineContent.this.getModel(), element);
                int n = rangeX.getFirst() - 5;
                int n2 = rangeX.getLast() + 5;
                int n3 = e.getX();
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (bl) {
                    CidrDebugEventsTimelineContent.this.getModel().setSelectedElement(element);
                    CidrDebugEventsTimelineContent.this.getDetailsView().showDetails(element);
                    JBScrollPane jBScrollPane = CidrDebugEventsTimelineContent.this.getScrollPane();
                    if (jBScrollPane != null) {
                        jBScrollPane.repaint();
                    }
                }
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TimelineElement element = Companion.elementAtY(CidrDebugEventsTimelineContent.this.getModel(), CidrDebugEventsTimelineContent.this, e.getY());
            if (element != null) {
                IntRange rangeX = Companion.elementRangeX(CidrDebugEventsTimelineContent.this.getModel(), element);
                int n = rangeX.getFirst() - 5;
                int n2 = rangeX.getLast() + 5;
                int n3 = e.getX();
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (bl) {
                    UIUtil.setCursor((Component)CidrDebugEventsTimelineContent.this, (Cursor)Cursor.getPredefinedCursor(12));
                    return;
                }
            }
            UIUtil.setCursor((Component)CidrDebugEventsTimelineContent.this, (Cursor)Cursor.getPredefinedCursor(0));
        }
    }
}

