/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssExpandedValue;
import com.intellij.psi.css.impl.util.table.CssFontFamilyValue;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import java.awt.GraphicsEnvironment;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class CssFontFamilyDescriptor
extends CssPropertyDescriptorImpl {
    private final CssPropertyValueImpl myInternalValue;

    public CssFontFamilyDescriptor(@NotNull String propertyName, CssPropertyInfo @NotNull [] infos) {
        if (propertyName == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(1);
        }
        super(propertyName, infos);
        this.myInternalValue = CssExpandedValue.createGenericFontFamilyValue();
    }

    @Override
    public void setValue(@NotNull CssPropertyValueImpl value) {
        if (value == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(2);
        }
        super.setValue(value);
    }

    @Override
    public Object @NotNull [] getVariants(@NotNull PsiElement contextElement) {
        CssDeclaration cssDeclaration;
        CssTermList termList;
        if (contextElement == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(3);
        }
        CssTermList cssTermList = termList = (cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)contextElement, CssDeclaration.class)) != null ? cssDeclaration.getValue() : null;
        if (termList != null) {
            PsiLanguageInjectionHost injectionHost;
            CssElement topmostParentOfType;
            boolean lastComma = false;
            PsiElement[] children = termList.getChildren();
            for (int i = children.length - 1; i >= 0 && !(children[i] instanceof CssTerm); --i) {
                if (!(children[i] instanceof LeafElement) || !",".equals(children[i].getText())) continue;
                lastComma = true;
                break;
            }
            HashSet<String> exclude = new HashSet<String>();
            CssPropertyValueImpl internalValue = this.getInternalValue();
            for (CssPropertyValue value : internalValue.getChildren()) {
                Object excludeValue = value.getValue();
                if (!(excludeValue instanceof String)) continue;
                exclude.add((String)excludeValue);
            }
            CssFontFamilyValue fontFamilyValue = new CssFontFamilyValue();
            boolean wrappedWithDoubleQuote = false;
            if (!(contextElement.getContainingFile() instanceof StylesheetFile) && (topmostParentOfType = (CssElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)contextElement, CssElement.class)) != null) {
                PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)topmostParentOfType);
                boolean bl = wrappedWithDoubleQuote = prev != null && StringUtil.endsWithChar((CharSequence)prev.getText(), (char)'\"');
            }
            if ((injectionHost = InjectedLanguageUtil.findInjectionHost((PsiElement)contextElement)) != null && StringUtil.startsWithChar((CharSequence)injectionHost.getText(), (char)'\"') && StringUtil.endsWithChar((CharSequence)injectionHost.getText(), (char)'\"')) {
                wrappedWithDoubleQuote = true;
            }
            String quote = wrappedWithDoubleQuote ? "'" : "\"";
            HashSet fontNames = new HashSet();
            Collections.addAll(fontNames, CssFontFamilyDescriptor.getPopularFontFamilies(contextElement, termList));
            Collections.addAll(fontNames, CssFontFamilyDescriptor.getPopularFontPacks(termList));
            Collections.addAll(fontNames, CssFontFamilyDescriptor.getSystemFontFamilies());
            for (String s : fontNames) {
                if (exclude.contains(s)) continue;
                fontFamilyValue.addChild(CssFontFamilyDescriptor.createPropertyValue(quote, s));
            }
            if (lastComma) {
                Object[] objectArray = CssFontFamilyDescriptor.gatherVariants(contextElement, fontFamilyValue, internalValue);
                if (objectArray == null) {
                    CssFontFamilyDescriptor.$$$reportNull$$$0(4);
                }
                return objectArray;
            }
            Object[] objectArray = CssFontFamilyDescriptor.gatherVariants(contextElement, fontFamilyValue, internalValue, new CssPropertyValueImpl("inherit"));
            if (objectArray == null) {
                CssFontFamilyDescriptor.$$$reportNull$$$0(5);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(6);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public static String[] getSystemFontFamilies() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return graphicsEnvironment.getAvailableFontFamilyNames();
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static CssPropertyValueImpl createPropertyValue(final String quote, String fontName) {
        LookupElementBuilder builder = LookupElementBuilder.create((String)fontName).withLookupString(StringUtil.toLowerCase((String)fontName));
        if (StringUtil.containsChar((String)fontName, (char)' ') && !StringUtil.containsAnyChar((String)fontName, (String)"'\",")) {
            LookupElementBuilder v = builder.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Document document = context.getDocument();
                    int offset = context.getEditor().getCaretModel().getOffset();
                    document.insertString(offset, (CharSequence)quote);
                    int startOffset = context.getStartOffset();
                    document.insertString(startOffset, (CharSequence)quote);
                    context.getEditor().getCaretModel().moveToOffset(offset + 2);
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor$1";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return new CssPropertyValueImpl(v);
        }
        return new CssPropertyValueImpl(builder);
    }

    public static String[] getPopularFontFamilies(PsiElement context, @NotNull CssTermList termList) {
        if (termList == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(7);
        }
        HashSet<String> values = new HashSet<String>();
        for (PsiElement child : termList.getChildren()) {
            String text;
            PsiElement originalChild = CompletionUtil.getOriginalElement((PsiElement)child);
            if (!(originalChild instanceof CssTerm) || (text = originalChild.getText()) == null) continue;
            values.add(StringUtil.toLowerCase((String)StringUtil.unquoteString((String)text)));
        }
        String currentValue = CssFontFamilyDescriptor.getCurrentValue(context);
        HashSet result = new HashSet();
        Processor collectProcessor = s -> {
            String key;
            String keyLowerCase;
            CssIndexValue type = CssIndexValue.keyType(s);
            if (!(type != CssIndexValue.FONT_FAMILY || values.contains(keyLowerCase = StringUtil.toLowerCase((String)(key = CssIndexValue.realKey(s)))) || key.isEmpty() || currentValue != null && StringUtil.toLowerCase((String)currentValue).startsWith(keyLowerCase))) {
                result.remove(StringUtil.decapitalize((String)key));
                if (!result.contains(StringUtil.capitalize((String)key))) {
                    result.add(key);
                }
            }
            return true;
        };
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement(termList);
        CssIndexUtil.processKeysInScope(CssIndex.CSS_INDEX, termList.getProject(), scope, (Processor<? super String>)collectProcessor);
        return ArrayUtilRt.toStringArray(result);
    }

    public static String[] getPopularFontPacks(@NotNull CssTermList termList) {
        CssTermList originalTermList;
        if (termList == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(8);
        }
        String currentValue = (originalTermList = (CssTermList)CompletionUtil.getOriginalElement((PsiElement)termList)) != null ? originalTermList.getText().trim() : "";
        HashSet result = new HashSet();
        Processor collectProcessor = s -> {
            CssIndexValue type = CssIndexValue.keyType(s);
            if (type == CssIndexValue.FONT_FAMILY_PACK) {
                String key = CssIndexValue.realKey(s);
                String keyLowerCase = StringUtil.toLowerCase((String)key);
                if (!key.isEmpty() && !StringUtil.toLowerCase((String)currentValue).startsWith(keyLowerCase)) {
                    result.add(key);
                }
            }
            return true;
        };
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement(termList);
        CssIndexUtil.processKeysInScope(CssIndex.CSS_INDEX, termList.getProject(), scope, (Processor<? super String>)collectProcessor);
        return ArrayUtilRt.toStringArray(result);
    }

    private static String getCurrentValue(PsiElement context) {
        String currentValue = context instanceof CssString ? ((CssString)context).getValue() : (context instanceof LeafElement && ((LeafElement)context).getElementType() == CssElementTypes.CSS_IDENT ? context.getText() : null);
        return currentValue;
    }

    protected CssPropertyValueImpl getInternalValue() {
        return this.myInternalValue;
    }

    @Override
    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            CssFontFamilyDescriptor.$$$reportNull$$$0(9);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPopularFontFamilies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPopularFontPacks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

