/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.ColumnInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CoverageViewExtension {
    protected final Project myProject;
    protected final CoverageSuitesBundle mySuitesBundle;
    protected final CoverageViewManager.StateBean myStateBean;
    protected final CoverageDataManager myCoverageDataManager;

    @Deprecated
    public CoverageViewExtension(@NotNull Project project, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        if (project == null) {
            CoverageViewExtension.$$$reportNull$$$0(0);
        }
        this(project, suitesBundle);
    }

    public CoverageViewExtension(@NotNull Project project, CoverageSuitesBundle suitesBundle) {
        if (project == null) {
            CoverageViewExtension.$$$reportNull$$$0(1);
        }
        assert (!project.isDefault()) : "Should not run coverage for default project";
        this.myProject = project;
        this.mySuitesBundle = suitesBundle;
        this.myStateBean = CoverageViewManager.getInstance(this.myProject).getStateBean();
        this.myCoverageDataManager = CoverageDataManager.getInstance(this.myProject);
    }

    @Nullable
    public abstract String getPercentage(int var1, @NotNull AbstractTreeNode<?> var2);

    public abstract @Unmodifiable List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode<?> var1);

    public abstract ColumnInfo[] createColumnInfos();

    @Nullable
    public abstract PsiElement getParentElement(PsiElement var1);

    @NotNull
    public abstract AbstractTreeNode<?> createRootNode();

    void onRootReset() {
    }

    @ApiStatus.Internal
    public boolean hasChildren(AbstractTreeNode<?> node) {
        return !node.getChildren().isEmpty();
    }

    @ApiStatus.Internal
    public boolean hasFullyCoveredNodes() {
        return false;
    }

    public boolean canSelectInCoverageView(Object object) {
        return object instanceof VirtualFile && PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) != null;
    }

    @ApiStatus.Internal
    @Nullable
    public PsiElement getElementToSelect(Object object) {
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return object instanceof VirtualFile ? PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) : null;
    }

    @ApiStatus.Internal
    @Nullable
    protected VirtualFile getVirtualFile(Object object) {
        if (object instanceof PsiElement) {
            if (object instanceof PsiDirectory) {
                return ((PsiDirectory)object).getVirtualFile();
            }
            PsiFile containingFile = ((PsiElement)object).getContainingFile();
            if (containingFile != null) {
                return containingFile.getVirtualFile();
            }
            return null;
        }
        return object instanceof VirtualFile ? (VirtualFile)object : null;
    }

    @ApiStatus.Internal
    public boolean supportFlattenPackages() {
        return false;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> createExtraToolbarActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            CoverageViewExtension.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getElementsName() {
        return CoverageBundle.message("coverage.files", new Object[0]);
    }

    public String getElementsCapitalisedName() {
        return CoverageBundle.message("coverage.files.capitalised", new Object[0]);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public List<AbstractTreeNode<?>> createTopLevelNodes() {
        List<AbstractTreeNode<?>> list = Collections.emptyList();
        if (list == null) {
            CoverageViewExtension.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Deprecated
    @Nullable
    public String getSummaryForNode(@NotNull AbstractTreeNode<?> ignoredNode) {
        if (ignoredNode == null) {
            CoverageViewExtension.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public String getSummaryForRootNode(@NotNull AbstractTreeNode<?> ignoredNode) {
        if (ignoredNode == null) {
            CoverageViewExtension.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageViewExtension";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageViewExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopLevelNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSummaryForNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSummaryForRootNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

