/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.liveEdit.protocol.ScriptLiveChangeResult;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.liveEdit.InSingleFileBasedSynchronizer;
import com.jetbrains.liveEdit.JavaScriptSynchronizer;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.PsiSynchronizer;
import com.jetbrains.liveEdit.update.ApplicationUpdaterKt;
import com.jetbrains.liveEdit.update.EffectiveFileScriptProcessor;
import com.jetbrains.liveEdit.update.FileScriptProcessor;
import com.jetbrains.liveEdit.update.RestartRequiredNotificationItem;
import com.jetbrains.liveEdit.update.SetSourceExecutor;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateResult;
import com.jetbrains.liveEdit.update.UpdateScriptResult;
import com.jetbrains.liveEdit.update.UpdateState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ \u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\"\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018JD\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J@\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0002JC\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b&J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0016\u0010)\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u000eJ\u000e\u0010+\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010,\u001a\u00020%2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010-\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/liveEdit/update/ApplicationUpdater;", "", "<init>", "()V", "processToState", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/xdebugger/XDebugProcess;", "Lcom/jetbrains/liveEdit/update/UpdateState;", "updateScripts", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/liveEdit/update/UpdateResult;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "notifyIfHasIncorrectFiles", "", "incorrectFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "autoTriggeredUpdate", "result", "Lcom/jetbrains/liveEdit/update/EffectiveFileScriptProcessor;", "vm", "Lorg/jetbrains/debugger/Vm;", "synchronizer", "Lcom/jetbrains/liveEdit/InSingleFileBasedSynchronizer;", "files", "", "setSourceExecutor", "Lcom/jetbrains/liveEdit/update/SetSourceExecutor;", "collectPendingFiles", "doUpdate", "getState", "sources", "", "", "(Ljava/util/List;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;[Ljava/lang/CharSequence;)Lorg/jetbrains/concurrency/Promise;", "restartOrNotify", "", "restartOrNotify$intellij_js_liveEdit", "markAsRestartRequired", "Lcom/jetbrains/liveEdit/update/RestartRequiredNotificationItem;", "checkIsBlackListed", "notify", "scheduleUpdateScripts", "schedule", "clearUpdateState", "remove", "MyFileScriptProcessor", "intellij.js.liveEdit"})
@SourceDebugExtension(value={"SMAP\nApplicationUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationUpdater.kt\ncom/jetbrains/liveEdit/update/ApplicationUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,536:1\n1557#2:537\n1628#2,3:538\n*S KotlinDebug\n*F\n+ 1 ApplicationUpdater.kt\ncom/jetbrains/liveEdit/update/ApplicationUpdater\n*L\n206#1:537\n206#1:538,3\n*E\n"})
public final class ApplicationUpdater {
    @NotNull
    private final ConcurrentHashMap<XDebugProcess, UpdateState> processToState = new ConcurrentHashMap();

    @NotNull
    public final Promise<UpdateResult> updateScripts(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (this.checkIsBlackListed((XDebugProcess)debugProcess, true)) {
            return Promises.rejectedPromise((String)"blacklisted");
        }
        Vm vm = debugProcess.getMainVm();
        if (vm == null) {
            return Promises.resolvedPromise((Object)UpdateResult.Companion.getEMPTY());
        }
        Vm vm2 = vm;
        Object object = PsiSynchronizer.EP_NAME.findExtension(JavaScriptSynchronizer.class);
        Intrinsics.checkNotNull((Object)object);
        JavaScriptSynchronizer javaScriptSynchronizer = (JavaScriptSynchronizer)object;
        List<VirtualFile> list = EffectiveFileScriptProcessor.getEffectiveFiles((Collection<? extends VirtualFile>)javaScriptSynchronizer.getIncorrectFiles(), debugProcess, vm2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectiveFiles(...)");
        if (this.notifyIfHasIncorrectFiles(list, debugProcess)) {
            return Promises.rejectedPromise((String)"incorrect files");
        }
        List<VirtualFile> files = this.collectPendingFiles(null, (XDebugProcess)debugProcess, javaScriptSynchronizer);
        if (files.isEmpty()) {
            return Promises.resolvedPromise((Object)UpdateResult.Companion.getEMPTY());
        }
        return this.doUpdate(files, debugProcess, vm2, javaScriptSynchronizer, null);
    }

    public final boolean notifyIfHasIncorrectFiles(@NotNull List<? extends VirtualFile> incorrectFiles, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(incorrectFiles, (String)"incorrectFiles");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (incorrectFiles.isEmpty()) {
            return false;
        }
        for (VirtualFile virtualFile : incorrectFiles) {
            ApplicationUpdaterKt.access$notifyFileHasErrors(virtualFile, (XDebugProcess)debugProcess);
        }
        return true;
    }

    @NotNull
    public final Promise<?> autoTriggeredUpdate(@NotNull EffectiveFileScriptProcessor result, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        if (result.getTransformedFiles().isEmpty()) {
            List<VirtualFile> list = result.getEffectiveFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectiveFiles(...)");
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
            return this.autoTriggeredUpdate(list, javaScriptDebugProcess, vm, synchronizer, null);
        }
        JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
        Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
        this.restartOrNotify$intellij_js_liveEdit((XDebugProcess)javaScriptDebugProcess);
        return Promises.rejectedPromise();
    }

    @NotNull
    public final Promise<? extends Object> autoTriggeredUpdate(@NotNull List<VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer, @Nullable SetSourceExecutor setSourceExecutor) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        this.collectPendingFiles(files, (XDebugProcess)debugProcess, synchronizer);
        if (!files.isEmpty()) {
            Promise<UpdateResult> updateResult = this.doUpdate(files, debugProcess, vm, synchronizer, setSourceExecutor);
            updateResult.onSuccess(arg_0 -> ApplicationUpdater.autoTriggeredUpdate$lambda$1(arg_0 -> ApplicationUpdater.autoTriggeredUpdate$lambda$0(debugProcess, arg_0), arg_0));
            return updateResult;
        }
        return Promises.resolvedPromise();
    }

    @NotNull
    public final List<VirtualFile> collectPendingFiles(@Nullable List<VirtualFile> result, @NotNull XDebugProcess debugProcess, @NotNull InSingleFileBasedSynchronizer synchronizer) {
        List list;
        Set<VirtualFile> pendingFiles;
        UpdateState updateState;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        List newResult = result;
        UpdateState updateState2 = updateState = this.processToState.get(debugProcess);
        Set<Object> set = pendingFiles = updateState2 != null ? updateState2.getModifiedFiles() : null;
        if (!ContainerUtil.isEmpty((Collection)pendingFiles)) {
            Set<VirtualFile> set2 = pendingFiles;
            Intrinsics.checkNotNull(set2);
            Iterator<VirtualFile> iterator = set2.iterator();
            while (iterator.hasNext()) {
                VirtualFile pendingFile = iterator.next();
                if (!synchronizer.canHandle(pendingFile.getFileType(), debugProcess.getSession().getProject())) continue;
                iterator.remove();
                if (newResult == null) {
                    newResult = (List)new SmartList();
                }
                newResult.add(pendingFile);
            }
        }
        if ((list = newResult) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<UpdateResult> doUpdate(@NotNull List<? extends VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer, @Nullable SetSourceExecutor setSourceExecutor) {
        boolean bl;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        boolean bl2 = bl = !((Collection)files).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        CharSequence[] sources = ApplicationUpdaterKt.access$collectSources((XDebugProcess)debugProcess, synchronizer, files);
        if (sources == null) {
            this.getState((XDebugProcess)debugProcess).getModifiedFiles().addAll((Collection<VirtualFile>)files);
            return Promises.rejectedPromise();
        }
        if (setSourceExecutor == null) {
            return this.updateScripts(files, debugProcess, vm, sources);
        }
        SmartList totalResult = new SmartList();
        int length = files.size();
        for (int i = 0; i < length; ++i) {
            totalResult.addAll((Collection)setSourceExecutor.execute(files.get(i), sources[i]));
        }
        Promise promise = Promises.all((Collection)((Collection)totalResult)).then(arg_0 -> ApplicationUpdater.doUpdate$lambda$2(new Function1(files){
            final /* synthetic */ List<VirtualFile> $files;
            {
                this.$files = $files;
            }

            public final UpdateResult invoke(Object it) {
                return new UpdateResult((Set<? extends VirtualFile>)new HashSet<E>(this.$files));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final UpdateState getState(XDebugProcess debugProcess) {
        UpdateState updateState = this.processToState.get(debugProcess);
        if (updateState == null) {
            updateState = new UpdateState();
            UpdateState prevState = this.processToState.putIfAbsent(debugProcess, updateState);
            if (prevState != null) {
                return prevState;
            }
            Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
            Disposer.register((Disposable)((Disposable)debugProcess), () -> ApplicationUpdater.getState$lambda$3(this, debugProcess));
        }
        return updateState;
    }

    private final Promise<UpdateResult> updateScripts(List<? extends VirtualFile> files, JavaScriptDebugProcess<?> debugProcess, Vm vm, CharSequence[] sources) {
        MyFileScriptProcessor processor = new MyFileScriptProcessor(debugProcess, vm);
        int length = files.size();
        for (int i = 0; i < length; ++i) {
            processor.reset(files.get(i));
            processor.setSource(sources[i]);
            vm.getScriptManager().forEachScript(arg_0 -> ApplicationUpdater.updateScripts$lambda$4(processor, arg_0));
        }
        if (processor.getTotalResult().isEmpty()) {
            return Promises.resolvedPromise((Object)UpdateResult.Companion.getEMPTY());
        }
        Promise promise = Promises.collectResults$default((Collection)((Collection)processor.getTotalResult()), (boolean)false, (int)1, null).then(arg_0 -> ApplicationUpdater.updateScripts$lambda$7(ApplicationUpdater::updateScripts$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    public final void restartOrNotify$intellij_js_liveEdit(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (LiveEditOptions.getInstance().isRestartIfHotSwapFailed()) {
            ApplicationUpdaterKt.restart(debugProcess);
            UpdateState state = this.getState(debugProcess);
            SingletonNotificationManager lastRestartedOnHotSwapFailedNotification = state.getLastRestartedOnHotSwapFailedNotification();
            if (lastRestartedOnHotSwapFailedNotification == null) {
                String string = LiveEditBundle.message("settings.notifications.hotswap.failed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                lastRestartedOnHotSwapFailedNotification = new SingletonNotificationManager(string, NotificationType.INFORMATION);
                state.setLastRestartedOnHotSwapFailedNotification(lastRestartedOnHotSwapFailedNotification);
            }
            XDebugSession xDebugSession = debugProcess.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
            XDebugSession session = xDebugSession;
            String content = session.getSessionName() + ": " + LiveEditBundle.message("disable.restart.if.hotswap.failed", new Object[0]);
            lastRestartedOnHotSwapFailedNotification.notify("", content, session.getProject(), ApplicationUpdater::restartOrNotify$lambda$8);
        } else {
            RestartRequiredNotificationItem restartNotificationItem = this.markAsRestartRequired(debugProcess);
            if (!restartNotificationItem.hasActiveNotification()) {
                restartNotificationItem.notify(LiveEditBundle.message("restart.required", new Object[0]) + LiveEditBundle.message("enable.restart.if.hotswap.failed", new Object[0]));
            }
        }
    }

    private final RestartRequiredNotificationItem markAsRestartRequired(XDebugProcess debugProcess) {
        UpdateState state = this.getState(debugProcess);
        RestartRequiredNotificationItem restartNotificationItem = state.getNotificationItem();
        if (restartNotificationItem == null) {
            restartNotificationItem = new RestartRequiredNotificationItem(debugProcess);
            state.setNotificationItem(restartNotificationItem);
            state.getModifiedFiles().clear();
        }
        return restartNotificationItem;
    }

    public final boolean checkIsBlackListed(@NotNull XDebugProcess debugProcess, boolean notify) {
        RestartRequiredNotificationItem restartNotificationItem;
        UpdateState state;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        UpdateState updateState = state = this.processToState.get(debugProcess);
        RestartRequiredNotificationItem restartRequiredNotificationItem = restartNotificationItem = updateState != null ? updateState.getNotificationItem() : null;
        if (restartNotificationItem != null) {
            if (notify && !restartNotificationItem.hasActiveNotification()) {
                this.restartOrNotify$intellij_js_liveEdit(debugProcess);
            }
            return true;
        }
        return false;
    }

    public final void scheduleUpdateScripts(@NotNull EffectiveFileScriptProcessor result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.getTransformedFiles().isEmpty()) {
            List<VirtualFile> list = result.getEffectiveFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectiveFiles(...)");
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
            this.schedule(list, (XDebugProcess)javaScriptDebugProcess);
        } else {
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
            this.markAsRestartRequired((XDebugProcess)javaScriptDebugProcess);
        }
    }

    public final void schedule(@NotNull List<? extends VirtualFile> files, @NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.getState(debugProcess).getModifiedFiles().addAll((Collection<VirtualFile>)files);
    }

    public final void clearUpdateState(@NotNull XDebugProcess debugProcess, boolean remove) {
        block2: {
            SingletonNotificationManager lastRestartedOnHotSwapFailedNotification;
            RestartRequiredNotificationItem notificationItem;
            UpdateState state;
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            UpdateState updateState = state = remove ? this.processToState.remove(debugProcess) : this.processToState.get(debugProcess);
            if (state == null) break block2;
            RestartRequiredNotificationItem restartRequiredNotificationItem = notificationItem = state.getNotificationItem();
            if (restartRequiredNotificationItem != null) {
                restartRequiredNotificationItem.clear();
            }
            SingletonNotificationManager singletonNotificationManager = lastRestartedOnHotSwapFailedNotification = state.getLastRestartedOnHotSwapFailedNotification();
            if (singletonNotificationManager != null) {
                singletonNotificationManager.clear();
            }
        }
    }

    private static final Unit autoTriggeredUpdate$lambda$0(JavaScriptDebugProcess $debugProcess, UpdateResult it) {
        Set set = SetsKt.emptySet();
        Intrinsics.checkNotNull((Object)it);
        ApplicationUpdaterKt.notifyAboutUpdates($debugProcess, set, it, UpdateResult.Companion.getEMPTY(), true);
        return Unit.INSTANCE;
    }

    private static final void autoTriggeredUpdate$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final UpdateResult doUpdate$lambda$2(Function1 $tmp0, Object p0) {
        return (UpdateResult)$tmp0.invoke(p0);
    }

    private static final void getState$lambda$3(ApplicationUpdater this$0, XDebugProcess $debugProcess) {
        this$0.clearUpdateState($debugProcess, true);
    }

    private static final boolean updateScripts$lambda$4(MyFileScriptProcessor $processor, Script it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $processor.process(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final UpdateResult updateScripts$lambda$6(List it) {
        void $this$mapTo$iv$iv;
        int unchangedCount = 0;
        for (UpdateScriptResult result : it) {
            if (result.status == ScriptLiveChangeResult.ChangeStatus.CHANGED) {
                return UpdateResult.Companion.getRESTART_REQUIRED();
            }
            if (result.status != ScriptLiveChangeResult.ChangeStatus.UNCHANGED) continue;
            ++unchangedCount;
        }
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void t;
            UpdateScriptResult updateScriptResult = (UpdateScriptResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(t.file);
        }
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new UpdateResult(set);
    }

    private static final UpdateResult updateScripts$lambda$7(Function1 $tmp0, Object p0) {
        return (UpdateResult)$tmp0.invoke(p0);
    }

    private static final void restartOrNotify$lambda$8(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setListener((NotificationListener)ApplicationUpdaterKt.access$getDISABLE_AUTO_RESTART_IF_HOTSWAP_FAILED_NOTIFICATION_LISTENER$p());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/jetbrains/liveEdit/update/ApplicationUpdater$MyFileScriptProcessor;", "Lcom/jetbrains/liveEdit/update/FileScriptProcessor;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "vm", "Lorg/jetbrains/debugger/Vm;", "<init>", "(Lcom/jetbrains/liveEdit/update/ApplicationUpdater;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;)V", "updateConfiguration", "Lcom/jetbrains/liveEdit/update/UpdateConfiguration;", "getUpdateConfiguration", "()Lcom/jetbrains/liveEdit/update/UpdateConfiguration;", "totalResult", "Lcom/intellij/util/SmartList;", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/liveEdit/update/UpdateScriptResult;", "getTotalResult", "()Lcom/intellij/util/SmartList;", "state", "Lcom/jetbrains/liveEdit/update/UpdateState;", "getState", "()Lcom/jetbrains/liveEdit/update/UpdateState;", "source", "", "getSource", "()Ljava/lang/CharSequence;", "setSource", "(Ljava/lang/CharSequence;)V", "process", "", "script", "Lorg/jetbrains/debugger/Script;", "intellij.js.liveEdit"})
    private final class MyFileScriptProcessor
    extends FileScriptProcessor {
        @NotNull
        private final Vm vm;
        @Nullable
        private final UpdateConfiguration updateConfiguration;
        @NotNull
        private final SmartList<Promise<UpdateScriptResult>> totalResult;
        @NotNull
        private final UpdateState state;
        @Nullable
        private CharSequence source;

        public MyFileScriptProcessor(@NotNull JavaScriptDebugProcess<?> debugProcess, Vm vm) {
            Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            super(debugProcess);
            this.vm = vm;
            this.updateConfiguration = ApplicationUpdaterKt.getUpdateConfiguration((XDebugProcess)debugProcess);
            this.totalResult = new SmartList();
            this.state = ApplicationUpdater.this.getState((XDebugProcess)debugProcess);
        }

        @Nullable
        public final UpdateConfiguration getUpdateConfiguration() {
            return this.updateConfiguration;
        }

        @NotNull
        public final SmartList<Promise<UpdateScriptResult>> getTotalResult() {
            return this.totalResult;
        }

        @NotNull
        public final UpdateState getState() {
            return this.state;
        }

        @Nullable
        public final CharSequence getSource() {
            return this.source;
        }

        public final void setSource(@Nullable CharSequence charSequence) {
            this.source = charSequence;
        }

        public boolean process(@NotNull Script script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            if (this.isScriptFile(script.getUrl())) {
                CharSequence text = this.source;
                if (this.updateConfiguration != null) {
                    CharSequence charSequence = text;
                    Intrinsics.checkNotNull((Object)charSequence);
                    text = this.updateConfiguration.preprocessSource(charSequence);
                }
                CharSequence charSequence = text;
                Intrinsics.checkNotNull((Object)charSequence);
                VirtualFile virtualFile = this.file;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                JavaScriptDebugProcess javaScriptDebugProcess = this.debugProcess;
                Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugProcess, (String)"debugProcess");
                this.totalResult.add((Object)ApplicationUpdaterKt.access$setScriptSource(charSequence, script, this.vm, virtualFile, (XDebugProcess)javaScriptDebugProcess, this.state));
                return false;
            }
            return true;
        }
    }
}

